/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.BeanInfo;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabData;
import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.crosstab.CrosstabGridlinePainter;
import oracle.dss.crosstab.CrosstabTips;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewData;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyAttributes;
import oracle.dss.gridView.GridViewDatabodyInputHandler;
import oracle.dss.gridView.GridViewDatabodyXML;
import oracle.dss.gridView.GridViewTextPainter;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitData;
import oracle.dss.util.xml.ObjectNode;

public class CrosstabDatabody
extends PivotGrid
implements GridViewDatabody,
ViewStyleCallback,
GridViewDatabodyAttributes {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected Crosstab crosstab = null;
    public static final boolean visible = true;
    public static final String a_visible = "visible";
    protected GridViewAppearanceMgr appearanceMgr = null;
    private boolean bodyHighlighter = CrosstabDefaultValues.isBodyHighlighterVisible();
    private boolean rowHighlighter = CrosstabDefaultValues.isRowHighlighterVisible();
    private boolean columnHighlighter = CrosstabDefaultValues.isColumnHighlighterVisible();
    protected CrosstabTips tips = null;
    protected ViewStyle defaultViewStyle = null;
    private ResourceBundle gBundle = null;
    private ResourceBundle cBundle = null;
    private static final String m_method_styleChanged = "styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue)";
    private static final String m_method_updateforpropset = "updateForPropSet(BitSet bs)";
    private static final String m_method_isdrillout = "isDrillOut(int column, int row, int x, int y)";
    private static final String m_method_getgraphicimage = "getGraphicImage(int column, int row)";
    private static final String m_method_getgraphicbarratio = "getGraphicBarRatio(int column, int row)";
    private static final String m_method_setViewStyle = "void setViewStyle(ViewStyle vs)";
    private static final String m_method_isAnnotation = "isAnnotation(int column, int row, int x, int y)";
    private GridViewDatabodyXML _viewDatabodyXML;

    public CrosstabDatabody(Crosstab ct) {
        super((TwoDModel)ct.getCrosstabModel().getCrosstabDataSource());
        this.crosstab = ct;
        this.updateResourceBundle(this.crosstab.getLocale());
        this.appearanceMgr = new GridViewAppearanceMgr(this.crosstab, this);
        this.setAppearanceManager(this.appearanceMgr);
        this.setPainter((Painter)new GridViewTextPainter(this.crosstab));
        this.getGrid().setHorizontalSeparatorPainter((Painter)new CrosstabGridlinePainter(true, false));
        this.getGrid().setVerticalSeparatorPainter((Painter)new CrosstabGridlinePainter(false, false));
        this.getGrid().setSelectionTransparent(true);
        this.getGrid().setDrawSelectionBorder(true);
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.crosstab, this.getDefaultAppearance());
        this.defaultViewStyle.setViewStyleCallback(this);
        this.appearanceMgr.setAppearance(this.defaultViewStyle);
        GridViewDatabodyInputHandler ctdbhandler = new GridViewDatabodyInputHandler(ct);
        Grid grid = this.getGrid();
        grid.setDefaultInputHandler((CellInputHandler)ctdbhandler);
        HandleInputHandler hihandler = new HandleInputHandler();
        this.getRowHeader().setItemInputHandler((HeaderItemInputHandler)hihandler);
        this.getColumnHeader().setItemInputHandler((HeaderItemInputHandler)hihandler);
        this._viewDatabodyXML = new GridViewDatabodyXML(this);
    }

    public CrosstabData getCrosstabData() {
        return (CrosstabData)this.getModel();
    }

    @Override
    public GridViewData getGridViewData() {
        return (GridViewData)this.getModel();
    }

    @Override
    public int getID() {
        return 9;
    }

    @Override
    public String getComponentName() {
        return this.crosstab.getNameFromID(9);
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    public void setPainter(Painter painter) {
        this.getGrid().setDefaultPainter(painter);
    }

    public Painter getPainter() {
        return this.getGrid().getDefaultPainter();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        super.setVisible(visible);
        this.crosstab.firePropertyChange(this, "Visible", new Boolean(old), new Boolean(visible));
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public ViewStyle getViewStyle() {
        return this.defaultViewStyle;
    }

    @Override
    public void setViewStyle(ViewStyle vs) {
        if (vs == null) {
            this.crosstab.getErrorHandler().log("invalid ViewStyle", this.getClass().getName(), m_method_setViewStyle);
            return;
        }
        ViewStyle oldval = this.defaultViewStyle;
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.crosstab, vs);
        this.defaultViewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(oldval, this.defaultViewStyle));
        this.crosstab.firePropertyChange(this, "ViewStyle", oldval, this.defaultViewStyle);
    }

    protected void propSet() {
        this.crosstab.getCrosstabModel().getGridViewDatabodyStyleManager().dataStyleChanged();
        this.clearCache();
    }

    @Override
    public void styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        if (attributeId < 0 || attributeId > 37) {
            this.crosstab.getErrorHandler().log("invalid view style attribute", this.getClass().getName(), m_method_styleChanged);
            return;
        }
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(attributeId));
        this.crosstab.firePropertyChange(this, attributeName, oldValue, newValue);
    }

    protected void updateForPropSet(BitSet bs) {
        if (bs == null) {
            this.crosstab.getErrorHandler().log("invalid bit set", this.getClass().getName(), m_method_updateforpropset);
            return;
        }
        this.propSet();
        if (bs.get(1) || bs.get(3) || bs.get(4) || bs.get(5) || bs.get(6) || bs.get(27) || bs.get(26) || bs.get(28) || bs.get(25) || bs.get(7) || bs.get(8) || bs.get(36) || bs.get(16) || bs.get(18)) {
            this.crosstab.updateRowHeights();
        }
        if (bs.get(3) || bs.get(4) || bs.get(6) || bs.get(26) || bs.get(28) || bs.get(8) || bs.get(37) || bs.get(18)) {
            this.crosstab.updateColumnWidth();
        }
        if ((bs.get(32) || bs.get(33)) && this.appearanceMgr != null) {
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getAppearance();
            if (bs.get(32)) {
                app.setEditBackground(this.defaultViewStyle.getEditBackground());
            }
            if (bs.get(33)) {
                app.setEditForeground(this.defaultViewStyle.getEditForeground());
            }
            appMgr.setAppearance(app);
        }
        this.crosstab.repaint();
    }

    @Override
    public boolean isDrillOut(int column, int row, int x, int y) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        boolean drillOut = false;
        Image image = this.getGraphicImage(column, row);
        int rowHeight = this.getGrid().getRowHeight(row);
        float align = this.getGrid().getCellPaintContext(column, row).getInteriorAlignmentY();
        int width = 0;
        int height = 0;
        if (image != null) {
            int xMax;
            int xMin;
            width = image.getWidth((ImageObserver)((Object)this));
            height = image.getHeight((ImageObserver)((Object)this));
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getCellAppearance(column, row);
            ImmInsets insets = app.getInsets();
            boolean l2r = true;
            if (l2r) {
                xMin = insets.left;
                xMax = insets.left + width;
            } else {
                int colWidth = this.getColumnWidth(column);
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            drillOut = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= height;
        }
        return drillOut;
    }

    @Override
    public Image getGraphicImage(int column, int row) {
        return this.getGraphicImage(column, row, true);
    }

    public Image getGraphicImage(int column, int row, boolean scaled) {
        boolean bl = scaled = scaled && this.crosstab.isImagesScaled();
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        if (this.crosstab.getWaitDataForRow(row) != null) {
            return null;
        }
        int index = this.appearanceMgr.getCellAppearance(column, row).getGraphicImageIndex();
        if (index >= 0 && index < this.crosstab.getGraphicImageCount()) {
            if (scaled) {
                return this.crosstab.getScaledGraphicImage(index);
            }
            return this.crosstab.getGraphicImage(index);
        }
        return null;
    }

    @Override
    public void clearCache() {
        if (this.appearanceMgr != null) {
            this.appearanceMgr.clearCache();
        }
    }

    @Override
    public ComponentInfo getCellFocus() {
        Component focusCellComponent = this.getPivotTable().getGlobalFocusCellComponent();
        if (focusCellComponent != null && focusCellComponent == this.getPivotTable().getPivotGrid().getGrid()) {
            Cell globalFocusCell = this.getPivotTable().getGlobalFocusCell();
            return new DataComponentInfo(globalFocusCell.row, globalFocusCell.column);
        }
        return null;
    }

    @Override
    public void setCellFocus(ComponentInfo focusedCell) {
        if (focusedCell == null) {
            this.getPivotTable().setGlobalFocusCell(null, null);
        }
        if (focusedCell instanceof DataComponentInfo) {
            DataComponentInfo dci = (DataComponentInfo)focusedCell;
            this.getPivotTable().setGlobalFocusCell(new Cell(dci.getColumn(), dci.getRow()), (Component)this.getPivotTable().getPivotGrid().getGrid());
            this.getGrid().scrollCellIntoView(dci.getColumn(), dci.getRow());
            if (this.crosstab.isFocusRequestedForCell()) {
                this.requestFocus();
            }
        }
    }

    @Override
    public Appearance getDefaultAppearance() {
        Appearance app = ((Appearance)UIManager.get("Grid.DefaultAppearance")).copy();
        ImmInsets insets = app.getInsets();
        int top = 0;
        int bottom = 0;
        int right = 0;
        int left = 0;
        left = insets.left < 3 ? 3 : insets.left;
        right = insets.right < 3 ? 3 : insets.right;
        top = insets.top < 3 ? 3 : insets.top;
        bottom = insets.bottom < 3 ? 3 : insets.bottom;
        ImmInsets newInsets = new ImmInsets(top, left, bottom, right);
        app.setInsets(newInsets);
        app.setBackground(Color.white);
        if (app.getForeground() == null) {
            app.setForeground(Color.black);
        }
        app.setHorizontalJustify(2);
        app.setVerticalJustify(1);
        return app;
    }

    protected boolean isSelectAllEnabled() {
        return this.bodyHighlighter;
    }

    @Override
    public float getGraphicBarRatio(int column, int row) {
        float f;
        block9: {
            if (column < 0) {
                this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getgraphicbarratio);
                return 0.0f;
            }
            if (row < 0) {
                this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getgraphicbarratio);
                return 0.0f;
            }
            f = 0.0f;
            try {
                int modelCol = this.crosstab.getCrosstabModel().getDataFromTableCol(column);
                int modelRow = this.crosstab.getCrosstabModel().getDataFromTableRow(row);
                if (this.crosstab.getWaitDataForRow(row) != null) {
                    return 0.0f;
                }
                if (this.crosstab.isDataRatioSupported()) {
                    Object object = this.crosstab.getCrosstabModel().getDataAccess().getValue(modelRow, modelCol, "dataRatio");
                    if (object instanceof Float) {
                        f = ((Float)object).floatValue();
                    } else if (object instanceof WaitData) {
                        this.crosstab.setWaitDataForRow(row, (WaitData)object);
                        return 0.0f;
                    }
                    break block9;
                }
                return 0.0f;
            }
            catch (DataException e) {
                this.crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_getgraphicbarratio);
                return 0.0f;
            }
        }
        return f;
    }

    @Override
    public void setXML(ObjectNode node, String version, int reset) {
        this._viewDatabodyXML.setXML(node, version, reset);
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this._viewDatabodyXML.getXML(allProperties);
    }

    void setBodyHighlighterVisible(boolean b) {
        this.bodyHighlighter = b;
        this.repaintInterior();
    }

    boolean isBodyHighlighterVisible() {
        return this.bodyHighlighter;
    }

    void setColumnHighlighterVisible(boolean b) {
        this.setColumnHeaderVisible(b);
        this.columnHighlighter = b;
    }

    boolean isColumnHighlighterVisible() {
        return this.columnHighlighter;
    }

    void setRowHighlighterVisible(boolean b) {
        this.setRowHeaderVisible(b);
        this.rowHighlighter = b;
        this.doLayout();
    }

    boolean isRowHighlighterVisible() {
        return this.rowHighlighter;
    }

    void setCellEditingAllowed(boolean b) {
        this.repaintInterior();
    }

    protected void resetToDefault(int reset) {
        this._viewDatabodyXML.resetToDefault();
        this.defaultViewStyle.resetToDefault(reset);
        this.appearanceMgr.setAppearance(this.defaultViewStyle);
        this.propSet();
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc);
            this.cBundle = ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle", loc);
        } else {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
            this.cBundle = ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle");
        }
    }

    @Override
    public boolean isAnnotation(int column, int row, int x, int y) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_isAnnotation);
            return false;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isAnnotation);
            return false;
        }
        if (!this.crosstab.isAnnotationIconVisible()) {
            return false;
        }
        boolean bAnnotation = false;
        boolean bInAnnotationImage = false;
        bAnnotation = this.crosstab.getGridViewModel().getGridViewDataSource().getAnnotation(column, row) != null;
        int width = 0;
        int height = 0;
        if (bAnnotation) {
            int xMax;
            int xMin;
            Image image = this.crosstab.getAnnotationImage();
            int rowHeight = this.getGrid().getRowHeight(row);
            float align = this.getGrid().getCellPaintContext(column, row).getInteriorAlignmentY();
            width = image.getWidth((ImageObserver)((Object)this));
            height = image.getHeight((ImageObserver)((Object)this));
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getCellAppearance(column, row);
            ImmInsets insets = app.getInsets();
            boolean l2r = true;
            if (!l2r) {
                int colWidth = this.getColumnWidth(column);
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
                if (this.getGraphicImage(column, row) != null) {
                    xMin -= this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this));
                    xMax -= this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this));
                }
            } else {
                xMin = insets.left;
                xMax = insets.left + width;
                if (this.getGraphicImage(column, row) != null) {
                    xMin += this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this)) + 1;
                    xMax += this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this)) + 1;
                }
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            bInAnnotationImage = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= height;
        }
        return bInAnnotationImage;
    }

    protected PivotGrid.PivotGridGrid createPivotGridGrid(TwoDModel model) {
        return new CrosstabPivotGridGrid(model);
    }

    protected PivotGrid.PivotGridHeader createPivotGridColumnHeader(OneDModel model) {
        return new CrosstabPivotGridHeader(model, 0);
    }

    protected PivotGrid.PivotGridHeader createPivotGridRowHeader(OneDModel model) {
        return new CrosstabPivotGridHeader(model, 1);
    }

    public class CrosstabPivotGridHeader
    extends PivotGrid.PivotGridHeader {
        private static final long serialVersionUID = 1L;
        int orientation;

        public CrosstabPivotGridHeader(OneDModel ds, int orientation) {
            super((PivotGrid)CrosstabDatabody.this, ds, orientation);
            this.orientation = orientation;
        }

        protected void scrollItemIntoView(int item) {
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(true);
            }
            super.scrollItemIntoView(item);
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(false);
            }
        }

        protected Header.AccessibleHeader createAccessibleHeader() {
            return new CrosstabAccessibleHeader();
        }

        public class CrosstabAccessibleHeader
        extends Header.AccessibleHeader {
            private static final long serialVersionUID = 1L;

            public CrosstabAccessibleHeader() {
                super((Header)CrosstabPivotGridHeader.this);
            }

            public String getAccessibleName(int index) {
                String accessibleName = "";
                try {
                    accessibleName = CrosstabPivotGridHeader.this.orientation == 0 ? MessageFormat.format(CrosstabDatabody.this.cBundle.getString("Column Handle for"), (String)CrosstabDatabody.this.crosstab.getCrosstabModel().getDataAccess().getSliceLabel(0, index, "label")) : (CrosstabPivotGridHeader.this.orientation == 1 ? MessageFormat.format(CrosstabDatabody.this.cBundle.getString("Row Handle for"), (String)CrosstabDatabody.this.crosstab.getCrosstabModel().getDataAccess().getSliceLabel(1, index, "label")) : super.getAccessibleName(index));
                }
                catch (EdgeOutOfRangeException re) {
                }
                catch (SliceOutOfRangeException sliceOutOfRangeException) {
                    // empty catch block
                }
                return accessibleName;
            }
        }
    }

    public class CrosstabPivotGridGrid
    extends PivotGrid.PivotGridGrid {
        private static final long serialVersionUID = 1L;

        public CrosstabPivotGridGrid(TwoDModel ds) {
            super((PivotGrid)CrosstabDatabody.this, ds);
        }

        public void scrollColumnIntoView(int column) {
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(true);
            }
            super.scrollColumnIntoView(column);
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(false);
            }
        }

        public void scrollRowIntoView(int row) {
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(true);
            }
            super.scrollRowIntoView(row);
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(false);
            }
        }

        public void scrollCellIntoView(int column, int row) {
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(true);
            }
            super.scrollCellIntoView(column, row);
            if (CrosstabDatabody.this.crosstab != null) {
                CrosstabDatabody.this.crosstab.setDuringScroll(false);
            }
        }

        protected Grid.AccessibleGrid createAccessibleGrid() {
            return new CrosstabAccessibleGrid();
        }

        protected class CrosstabAccessibleGrid
        extends Grid.AccessibleGrid {
            private static final long serialVersionUID = 1L;

            public CrosstabAccessibleGrid() {
                super((Grid)CrosstabPivotGridGrid.this);
            }

            protected String getAccessibleNameForTable(int column, int row, Object data, String cellName) {
                String accessibleName = "";
                try {
                    accessibleName = MessageFormat.format(CrosstabDatabody.this.cBundle.getString("AccessibleNameForTable"), (String)CrosstabDatabody.this.crosstab.getCrosstabModel().getDataAccess().getSliceLabel(0, column, "label"), (String)CrosstabDatabody.this.crosstab.getCrosstabModel().getDataAccess().getSliceLabel(1, row, "label"), cellName);
                }
                catch (EdgeOutOfRangeException re) {
                }
                catch (SliceOutOfRangeException se) {
                    // empty catch block
                }
                return accessibleName;
            }

            protected String getAccessibleName(int column, int row, Object data) {
                Object annotation;
                boolean bAnnotation;
                String accessibleName = super.getAccessibleName(column, row, data);
                boolean bNameStarting = true;
                Image im = CrosstabDatabody.this.getGraphicImage(column, row);
                if (im != null) {
                    accessibleName = MessageFormat.format(CrosstabDatabody.this.gBundle.getString("Graphic Image"), accessibleName);
                    bNameStarting = false;
                }
                boolean graphicBarVisible = false;
                boolean horizontalPageBreak = false;
                ViewStyle appearance = ((GridViewAppearanceMgr)CrosstabPivotGridGrid.this.getAppearanceManager()).getCellAppearance(column, row);
                if (appearance instanceof ViewStyle) {
                    graphicBarVisible = appearance.isGraphicBarVisible();
                    horizontalPageBreak = appearance.isHPageBreak();
                }
                if (graphicBarVisible) {
                    accessibleName = im != null ? MessageFormat.format(CrosstabDatabody.this.gBundle.getString("Bar 1"), accessibleName) : MessageFormat.format(CrosstabDatabody.this.gBundle.getString("Bar 2"), accessibleName);
                    bNameStarting = false;
                }
                boolean bl = bAnnotation = (annotation = CrosstabDatabody.this.crosstab.getGridViewModel().getGridViewDataSource().getAnnotation(column, row)) != null;
                if (bAnnotation) {
                    accessibleName = !bNameStarting ? MessageFormat.format(CrosstabDatabody.this.gBundle.getString("annotation 1"), accessibleName) : MessageFormat.format(CrosstabDatabody.this.gBundle.getString("annotation 2"), accessibleName);
                }
                if (horizontalPageBreak) {
                    accessibleName = MessageFormat.format(CrosstabDatabody.this.gBundle.getString("horiz break"), accessibleName);
                }
                return accessibleName;
            }
        }
    }

    private class HandleInputHandler
    extends NullInputHandler {
        private HandleInputHandler() {
        }

        public void mousePressed(MouseEvent e, Header header, int itemIndex) {
            boolean right = SwingUtilities.isRightMouseButton(e);
            if (right) {
                header.setArmedItem(itemIndex);
                OneDSelection selection = header.getSelection();
                if (!selection.contains(itemIndex)) {
                    try {
                        header.deselectAll();
                        OneDSelection sel = new OneDSelection(itemIndex);
                        header.setSelection(sel);
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
            header.setArmedItem(-1);
        }
    }
}

