/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.io.Serializable;
import java.util.Hashtable;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.gridView.GridViewData;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.WaitData;

public class CrosstabData
extends AbstractTwoDModel
implements GridViewData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int m_colCount = 0;
    protected int m_rowCount = 0;
    protected DataAccess dataAccess = null;
    private CrosstabModel crosstabModel;
    protected Crosstab m_crosstab = null;
    protected transient Hashtable valueCache = null;
    protected transient Hashtable m_annotationsCache = null;
    protected transient DataComponentInfo info = new DataComponentInfo(0, 0);
    private static final String m_method_getdata = "getData(int columnIndex, int rowIndex)";
    private static final String m_method_getrawdata = "getRawData(int columnIndex, int rowIndex)";
    private static final String m_method_setdata = "setData(int columnIndex, int rowIndex, Object data)";
    private static final String m_method_getAnnotation = "getAnnotation(int column, int row)";

    public CrosstabData(CrosstabModel tm, Crosstab _crosstab) {
        this.valueCache = new Hashtable();
        this.m_annotationsCache = new Hashtable();
        this.crosstabModel = tm;
        this.dataAccess = this.crosstabModel.getDataAccess();
        try {
            this.m_colCount = this.dataAccess.getEdgeExtent(0);
            this.m_rowCount = this.dataAccess.getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstabModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "CrosstabData");
        }
        this.m_crosstab = _crosstab;
    }

    public int getColumnCount() {
        return this.crosstabModel.getTableFromDataColumnCount(this.m_colCount);
    }

    public int getRowCount() {
        return this.crosstabModel.getTableFromDataRowCount(this.m_rowCount);
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        if (rowIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        int col = this.crosstabModel.getDataFromTableCol(columnIndex);
        int row = this.crosstabModel.getDataFromTableRow(rowIndex);
        this.info.setRowCol(row, col);
        String prevVal = null;
        prevVal = (String)this.valueCache.get(this.info);
        if (prevVal != null) {
            return prevVal;
        }
        try {
            Object object = null;
            WaitData data = null;
            if (this.m_crosstab.getWaitDataForRow(row) != null) {
                data = this.m_crosstab.getWaitDataForRow(row);
                return data.getCellMessage();
            }
            boolean bFormatted = false;
            if (this.m_crosstab.isDataFormattedSupported() && (object = this.m_crosstab.getValueFromDataAccess(col, row, "dataFormattedValue", this.dataAccess)) != null) {
                bFormatted = true;
            }
            if (!bFormatted && this.m_crosstab.isDataUnformattedSupported()) {
                object = this.m_crosstab.getValueFromDataAccess(col, row, "dataValue", this.dataAccess);
            }
            if (object instanceof WaitData) {
                data = (WaitData)object;
                this.m_crosstab.setWaitDataForRow(row, data);
                return data.getCellMessage();
            }
            prevVal = bFormatted ? object.toString() : ((object = this.crosstabModel.getGridViewFormatManager().formatDataValue(this.m_crosstab, object, col, row, this.dataAccess.getEdgeCurrentHPos(2), this.crosstabModel.getViewFormat())) != null ? object.toString() : "");
        }
        catch (DataException e) {
            this.crosstabModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_getdata);
            return null;
        }
        if (prevVal == null) {
            prevVal = "";
        }
        this.valueCache.put(this.info.clone(), prevVal);
        return prevVal;
    }

    @Override
    public Object getRawData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        if (rowIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        try {
            int col = this.crosstabModel.getDataFromTableCol(columnIndex);
            int row = this.crosstabModel.getDataFromTableRow(rowIndex);
            Object object = null;
            WaitData data = null;
            if (this.m_crosstab.getWaitDataForRow(rowIndex) != null) {
                data = this.m_crosstab.getWaitDataForRow(rowIndex);
                return data;
            }
            if (this.m_crosstab.isDataUnformattedSupported() && (object = this.m_crosstab.getValueFromDataAccess(col, row, "dataValue", this.dataAccess)) instanceof WaitData) {
                data = (WaitData)object;
                this.m_crosstab.setWaitDataForRow(rowIndex, data);
                return data;
            }
            return object;
        }
        catch (DataException e) {
            this.crosstabModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_getrawdata);
            return null;
        }
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        if (columnIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setdata);
            return;
        }
        if (rowIndex < 0) {
            this.m_crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setdata);
            return;
        }
        try {
            this.clearCache();
            this.crosstabModel.getGridViewFormatManager().valueFormatChanged();
            this.crosstabModel.getGridViewDatabodyStyleManager().dataStyleChanged();
            this.dataAccess.setValue(data, this.crosstabModel.getDataFromTableRow(rowIndex), this.crosstabModel.getDataFromTableCol(columnIndex), "dataValue");
        }
        catch (DataException e) {
            this.crosstabModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_setdata);
        }
    }

    @Override
    public void clearCache() {
        if (this.valueCache != null) {
            this.valueCache.clear();
        }
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    @Override
    public Object getAnnotation(int column, int row) {
        if (column < 0) {
            this.m_crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        if (row < 0) {
            this.m_crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        int iCol = this.crosstabModel.getDataFromTableCol(column);
        int iRow = this.crosstabModel.getDataFromTableRow(row);
        this.info.setRowCol(iRow, iCol);
        String[] prevVal = null;
        prevVal = (String[])this.m_annotationsCache.get(this.info);
        if (prevVal != null) {
            return prevVal;
        }
        try {
            Object object = null;
            WaitData data = null;
            if (this.m_crosstab.getWaitDataForRow(iRow) != null) {
                data = this.m_crosstab.getWaitDataForRow(iRow);
                return null;
            }
            if (this.m_crosstab.isDataAnnotationSupported()) {
                object = this.dataAccess.getValue(iRow, iCol, "dataAnnotation");
            }
            if (object instanceof WaitData) {
                data = (WaitData)object;
                this.m_crosstab.setWaitDataForRow(iRow, data);
                return data.getCellMessage();
            }
            if (object != null && this.m_crosstab.getCustomAnnotationCallback() != null) {
                DataComponentHandle componentHandle = new DataComponentHandle(12, this.m_crosstab.getNameFromID(12), (Object)this.m_crosstab, row, column);
                object = this.m_crosstab.getCustomAnnotationCallback().getAnnotation(object, componentHandle);
            }
            if (object != null) {
                if (object instanceof String[]) {
                    boolean bNonNull = false;
                    prevVal = (String[])object;
                    for (int i = 0; i < prevVal.length; ++i) {
                        if (prevVal[i] == null) continue;
                        bNonNull = true;
                        break;
                    }
                    if (!bNonNull) {
                        prevVal = null;
                        this.crosstabModel.getErrorHandler().log("all lines in annotation null", this.getClass().getName(), m_method_getAnnotation);
                    }
                } else {
                    if (!(object instanceof String)) {
                        this.crosstabModel.getErrorHandler().log("annotation not String or String[]", this.getClass().getName(), m_method_getAnnotation);
                    }
                    prevVal = new String[]{object.toString()};
                }
            }
        }
        catch (DataException e) {
            this.crosstabModel.getErrorHandler().log("could not get annotation from data source", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        if (prevVal != null) {
            this.m_annotationsCache.put(this.info.clone(), prevVal);
        }
        return prevVal;
    }

    protected void clearAnnotationCache() {
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    void removeRows(int row, int number) {
        this.fireModelEvent(2005, row, number);
    }

    void addRows(int row, int number) {
        this.fireModelEvent(2004, row, number);
    }

    void removeColumns(int column, int number) {
        this.fireModelEvent(2002, column, number);
    }

    void addColumns(int column, int number) {
        this.fireModelEvent(2001, column, number);
    }

    void invalidateData() {
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    void invalidateRows() {
        this.fireModelEvent(2006, 0, this.getRowCount());
    }

    void invalidateColumns() {
        this.fireModelEvent(2003, 0, this.getColumnCount());
    }
}

