/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.ldap.jremtool.OidFanoutReplAgreement;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplEntry;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplNamingContext;
import oracle.ldap.jremtool.OidReplUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidReplica {
    private static final Pattern URL_PATTERN = Pattern.compile("ldap://(.*):(\\d+).*", 2);
    private static final OidReplLogger m_logger = OidReplLogger.getLogger(OidReplica.class.getName());
    private String m_host;
    private int m_port;
    private String m_replicaURI;
    private List<String> m_secondaryURIs = new Vector<String>();
    private String m_replicaSubEntryDN;
    private String m_bindDN;
    private String m_bindPwd;
    private String m_replicationDN;
    private String m_replPwd;
    private String m_replicaid;
    private String m_replicaState;
    private String m_replicaType;
    private String m_replicaVersion;
    private String m_seeAlso;
    private String m_pilotStartTime;
    private String m_pilotMode;
    private String m_emTargetName;
    private List<OidReplAgreement> m_agreements = new Vector<OidReplAgreement>();
    private LdapContext m_dirContext;
    private boolean m_isReplBind;
    private Set<String> m_attributeList;
    private OidReplContext m_replContext;

    public OidReplica() {
    }

    public OidReplica(String host, int port, String dn, String pwd, OidReplContext replContext) {
        this.m_replContext = replContext;
        this.setHost(host);
        this.setPort(port);
        this.setBindDN(dn);
        this.setBindPwd(pwd);
    }

    public OidReplica clone() {
        OidReplica newReplica = null;
        try {
            newReplica = (OidReplica)super.clone();
            if (this.m_secondaryURIs != null) {
                newReplica.m_secondaryURIs = new Vector<String>();
                for (String replicaURI : this.m_secondaryURIs) {
                    newReplica.addSecondaryURI(replicaURI);
                }
            }
            if (this.m_agreements != null) {
                newReplica.m_agreements = new Vector<OidReplAgreement>();
                for (OidReplAgreement agrmt : this.m_agreements) {
                    newReplica.addAgreement(agrmt);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newReplica;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int val) {
        this.m_port = val;
    }

    public void setReplicaURI(String uri) {
        this.m_replicaURI = uri;
    }

    public String getReplicaURI() {
        return this.m_replicaURI;
    }

    public void addSecondaryURI(String uri) {
        this.m_secondaryURIs.add(uri);
    }

    public static String[] getHostPortFromURI(String uri) {
        String host = null;
        String port = null;
        Matcher matcher = URL_PATTERN.matcher(uri);
        if (matcher.find()) {
            host = matcher.group(1);
            port = matcher.group(2);
            String[] hostPort = new String[]{host, port};
            return hostPort;
        }
        return null;
    }

    public List<String> getSecondaryURI() {
        return this.m_secondaryURIs;
    }

    public void setSecondaryURI(List<String> secondaryURI) {
        this.m_secondaryURIs = secondaryURI;
    }

    public String getReplicaSubEntryDN() {
        return this.m_replicaSubEntryDN;
    }

    public void setReplicaSubEntryDN(String dn) {
        this.m_replicaSubEntryDN = dn;
    }

    private void setReplicaSubEntryDN() {
        if (this.m_replicaid != null) {
            this.m_replicaSubEntryDN = String.format("orclreplicaid=%s,cn=replication configuration", this.m_replicaid);
        }
    }

    public String getBindDN() {
        return this.m_bindDN;
    }

    public void setBindDN(String dn) {
        this.m_bindDN = dn;
    }

    public void setBindPwd(String pwd) {
        this.m_bindPwd = pwd;
    }

    public String getBindPwd() {
        return this.m_bindPwd;
    }

    public String getReplDN() {
        return this.m_replicationDN;
    }

    public void setReplDN(String dn) {
        this.m_replicationDN = dn;
    }

    public void setReplDNAsBindDN(String dn) {
        this.m_bindDN = this.m_replicationDN = dn;
        this.m_isReplBind = true;
    }

    public void setReplicaState(String state) {
        this.m_replicaState = state;
    }

    public String getReplicaState() throws OidReplException {
        NamingEnumeration<SearchResult> res = null;
        SearchControls constraints = new SearchControls();
        m_logger.dump("Getting replica state for replica {1}", this.m_replicaid == null ? "NULL" : this.m_replicaid);
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        constraints.setSearchScope(0);
        try {
            this.m_dirContext.setRequestControls(null);
            res = this.m_dirContext.search(this.m_replicaSubEntryDN, "(objectclass=*)", constraints);
            while (res != null && res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute replicaState = OidReplUtil.getRequiredAttribute("orclreplicastate", atrs, true);
                if (replicaState == null) continue;
                this.m_replicaState = replicaState.get().toString();
            }
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                    res = null;
                }
            }
            catch (NamingException ne) {}
        }
        return this.m_replicaState;
    }

    public void setReplicaType(String type) {
        this.m_replicaType = type;
    }

    public String getReplicaType() {
        return this.m_replicaType;
    }

    public String getReplPwd() {
        return this.m_replPwd;
    }

    public void setReplDNPwd(String pwd) {
        this.m_replPwd = pwd;
    }

    public void setReplPwdAsBindPwd(String pwd) {
        this.m_bindPwd = this.m_replPwd = pwd;
    }

    public String getReplicaID() {
        return this.m_replicaid;
    }

    public void setReplicaID(String replicaid) {
        this.m_replicaid = replicaid;
        this.setReplicaSubEntryDN();
    }

    public void setReplicaID() throws OidReplException {
        this.m_replicaid = OidReplUtil.getReplicaId(this.m_host, this.m_port, this.m_bindDN, this.m_bindPwd, this.m_replContext);
        this.setReplicaSubEntryDN();
    }

    public String getReplicaVersion() {
        return this.m_replicaVersion;
    }

    public void setReplicaVersion(String version) {
        this.m_replicaVersion = version;
    }

    public void setSeeAlso(String seealso) {
        this.m_seeAlso = seealso;
    }

    public String getSeeAlso() {
        return this.m_seeAlso;
    }

    public void setPilotStartTime(String time) {
        this.m_pilotStartTime = time;
    }

    public String getPilotStartTime() {
        return this.m_pilotStartTime;
    }

    public void setPilotMode(String mode) {
        this.m_pilotMode = mode;
    }

    public String getPilotMode() {
        return this.m_pilotMode;
    }

    public String getEMTargetName() {
        return this.m_emTargetName;
    }

    public void setEMTargetName(String name) {
        this.m_emTargetName = name;
    }

    public List<? extends OidReplAgreement> getAllAgreements() {
        return this.m_agreements;
    }

    public void addAgreement(OidReplAgreement agreement) {
        this.m_agreements.add(agreement);
    }

    public void deleteAgreement(OidReplAgreement agreement) {
        this.m_agreements.remove(agreement);
    }

    public List<? extends OidReplAgreement> getSupplierAgreements() {
        Vector<OidFanoutReplAgreement> al = new Vector<OidFanoutReplAgreement>();
        Iterator<OidReplAgreement> it = this.m_agreements.iterator();
        int count = 0;
        while (it.hasNext()) {
            OidFanoutReplAgreement fanout;
            OidReplAgreement agrmt = it.next();
            if (agrmt.getAgreementType() != OidReplAgreement.OidReplAgreementType.OID_ONEWAY && agrmt.getAgreementType() != OidReplAgreement.OidReplAgreementType.OID_TWOWAY || !(fanout = (OidFanoutReplAgreement)agrmt).getSupplier().equals(this)) continue;
            al.add(fanout);
            ++count;
        }
        if (0 == count) {
            return null;
        }
        return al;
    }

    public List<? extends OidReplAgreement> getConsumerAgreements() {
        Vector<OidFanoutReplAgreement> al = new Vector<OidFanoutReplAgreement>();
        Iterator<OidReplAgreement> it = this.m_agreements.iterator();
        int count = 0;
        while (it.hasNext()) {
            OidFanoutReplAgreement fanout;
            OidReplAgreement agrmt = it.next();
            if (agrmt.getAgreementType() != OidReplAgreement.OidReplAgreementType.OID_ONEWAY && agrmt.getAgreementType() != OidReplAgreement.OidReplAgreementType.OID_TWOWAY || !(fanout = (OidFanoutReplAgreement)agrmt).getConsumer().equals(this)) continue;
            al.add(fanout);
            ++count;
        }
        if (0 == count) {
            return null;
        }
        return al;
    }

    public LdapContext getDirContext() throws OidReplException {
        if (this.m_dirContext != null) {
            try {
                this.m_dirContext.lookup("");
            }
            catch (NamingException ne) {
                try {
                    this.m_dirContext.close();
                }
                catch (NamingException innerNE) {
                    // empty catch block
                }
                this.m_dirContext = null;
            }
            if (this.m_dirContext != null) {
                return this.m_dirContext;
            }
        }
        BasicControl[] ctrls = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        m_logger.dump("Connecting to ldap://{0}:{1} as {2}", this.m_host, Integer.toString(this.m_port), this.m_bindDN);
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port + "/");
            env.put("java.naming.security.credentials", this.m_bindPwd);
            env.put("java.naming.security.principal", this.m_bindDN);
            env.put("java.naming.security.authentication", "simple");
            if (this.m_isReplBind) {
                ctrls = new BasicControl[]{new BasicControl("2.16.840.1.113894.1.8.13")};
            }
            this.m_dirContext = new InitialLdapContext(env, ctrls);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(1L, this.m_host, String.valueOf(this.m_port), this.m_bindDN);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        m_logger.dump("Connection to ldap://{0}:{1} as {2} succeeded.", this.m_host, String.valueOf(this.m_port), this.m_bindDN);
        this.setReplicaID();
        this.setReplicaState(this.getAttrValue(this.getReplicaSubEntryDN(), "orclreplicastate"));
        return this.m_dirContext;
    }

    public LdapContext renewLdapContext() throws OidReplException {
        if (this.m_dirContext != null) {
            try {
                this.m_dirContext.close();
            }
            catch (NamingException ne) {
                m_logger.warn("Error while closing connection", ne);
            }
            this.m_dirContext = null;
        }
        return this.getDirContext();
    }

    public LdapContext getDirContext(String dn, String pwd, boolean isReplBind) throws OidReplException {
        InitialLdapContext dirContext = null;
        BasicControl[] ctrls = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        m_logger.dump("Connecting to ldap://{0}:{1} as {2}", this.m_host, String.valueOf(this.m_port), dn);
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port + "/");
            env.put("java.naming.security.credentials", dn);
            env.put("java.naming.security.principal", pwd);
            env.put("java.naming.security.authentication", "simple");
            if (isReplBind) {
                ctrls = new BasicControl[]{new BasicControl("2.16.840.1.113894.1.8.13")};
            }
            dirContext = new InitialLdapContext(env, ctrls);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(1L, this.m_host, String.valueOf(this.m_port), dn);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        m_logger.dump("Connection to ldap://{0}:{1} as {2} succeeded.", this.m_host, String.valueOf(this.m_port), dn);
        this.setReplicaID();
        this.setReplicaState(this.getAttrValue(this.getReplicaSubEntryDN(), "orclreplicastate"));
        return dirContext;
    }

    public boolean equals(Object repl) {
        OidReplica replica;
        String targetReplicaId;
        if (repl instanceof OidReplica && (targetReplicaId = (replica = (OidReplica)repl).getReplicaID()) != null && this.m_replicaid != null) {
            return this.m_replicaid.equalsIgnoreCase(replica.getReplicaID());
        }
        return false;
    }

    public boolean getIsReplBind() {
        return this.m_isReplBind;
    }

    public void setIsReplBind(boolean isReplBind) {
        this.m_isReplBind = isReplBind;
    }

    public void setAgreements(List<OidReplAgreement> agreements) {
        this.m_agreements = agreements;
    }

    public void setDirContext(LdapContext dirContext) {
        this.m_dirContext = dirContext;
    }

    public void setReplDNAndBindDN() throws OidReplException {
        if (this.m_host != null && this.m_port > 0) {
            this.m_replicaid = OidReplUtil.getReplicaId(this.m_host, this.m_port, null, null, this.m_replContext);
        }
        if (this.m_replicaid != null) {
            this.m_bindDN = this.m_replicationDN = String.format("cn=replication dn,orclreplicaid=%s,cn=replication configuration", this.m_replicaid);
            this.m_isReplBind = true;
            this.setReplicaSubEntryDN();
        }
    }

    public void setReplDNAndBindDNForUI(String dn) {
        this.m_bindDN = this.m_replicationDN = dn;
        this.m_isReplBind = true;
    }

    public String getReplDNAndBindDNForUI() throws OidReplException {
        if (this.m_host != null && this.m_port > 0) {
            this.m_replicaid = OidReplUtil.getReplicaId(this.m_host, this.m_port, null, null, this.m_replContext);
        }
        if (this.m_replicaid != null) {
            this.m_bindDN = this.m_replicationDN = String.format("cn=replication dn,orclreplicaid=%s,cn=replication configuration", this.m_replicaid);
            this.m_isReplBind = true;
            this.setReplicaSubEntryDN();
            return this.m_replicationDN;
        }
        return this.m_replContext.getString(2L, new Object[0]);
    }

    public Set<String> getAllAttributes() throws OidReplException {
        int count = 0;
        LdapContext ctx = null;
        DirContext schemaContext = null;
        if (this.m_attributeList != null) {
            return this.m_attributeList;
        }
        m_logger.dump("Creating HashSet of attributes from ldap://{0}:{1} [Replica ID : {2}]", this.m_host == null ? "NULL" : this.m_host, String.valueOf(this.m_port), this.m_replicaid == null ? "NULL" : this.m_replicaid);
        if (this.m_isReplBind) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            m_logger.dump("Connecting to ldap://{0}:{1} as {2} in normal bind mode.", this.m_host, Integer.toString(this.m_port), this.m_bindDN);
            try {
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port + "/");
                env.put("java.naming.security.credentials", this.m_bindPwd);
                env.put("java.naming.security.principal", this.m_bindDN);
                env.put("java.naming.security.authentication", "simple");
                ctx = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                String msg = this.m_replContext.getString(1L, this.m_host, String.valueOf(this.m_port), this.m_bindDN);
                m_logger.error(msg, ne);
                throw new OidReplException(msg, ne);
            }
        } else {
            ctx = this.getDirContext();
        }
        try {
            schemaContext = ctx.getSchema("");
            NamingEnumeration<NameClassPair> bds = schemaContext.list("AttributeDefinition");
            if (bds != null) {
                this.m_attributeList = new TreeSet<String>();
            }
            while (bds.hasMore()) {
                this.m_attributeList.add(bds.next().getName());
                ++count;
            }
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        finally {
            try {
                if (this.m_isReplBind) {
                    ctx.close();
                }
                if (schemaContext != null) {
                    schemaContext.close();
                }
            }
            catch (NamingException ne) {}
        }
        m_logger.dump("Created attribute list with {0} attributes.", String.valueOf(count));
        return this.m_attributeList;
    }

    public void AlterReplicaType(String type) throws OidReplException {
        try {
            if (this.m_replicaType == null || !this.m_replicaType.equals(type)) {
                BasicAttributes attrs = new BasicAttributes("orclreplicatype", type);
                this.m_dirContext.modifyAttributes(this.m_replicaSubEntryDN, 2, (Attributes)attrs);
                this.m_replicaType = type;
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(22L, "orclreplicatype", this.m_replicaSubEntryDN, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public void AlterReplicaState(String state) throws OidReplException {
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        try {
            if (this.m_replicaState == null || !this.m_replicaState.equals(state)) {
                BasicAttributes atrs = new BasicAttributes("orclreplicastate", state);
                this.m_dirContext.modifyAttributes(this.m_replicaSubEntryDN, 2, (Attributes)atrs);
                this.m_replicaState = state;
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(22L, "orclreplicatype", this.m_replicaSubEntryDN, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public void AlterDIPRepositoryValue(boolean isDIPRepository) throws OidReplException {
        try {
            BasicAttributes atr = new BasicAttributes("orcldiprepository", Boolean.toString(isDIPRepository));
            this.m_dirContext.modifyAttributes("", 2, (Attributes)atr);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(22L, "orcldiprepository", "\" \"", this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public Attributes getAttrVal(String dn, String[] attrNames) throws OidReplException {
        NamingEnumeration<SearchResult> srcResult = null;
        BasicAttributes newAttrs = null;
        SearchControls ctrls = new SearchControls();
        LdapContext dirCtx = this.getDirContext();
        m_logger.dump("Searching for entry {0} at ldap://{1}:{2}. Scope = base. Filter = (objectclass=*)", dn, this.m_host, String.valueOf(this.m_port));
        ctrls.setSearchScope(0);
        ctrls.setReturningAttributes(attrNames);
        try {
            srcResult = dirCtx.search(dn, "(objectclass=*)", ctrls);
            while (srcResult != null && srcResult.hasMore()) {
                SearchResult sr = srcResult.next();
                NamingEnumeration<? extends Attribute> attrs = sr.getAttributes().getAll();
                newAttrs = new BasicAttributes();
                while (attrs.hasMore()) {
                    Attribute atr = attrs.next();
                    String name = atr.getID();
                    int index = name.indexOf(94);
                    if (index != -1) {
                        name = name.substring(0, name.indexOf(94));
                    }
                    BasicAttribute newAttr = new BasicAttribute(name);
                    for (int count = 0; count < atr.size(); ++count) {
                        newAttr.add(atr.get(count));
                    }
                    newAttrs.put(newAttr);
                }
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(19L, this.m_host, String.valueOf(this.m_port), dn);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        return newAttrs;
    }

    public Map<String, Attributes> getEntries(String baseDN, int scope, String filter) throws OidReplException {
        Map<String, Attributes> entries;
        SearchControls ctrls = new SearchControls();
        m_logger.dump("Searching for entry {0} at ldap://{1}:{2}. Scope = {3}. Filter = {4}.", baseDN, this.m_host, String.valueOf(this.m_port), scope, filter);
        ctrls.setSearchScope(scope);
        ctrls.setReturningAttributes(new String[]{"*", "orclguid", "modifytimestamp", "createtimestamp", "modifiersname", "creatorsname", "orclaci", "orclentrylevelaci"});
        try {
            NamingEnumeration<SearchResult> srcResult = this.m_dirContext.search(baseDN, filter, ctrls);
            entries = OidReplica.getEntries(srcResult);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(19L, this.m_host, String.valueOf(this.m_port), baseDN);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        return entries;
    }

    public List<OidReplEntry> getEntriesSortedByParentFirst(String baseDN, int scope, String filter) throws OidReplException {
        List<OidReplEntry> entries;
        LdapContext ldapContext = this.getDirContext();
        SearchControls ctrls = new SearchControls();
        m_logger.dump("Searching for entry {0} at ldap://{1}:{2}. Scope = {3}. Filter = {4}.", baseDN, this.m_host, String.valueOf(this.m_port), scope, filter);
        ctrls.setSearchScope(scope);
        ctrls.setReturningAttributes(new String[]{"*", "orclguid", "modifytimestamp", "createtimestamp", "modifiersname", "creatorsname", "orclaci", "orclentrylevelaci"});
        try {
            NamingEnumeration<SearchResult> srcResult = ldapContext.search(baseDN, filter, ctrls);
            entries = OidReplica.getEntriesSortedByParentFirst(srcResult);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(19L, this.m_host, String.valueOf(this.m_port), baseDN);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        return entries;
    }

    public static Map<String, Attributes> getEntries(NamingEnumeration<SearchResult> srcResult) throws NamingException {
        HashMap<String, Attributes> entries = new HashMap<String, Attributes>();
        while (srcResult != null && srcResult.hasMore()) {
            SearchResult sr = srcResult.next();
            String dn = sr.getNameInNamespace();
            NamingEnumeration<? extends Attribute> attrs = sr.getAttributes().getAll();
            BasicAttributes newAttrs = new BasicAttributes();
            while (attrs.hasMore()) {
                Attribute atr = attrs.next();
                String name = atr.getID();
                int index = name.indexOf(94);
                if (index != -1) {
                    name = name.substring(0, name.indexOf(94));
                }
                BasicAttribute newAttr = new BasicAttribute(name);
                for (int count = 0; count < atr.size(); ++count) {
                    newAttr.add(atr.get(count));
                }
                newAttrs.put(newAttr);
            }
            entries.put(dn, newAttrs);
        }
        srcResult.close();
        return entries;
    }

    public static List<OidReplEntry> getEntriesSortedByParentFirst(NamingEnumeration<SearchResult> srcResult) throws NamingException {
        Vector<OidReplEntry> entries = new Vector<OidReplEntry>();
        while (srcResult != null && srcResult.hasMore()) {
            SearchResult sr = srcResult.next();
            String dn = sr.getNameInNamespace();
            NamingEnumeration<? extends Attribute> attrs = sr.getAttributes().getAll();
            BasicAttributes newAttrs = new BasicAttributes();
            while (attrs.hasMore()) {
                Attribute atr = attrs.next();
                String name = atr.getID();
                int index = name.indexOf(94);
                if (index != -1) {
                    name = name.substring(0, name.indexOf(94));
                }
                BasicAttribute newAttr = new BasicAttribute(name);
                for (int count = 0; count < atr.size(); ++count) {
                    newAttr.add(atr.get(count));
                }
                newAttrs.put(newAttr);
            }
            OidReplEntry.insertNewEntry(dn, newAttrs, entries);
        }
        srcResult.close();
        return entries;
    }

    public void setReplicaRWMode(boolean isReadOnly) throws OidReplException {
        NamingEnumeration<SearchResult> res = null;
        String dn = null;
        SearchControls sControl = new SearchControls();
        try {
            sControl.setSearchScope(1);
            sControl.setReturningAttributes(new String[]{"dn"});
            res = this.m_dirContext.search("cn=osdldapd,cn=subconfigsubentry", "(&(objectclass=*)(cn=*_oid_*))", sControl);
            while (res.hasMore()) {
                SearchResult sr = res.next();
                dn = sr.getNameInNamespace();
                BasicAttributes attrs = new BasicAttributes("orclservermode", isReadOnly ? "r" : "rw");
                this.m_dirContext.modifyAttributes(dn, 2, (Attributes)attrs);
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(22L, dn == null ? "NULL" : dn, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public void createNamingContextContainerEntry(String agrmtDN) throws OidReplException {
        BasicAttributes attrs = new BasicAttributes();
        String dn = "cn=replication namecontext," + agrmtDN;
        m_logger.dump("Creating naming context container entry {0} at ldap://{1}:{2}, )", dn, this.m_host, String.valueOf(this.m_port));
        BasicAttribute objClass = new BasicAttribute("objectclass");
        objClass.add("top");
        objClass.add("orclcontainerOC");
        attrs.put(objClass);
        attrs.put(new BasicAttribute("cn", "replication namecontext"));
        this.addEntry(dn, attrs, true);
    }

    public void createNamingContextEntry(String agrmtDN, OidReplNamingContext nctx, String direction) throws OidReplException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute atr = null;
        String aname = null;
        String aval = null;
        Set<String> strlist = null;
        aval = String.format("includednamingcontext%05d", nctx.getIncludedNamingCtxId());
        atr = new BasicAttribute("cn");
        atr.add(aval);
        attrs.put(atr);
        String nctxdn = String.format("cn=%s,%s,%s", aval, "cn=replication namecontext", agrmtDN);
        nctx.setIncludedNamingCtxDN(nctxdn);
        m_logger.dump("Creating naming context entry {0} at ldap://{1}:{2}", nctxdn, this.m_host, String.valueOf(this.m_port));
        atr = new BasicAttribute("objectclass");
        atr.add("top");
        atr.add("orclreplnamectxconfig");
        attrs.put(atr);
        aname = direction == null ? "orclIncludedNamingcontexts" : "orclIncludedNamingcontexts" + direction;
        aval = nctx.getIncludedDN();
        if (aval == null) {
            String msg = this.m_replContext.getString(18L, new Object[0]);
            m_logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        attrs.put(new BasicAttribute(aname, nctx.getIncludedDN()));
        strlist = nctx.getExcludedDNs();
        if (strlist != null) {
            atr = new BasicAttribute("orclExcludedNamingcontexts");
            for (String dn : strlist) {
                atr.add(dn);
            }
            if (strlist.size() > 0) {
                attrs.put(atr);
            }
        }
        if ((strlist = nctx.getExcludedAttrs()) != null) {
            atr = new BasicAttribute("orclExcludedAttributes");
            for (String exatr : strlist) {
                atr.add(exatr);
            }
            if (strlist.size() > 0) {
                attrs.put(atr);
            }
        }
        this.addEntry(nctxdn, attrs, false);
    }

    public boolean isSupplier(OidReplica replica) {
        boolean isSupplier = false;
        OidReplica tempReplica = this;
        OidReplica currentReplica = this;
        if (this.equals(replica)) {
            return false;
        }
        while (tempReplica != null) {
            tempReplica = null;
            List<? extends OidReplAgreement> allAgreements = currentReplica.getAllAgreements();
            for (OidReplAgreement oidReplAgreement : allAgreements) {
                OidFanoutReplAgreement foAgrmt;
                OidReplAgreement.OidReplAgreementType type = oidReplAgreement.getAgreementType();
                if (type == OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER || !(foAgrmt = (OidFanoutReplAgreement)oidReplAgreement).getConsumer().equals(currentReplica)) continue;
                if (foAgrmt.getSupplier().equals(replica)) {
                    isSupplier = true;
                    break;
                }
                currentReplica = tempReplica = foAgrmt.getSupplier();
                break;
            }
            if (!isSupplier) continue;
            break;
        }
        return isSupplier;
    }

    public void addEntry(String dn, Attributes attrs, boolean isIgnoreNameAlreadyBoundException) throws OidReplException {
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        m_logger.dump("Adding entry {0} to ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
        try {
            this.m_dirContext.createSubcontext(dn, attrs);
        }
        catch (Exception e) {
            if (e instanceof NameAlreadyBoundException && isIgnoreNameAlreadyBoundException) {
                String msg = this.m_replContext.getString(20L, dn, this.m_host, String.valueOf(this.m_port));
                m_logger.error(msg, e);
            }
            String msg = this.m_replContext.getString(20L, dn, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, e);
            throw new OidReplException(msg, e);
        }
        m_logger.dump("Successfully added entry {0} to ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
    }

    public void deleteEntry(String dn, boolean ignoreError) throws OidReplException {
        block3: {
            if (this.m_dirContext == null) {
                this.getDirContext();
            }
            m_logger.dump("Deleting entry {0} at ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
            try {
                this.m_dirContext.destroySubcontext(dn);
            }
            catch (NamingException ne) {
                if (ignoreError) break block3;
                String msg = this.m_replContext.getString(24L, dn, this.m_host, String.valueOf(this.m_port));
                m_logger.error(msg, ne);
                throw new OidReplException(msg, ne);
            }
        }
        m_logger.dump("Successfully deleted entry {0} at ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
    }

    public void modifyEntry(String dn, int mod_op, Attributes attrs) throws OidReplException {
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        m_logger.dump("Modifying entry \"{0}\" at ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
        try {
            this.m_dirContext.modifyAttributes(dn, mod_op, attrs);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(28L, dn, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        m_logger.dump("Successfully modified entry \"{0}\" at ldap://{1}:{2}/", dn, this.m_host, String.valueOf(this.m_port));
    }

    public String getAttrValue(String dn, String attrname) throws OidReplException {
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        try {
            Attributes attrs = this.m_dirContext.getAttributes(dn, new String[]{attrname});
            Attribute val = OidReplUtil.getRequiredAttribute(attrname, attrs, true);
            if (val != null) {
                return val.get().toString();
            }
            return null;
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(15L, attrname, dn, this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public void renameEntry(String oldDN, String newDN, boolean isIgnoreError) throws OidReplException {
        block3: {
            if (this.m_dirContext == null) {
                this.getDirContext();
            }
            m_logger.dump("Renaming entry {0} to {1} at ldap://{2}:{3}/", oldDN, newDN, this.m_host, String.valueOf(this.m_port));
            try {
                this.m_dirContext.rename(oldDN, newDN);
            }
            catch (NamingException ne) {
                if (isIgnoreError) break block3;
                String msg = this.m_replContext.getString(25L, oldDN, newDN, this.m_host, String.valueOf(this.m_port));
                m_logger.error(msg, ne);
                throw new OidReplException(msg, ne);
            }
        }
        m_logger.dump("Successfully renamed entry {0} to {1} at ldap://{2}:{3}/", oldDN, newDN, this.m_host, String.valueOf(this.m_port));
    }

    public void getNamingContextOfAgrmt(OidReplAgreement agrmt) throws OidReplException {
        NamingEnumeration<SearchResult> res = null;
        String msg = null;
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        agrmt.clearNamingContexts();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        try {
            res = this.m_dirContext.search(agrmt.getAgreementDN(), "(objectclass=orclreplnamectxconfig)", constraints);
            while (res.hasMore()) {
                int count;
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute incldn = OidReplUtil.getRequiredAttribute("orclIncludedNamingcontexts", atrs, true);
                Attribute excldn = OidReplUtil.getRequiredAttribute("orclExcludedNamingcontexts", atrs, true);
                Attribute exclatr = OidReplUtil.getRequiredAttribute("orclExcludedAttributes", atrs, true);
                OidReplNamingContext nmgctx = new OidReplNamingContext(agrmt, this.m_replContext);
                nmgctx.setIncludedNamingCtxDN(sr.getNameInNamespace());
                if (incldn != null) {
                    nmgctx.setIncludedDN(incldn.get().toString());
                }
                for (count = 0; excldn != null && count < excldn.size(); ++count) {
                    nmgctx.addExcludedDNToList(excldn.get(count).toString());
                }
                for (count = 0; exclatr != null && count < exclatr.size(); ++count) {
                    nmgctx.addExcludedAttrToList(exclatr.get(count).toString());
                }
                agrmt.addNamingContextToList(nmgctx);
            }
        }
        catch (NamingException ne) {
            msg = this.m_replContext.getString(19L, this.m_host, String.valueOf(this.m_port), agrmt.getAgreementDN());
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public long getNumLogs(String filter) throws OidReplException {
        long numChangeLogs = 0L;
        SearchControls searchCtrl = new SearchControls();
        NamingEnumeration<SearchResult> res = null;
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        try {
            Control[] ctrls = new BasicControl[]{new BasicControl("2.16.840.1.113894.1.8.21")};
            this.m_dirContext.setRequestControls(ctrls);
            searchCtrl.setSearchScope(1);
            res = this.m_dirContext.search("cn=changelog", filter, searchCtrl);
            Control[] response = this.m_dirContext.getResponseControls();
            for (int count = 0; response != null && count < response.length; ++count) {
                if (!response[count].getID().equals("2.16.840.1.113894.1.8.22")) continue;
                numChangeLogs = OidReplContext.getCountVal(response[count]);
                break;
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(19L, this.m_host, String.valueOf(this.m_port), "cn=changelog");
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                this.m_dirContext.setRequestControls(null);
                if (res != null) {
                    res.close();
                }
            }
            catch (NamingException ne) {}
        }
        return numChangeLogs;
    }

    public void close() {
        this.m_host = null;
        if (this.m_secondaryURIs != null) {
            this.m_secondaryURIs.clear();
        }
        this.m_replicaSubEntryDN = null;
        this.m_bindDN = null;
        this.m_bindPwd = null;
        this.m_replicationDN = null;
        this.m_replPwd = null;
        this.m_replicaid = null;
        this.m_replicaState = null;
        this.m_replicaType = null;
        this.m_replicaVersion = null;
        this.m_seeAlso = null;
        this.m_pilotStartTime = null;
        this.m_pilotMode = null;
        this.m_emTargetName = null;
        if (this.m_agreements != null) {
            this.m_agreements.clear();
            this.m_agreements = null;
        }
        if (this.m_dirContext != null) {
            try {
                this.m_dirContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.m_dirContext = null;
        }
        if (this.m_attributeList != null) {
            this.m_attributeList.clear();
            this.m_attributeList = null;
        }
    }

    public void activateReplication() throws OidReplException {
        String asInstName = "";
        String oidCompName = "";
        String defaultAsInstName = "";
        String defaultOidCompName = "";
        boolean validInstCompName = false;
        BasicAttributes configsetAttrs = new BasicAttributes();
        NamingEnumeration<SearchResult> res = null;
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        try {
            Attribute oidCompNameAttr;
            Attributes attrs1 = this.m_dirContext.getAttributes("cn=configset0,cn=osdrepld,cn=subconfigsubentry", new String[]{"orclOidInstanceName", "orclOidComponentName"});
            Attribute asInstNameAttr = OidReplUtil.getRequiredAttribute("orclOidInstanceName", attrs1, true);
            if (asInstNameAttr != null) {
                asInstName = asInstNameAttr.get().toString();
            }
            if ((oidCompNameAttr = OidReplUtil.getRequiredAttribute("orclOidComponentName", attrs1, true)) != null) {
                oidCompName = oidCompNameAttr.get().toString();
            }
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            res = this.m_dirContext.search("cn=subconfigsubentry", "objectclass=orclldapsubconfig", constraints);
            while (res.hasMore()) {
                String iName = "";
                String cName = "";
                SearchResult sr = res.next();
                Attributes attrs2 = sr.getAttributes();
                Attribute InstName = OidReplUtil.getRequiredAttribute("orclOidInstanceName", attrs2, true);
                if (InstName == null) continue;
                iName = InstName.get().toString();
                Attribute CompName = OidReplUtil.getRequiredAttribute("orclOidComponentName", attrs2, true);
                if (CompName == null) continue;
                cName = CompName.get().toString();
                if (defaultAsInstName.equals("") || defaultOidCompName.equals("")) {
                    defaultAsInstName = iName;
                    defaultOidCompName = cName;
                }
                if (!iName.equalsIgnoreCase(asInstName) || !cName.equalsIgnoreCase(oidCompName)) continue;
                validInstCompName = true;
                break;
            }
            if (res != null) {
                res.close();
            }
            if (!validInstCompName) {
                if (!defaultAsInstName.equals("") && !defaultOidCompName.equals("") && asInstName.equals("") && oidCompName.equals("")) {
                    configsetAttrs.put("orclOidInstanceName", defaultAsInstName);
                    configsetAttrs.put("orclOidComponentName", defaultOidCompName);
                    m_logger.dump("OIDInstanceName and OIDComponentName have been set to {0} and {1} in replication configuration at ldap://{2}:{3}/", defaultAsInstName, defaultOidCompName, this.m_host, String.valueOf(this.m_port));
                } else {
                    String msg = this.m_replContext.getString(32L, asInstName, oidCompName, this.m_host, String.valueOf(this.m_port));
                    m_logger.error(msg, new Object[0]);
                }
            }
            configsetAttrs.put("orclActivateReplication", "1");
            this.m_dirContext.modifyAttributes("cn=configset0,cn=osdrepld,cn=subconfigsubentry", 2, (Attributes)configsetAttrs);
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
    }

    public void checkAndAddSecondaryURI() throws OidReplException {
        String[] uri;
        String[] reqAttrs = null;
        LdapContext dirCtx = this.getDirContext();
        if (this.m_replicaURI == null && (this.m_secondaryURIs == null || this.m_secondaryURIs.size() == 0)) {
            reqAttrs = new String[]{"orclreplicauri", "orclreplicasecondaryuri"};
        } else if (this.m_replicaURI == null) {
            reqAttrs = new String[]{"orclreplicauri"};
        } else if (this.m_secondaryURIs == null || this.m_secondaryURIs.size() == 0) {
            reqAttrs = new String[]{"orclreplicasecondaryuri"};
        }
        if (reqAttrs != null) {
            Attributes attrs = this.getAttrVal(this.m_replicaSubEntryDN, reqAttrs);
            for (int i = 0; i < reqAttrs.length; ++i) {
                Attribute attr = attrs.get(reqAttrs[i]);
                if (attr == null) continue;
                if (reqAttrs[i].equals("orclreplicauri")) {
                    try {
                        this.m_replicaURI = attr.get().toString();
                        continue;
                    }
                    catch (NamingException ne) {
                        throw new OidReplException(ne);
                    }
                }
                try {
                    for (i = 0; i < attr.size(); ++i) {
                        this.m_secondaryURIs.add(attr.get(i).toString());
                    }
                    continue;
                }
                catch (NamingException ne) {
                    throw new OidReplException(ne);
                }
            }
        }
        boolean matchFound = false;
        if (this.m_replicaURI != null && (uri = OidReplica.getHostPortFromURI(this.m_replicaURI))[0].equalsIgnoreCase(this.m_host) && Integer.valueOf(uri[1]) == this.m_port) {
            matchFound = true;
        }
        if (!matchFound && this.m_secondaryURIs != null) {
            for (String val : this.m_secondaryURIs) {
                String[] uri2 = OidReplica.getHostPortFromURI(val);
                if (!uri2[0].equalsIgnoreCase(this.m_host) || Integer.valueOf(uri2[1]) != this.m_port) continue;
                matchFound = true;
                break;
            }
        }
        if (!matchFound) {
            ModificationItem[] modItems = new ModificationItem[1];
            String newURI = String.format("ldap://%s:%s/", this.m_host, String.valueOf(this.m_port));
            modItems[0] = OidReplUtil.CreateModItem("orclreplicasecondaryuri", newURI, 1);
            try {
                dirCtx.modifyAttributes(this.m_replicaSubEntryDN, modItems);
            }
            catch (NamingException ne) {
                String msg = this.m_replContext.getString(10L, this.m_replicaSubEntryDN, newURI);
                m_logger.error(msg, ne);
                throw new OidReplException(msg, ne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeReplicaID(String newReplicaID) throws OidReplException {
        String oldreplicaid = OidReplUtil.getReplicaId(this.m_host, this.m_port, this.m_bindDN, this.m_bindPwd, this.m_replContext);
        NamingEnumeration<SearchResult> res = null;
        SearchControls constraints = new SearchControls();
        boolean dupReplicaId = false;
        m_logger.dump("Changing ReplicaID from {0} to {1} at ldap://{2}:{3}/", oldreplicaid, newReplicaID, this.m_host, String.valueOf(this.m_port));
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        if (this.getReplicaState() == null || !this.getReplicaState().equals("6")) {
            String msg = this.m_replContext.getString(33L, new Object[0]);
            m_logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        if (oldreplicaid.equalsIgnoreCase(newReplicaID.trim())) {
            String msg = this.m_replContext.getString(34L, newReplicaID, oldreplicaid);
            m_logger.error(msg, new Object[0]);
            return;
        }
        constraints.setSearchScope(2);
        try {
            res = this.m_dirContext.search("cn=replication configuration", "(objectclass=*)", constraints);
            while (res != null && res.hasMore() && !dupReplicaId) {
                String replid;
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute replidAttr = OidReplUtil.getRequiredAttribute("orclreplicaid", atrs, true);
                Attribute repliddnAttr = OidReplUtil.getRequiredAttribute("orclreplicadn", atrs, true);
                if (replidAttr != null && (replid = replidAttr.get().toString()) != null && replid.equalsIgnoreCase(newReplicaID)) {
                    dupReplicaId = true;
                }
                for (int count = 0; repliddnAttr != null && count < repliddnAttr.size(); ++count) {
                    String replid2 = OidReplUtil.getReplicaIdFromDN(repliddnAttr.get(count).toString());
                    if (replid2 == null || !replid2.equalsIgnoreCase(newReplicaID)) continue;
                    dupReplicaId = true;
                }
            }
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                    res = null;
                }
            }
            catch (NamingException ne) {}
        }
        if (dupReplicaId) {
            String msg = this.m_replContext.getString(35L, newReplicaID);
            m_logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        try {
            BasicAttributes replicaIdAttr = new BasicAttributes();
            replicaIdAttr.put("orclreplicaid", newReplicaID);
            this.m_dirContext.modifyAttributes("", 2, (Attributes)replicaIdAttr);
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(36L, "orclreplicaid", "root DSE", this.m_host, String.valueOf(this.m_port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        OidReplEntry entry = null;
        List<OidReplEntry> eList = null;
        try {
            eList = this.getEntriesSortedByParentFirst("cn=replication configuration", 2, "(objectclass=*)");
            for (int iCount = eList.size() - 1; iCount >= 0; --iCount) {
                entry = eList.get(iCount);
                this.deleteEntry(entry.m_dn.toString(), false);
            }
        }
        finally {
            if (eList != null) {
                eList.clear();
            }
        }
    }

    public Map<String, List<String>> getInstanceNames() throws OidReplException {
        HashMap<String, List<String>> namesMap = new HashMap<String, List<String>>();
        NamingEnumeration<SearchResult> res = null;
        SearchControls constraints = new SearchControls();
        m_logger.dump("Getting instance name & component name for replica {1}", this.m_replicaid == null ? "NULL" : this.m_replicaid);
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        constraints.setSearchScope(1);
        try {
            this.m_dirContext.setRequestControls(null);
            res = this.m_dirContext.search("cn=osdldapd,cn=subconfigsubentry", "(objectclass=*)", constraints);
            while (res != null && res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                String instName = OidReplUtil.getAttrValue("orclOidInstanceName", atrs, true);
                String compName = OidReplUtil.getAttrValue("orclOidComponentName", atrs, true);
                if (instName == null || compName == null) continue;
                List val = (List)namesMap.get(instName);
                if (val == null) {
                    ArrayList<String> newVal = new ArrayList<String>();
                    newVal.add(compName);
                    namesMap.put(instName, newVal);
                    continue;
                }
                val.add(compName);
            }
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                    res = null;
                }
            }
            catch (NamingException ne) {}
        }
        return namesMap;
    }

    public void startReplicationServer(String instanceName, String componentName, boolean startBootStrap, String bootStrapMode) throws OidReplException {
        BasicAttributes attrs = new BasicAttributes();
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        if (startBootStrap) {
            this.AlterReplicaState(bootStrapMode);
        }
        if (componentName != null) {
            attrs.put(new BasicAttribute("orclOidComponentName", componentName));
        }
        if (instanceName != null) {
            attrs.put(new BasicAttribute("orclOidInstanceName", instanceName));
        }
        attrs.put(new BasicAttribute("orclActivateReplication", "1"));
        try {
            this.m_dirContext.modifyAttributes("cn=configset0,cn=osdrepld,cn=subconfigsubentry", 2, (Attributes)attrs);
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
    }

    public void stopReplicationServer() throws OidReplException {
        BasicAttributes attrs = new BasicAttributes("orclActivateReplication", "0");
        if (this.m_dirContext == null) {
            this.getDirContext();
        }
        try {
            this.m_dirContext.modifyAttributes("cn=configset0,cn=osdrepld,cn=subconfigsubentry", 2, (Attributes)attrs);
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
    }
}

