/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import oracle.ldap.jremtool.OidFanoutReplAgreement;
import oracle.ldap.jremtool.OidMultimasterReplAgreement;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplEntry;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplica;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidReplUtil {
    public static final int BOTH_DIRECTION = 0;
    public static final int SOURCE_TO_DEST = 1;
    public static final int DEST_TO_SOURCE = 2;
    private static final OidReplLogger m_logger = OidReplLogger.getLogger(OidReplUtil.class.getName());
    private static final Set<LdapName> exclDNs = new HashSet<LdapName>();

    public static Set<LdapName> getStandardExcludedDNs() {
        return exclDNs;
    }

    public static String getAttrValue(String attributeName, Attributes atrs, boolean subTypeIncluded) throws OidReplException {
        Attribute atr = OidReplUtil.getRequiredAttribute(attributeName, atrs, subTypeIncluded);
        try {
            if (atr != null) {
                return (String)atr.get();
            }
        }
        catch (NamingException ne) {
            m_logger.error(ne.getLocalizedMessage(), ne);
            throw new OidReplException(ne);
        }
        return null;
    }

    public static Attribute getRequiredAttribute(String attributeName, Attributes atrs, boolean subTypeIncluded) throws OidReplException {
        Attribute atr = null;
        NamingEnumeration<? extends Attribute> res = atrs.getAll();
        try {
            while (res.hasMore()) {
                String reqAtrName;
                Attribute temp = res.next();
                String atrName = temp.getID().toLowerCase();
                if (!atrName.equals(reqAtrName = attributeName.toLowerCase()) && !atrName.startsWith(reqAtrName + "^") && (!subTypeIncluded || !atrName.startsWith(reqAtrName + ";"))) continue;
                atr = temp;
                break;
            }
            res.close();
        }
        catch (NamingException ne) {
            m_logger.error(ne.getLocalizedMessage(), ne);
            throw new OidReplException(ne);
        }
        return atr;
    }

    public static ModificationItem CreateModItem(String name, Object val, int mod) {
        BasicAttribute attr = new BasicAttribute(name);
        attr.add(val);
        ModificationItem mItem = new ModificationItem(mod, attr);
        return mItem;
    }

    public static ModificationItem CreateModItem(String name, Object[] vals, int mod) {
        int count = 0;
        BasicAttribute attr = new BasicAttribute(name);
        for (count = 0; count < vals.length; ++count) {
            attr.add(vals[count]);
        }
        ModificationItem mItem = new ModificationItem(mod, attr);
        return mItem;
    }

    public static ModificationItem CreateModItem(String name, Set<Object> vals, int mod) {
        BasicAttribute attr = new BasicAttribute(name);
        for (Object tVal : vals) {
            attr.add(tVal);
        }
        ModificationItem mItem = new ModificationItem(mod, attr);
        return mItem;
    }

    public static String getReplicaIdFromDN(String dn) {
        LdapName name = null;
        Rdn rdn = null;
        String replicaID = null;
        try {
            name = new LdapName(dn);
            if (name.size() > 1 && (rdn = name.getRdn(1)) != null) {
                replicaID = ((String)rdn.getValue()).trim();
            }
        }
        catch (InvalidNameException ine) {
            // empty catch block
        }
        return replicaID;
    }

    public static String getReplicaId(String host, int port, String dn, String pwd, OidReplContext replContext) throws OidReplException {
        String replicaid = null;
        Context dirContext = null;
        SearchControls constraints = new SearchControls();
        String[] reqAttrs = new String[]{"orclreplicaid"};
        Hashtable<String, String> env = new Hashtable<String, String>();
        NamingEnumeration<SearchResult> res = null;
        m_logger.dump("Getting replica id of ldap://{0}:{1}/", host, String.valueOf(port));
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
            if (pwd != null) {
                env.put("java.naming.security.credentials", pwd);
            } else {
                env.put("java.naming.security.credentials", "");
            }
            if (dn != null) {
                env.put("java.naming.security.principal", dn);
            } else {
                env.put("java.naming.security.principal", "");
            }
            env.put("java.naming.security.authentication", "simple");
            dirContext = new InitialLdapContext(env, null);
            constraints.setSearchScope(0);
            constraints.setReturningAttributes(reqAttrs);
            res = dirContext.search("", "(objectclass=*)", constraints);
            if (res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute rid = atrs.get("orclreplicaid");
                if (rid != null) {
                    replicaid = rid.get().toString();
                }
                m_logger.dump("Got replica id of ldap://{0}:{1}/ : {2}", host, String.valueOf(port), replicaid == null ? "NULL" : replicaid);
            }
        }
        catch (NamingException ne) {
            String msg = replContext.getString(11L, host, String.valueOf(port));
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                res = null;
                if (dirContext != null) {
                    dirContext.close();
                }
                dirContext = null;
            }
            catch (NamingException ne) {}
        }
        return replicaid;
    }

    public static Attributes createAgreementEntry(String agrmtId, OidReplAgreement agrmt, OidReplica supplier) {
        BasicAttributes attrs = new BasicAttributes(true);
        String agreementDN = String.format("orclagreementid=%s,orclreplicaid=%s,cn=replication configuration", agrmtId, supplier.getReplicaID());
        agrmt.setAgreementDN(agreementDN);
        agrmt.setAgreementID(agrmtId);
        BasicAttribute objClass = new BasicAttribute("objectclass");
        objClass.add("top");
        objClass.add("orclreplagreemententry");
        attrs.put(objClass);
        attrs.put(new BasicAttribute("orclagreementid", agrmtId));
        attrs.put(new BasicAttribute("orclagreementname", agrmt.getAgreementName()));
        if (agrmt.getUpdateSchedule() == null) {
            agrmt.setUpdateSchedule("1");
        }
        attrs.put(new BasicAttribute("orclupdateschedule", agrmt.getUpdateSchedule()));
        attrs.put(new BasicAttribute("orclreplicationprotocol", "ODS_LDAP_1.0"));
        if (agrmt.getHIQSchedule() == null) {
            agrmt.setHIQSchedule("10");
        }
        attrs.put(new BasicAttribute("orclhiqschedule", agrmt.getHIQSchedule()));
        attrs.put(new BasicAttribute("orclldapconnkeepalive", agrmt.isConnKeepAlive() ? "1" : "0"));
        attrs.put(new BasicAttribute("orclreplicationid", agrmtId));
        return attrs;
    }

    public static void createMultimasterReplAgreementEntry(String agrmtId, OidMultimasterReplAgreement mmagrmt) throws OidReplException {
        List<OidReplica> replicas = mmagrmt.getMultimasterReplicas();
        OidReplica primReplica = mmagrmt.getPrimaryReplica();
        Attributes attrs = OidReplUtil.createAgreementEntry(agrmtId, mmagrmt, primReplica);
        BasicAttribute orclreplicadn = new BasicAttribute("orclreplicadn");
        for (OidReplica replica : replicas) {
            orclreplicadn.add(replica.getReplicaSubEntryDN());
        }
        attrs.put(orclreplicadn);
        attrs.put(new BasicAttribute("orclagreementtype", "2"));
        for (OidReplica oReplica : replicas) {
            String supID = oReplica.getReplicaID();
            for (OidReplica iReplica : replicas) {
                String conID = iReplica.getReplicaID();
                if (conID.equalsIgnoreCase(supID)) continue;
                String lastChgNum = oReplica.getAttrValue("", "lastchangenumber");
                String apply = String.format("orcllastappliedchangenumber;apply$%s$%s", supID, conID);
                String trans = String.format("orcllastappliedchangenumber;transport$%s$%s", supID, conID);
                attrs.put(new BasicAttribute(apply, lastChgNum));
                attrs.put(new BasicAttribute(trans, lastChgNum));
            }
        }
        primReplica.addEntry(mmagrmt.getAgreementDN(), attrs, false);
    }

    public static void createFanoutReplAgreementEntry(String agrmtId, OidFanoutReplAgreement agrmt) throws OidReplException {
        OidReplica supplier = agrmt.getSupplier();
        OidReplica consumer = agrmt.getConsumer();
        String supID = supplier.getReplicaID();
        String conID = consumer.getReplicaID();
        Attributes attrs = OidReplUtil.createAgreementEntry(agrmtId, agrmt, supplier);
        attrs.put(new BasicAttribute("orclreplicadn", consumer.getReplicaSubEntryDN()));
        String agrmtType = agrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_ONEWAY ? "0" : "1";
        attrs.put(new BasicAttribute("orclagreementtype", agrmtType));
        String lastChgNum = supplier.getAttrValue("", "lastchangenumber");
        String apply = String.format("orcllastappliedchangenumber;apply$%s$%s", supID, conID);
        String trans = String.format("orcllastappliedchangenumber;transport$%s$%s", supID, conID);
        attrs.put(new BasicAttribute(apply, lastChgNum));
        attrs.put(new BasicAttribute(trans, lastChgNum));
        if (agrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_TWOWAY) {
            lastChgNum = consumer.getAttrValue("", "lastchangenumber");
            apply = String.format("orcllastappliedchangenumber;apply$%s$%s", conID, supID);
            trans = String.format("orcllastappliedchangenumber;transport$%s$%s", conID, supID);
            attrs.put(new BasicAttribute(apply, lastChgNum));
            attrs.put(new BasicAttribute(trans, lastChgNum));
        }
        supplier.addEntry(agrmt.getAgreementDN(), attrs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntries(OidReplica srcReplica, OidReplica destReplica, String baseDN, int scope, String filter, Set<LdapName> exclDNs, boolean isIgnoreNameAlreadyBoundException, OidReplContext replContext) throws OidReplException {
        ArrayList<OidReplica> replicaList = new ArrayList<OidReplica>();
        replicaList.add(destReplica);
        try {
            OidReplUtil.copyEntries(srcReplica, replicaList, baseDN, scope, filter, exclDNs, isIgnoreNameAlreadyBoundException, replContext);
        }
        finally {
            replicaList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntries(OidReplica srcReplica, List<OidReplica> destReplicaList, String baseDN, int scope, String filter, Set<LdapName> exclDNs, boolean isIgnoreNameAlreadyBoundException, OidReplContext replContext) throws OidReplException {
        List<OidReplEntry> eList = null;
        try {
            eList = srcReplica.getEntriesSortedByParentFirst(baseDN, scope, filter);
            OidReplUtil.copyEntries(destReplicaList, eList, exclDNs, isIgnoreNameAlreadyBoundException, replContext);
        }
        finally {
            if (eList != null) {
                eList.clear();
            }
        }
    }

    public static void copyEntries(List<OidReplica> listReplicas, List<OidReplEntry> eList, Set<LdapName> exclDNs, boolean isIgnoreNameAlreadyBoundException, OidReplContext replContext) throws OidReplException {
        OidReplEntry entry = null;
        OidReplica replica = null;
        int count = 0;
        int iCount = 0;
        String host = null;
        int port = 0;
        for (count = 0; listReplicas != null && count < listReplicas.size(); ++count) {
            replica = listReplicas.get(count);
            host = replica.getHost();
            port = replica.getPort();
            LdapContext ctx = replica.getDirContext();
            for (iCount = 0; iCount < eList.size(); ++iCount) {
                boolean exclude = false;
                entry = eList.get(iCount);
                m_logger.dump("Copying entry {0} to ldap://{1}:{2}.", entry.m_dn.toString(), host, String.valueOf(port));
                if (exclDNs != null) {
                    for (LdapName name : exclDNs) {
                        if (!name.equals(entry.m_dn)) continue;
                        exclude = true;
                        break;
                    }
                }
                if (exclude) continue;
                try {
                    ctx.createSubcontext(entry.m_dn, entry.m_attrs);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof NameAlreadyBoundException && isIgnoreNameAlreadyBoundException) {
                        m_logger.warn("Error while copying entry {0}", e);
                        continue;
                    }
                    String msg = replContext.getString(20L, entry == null ? "NULL" : entry.m_dn.toString(), host == null ? "NULL" : host, String.valueOf(port));
                    m_logger.error(msg, e);
                    throw new OidReplException(msg, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNumEntries(LdapContext dirContext, String baseDn, String filter, int scope) throws OidReplException {
        long numEntries = 0L;
        SearchControls searchCtrl = new SearchControls();
        NamingEnumeration<SearchResult> res = null;
        try {
            Control[] ctrls = new BasicControl[]{new BasicControl("2.16.840.1.113894.1.8.21")};
            dirContext.setRequestControls(ctrls);
            searchCtrl.setSearchScope(scope);
            res = dirContext.search(baseDn, filter, searchCtrl);
            Control[] response = dirContext.getResponseControls();
            for (int count = 0; response != null && count < response.length; ++count) {
                if (!response[count].getID().equals("2.16.840.1.113894.1.8.22")) continue;
                numEntries = OidReplContext.getCountVal(response[count]);
                break;
            }
        }
        catch (NamingException ne) {
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                dirContext.setRequestControls(null);
            }
            catch (NamingException ne) {}
        }
        return numEntries;
    }

    static {
        try {
            exclDNs.add(new LdapName("orclagreementid=000001,cn=replication configuration"));
            exclDNs.add(new LdapName("cn=replication configuration"));
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }
}

