/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OidReplEntry {
    public final LdapName m_dn;
    public final Attributes m_attrs;

    OidReplEntry() {
        this.m_dn = null;
        this.m_attrs = null;
    }

    OidReplEntry(String dn, Attributes attrs) throws NamingException {
        this.m_dn = new LdapName(dn);
        this.m_attrs = attrs;
    }

    public boolean isAncestor(String dn) throws NamingException {
        LdapName newName = new LdapName(dn);
        return this.m_dn.endsWith(newName);
    }

    public boolean isAncestor(LdapName dn) {
        return this.m_dn.endsWith(dn);
    }

    public static void insertNewEntry(String dn, Attributes attrs, List<OidReplEntry> entryList) throws NamingException {
        boolean added = false;
        int count = 0;
        for (count = 0; entryList != null && count < entryList.size(); ++count) {
            OidReplEntry entry = entryList.get(count);
            if (!entry.isAncestor(dn)) continue;
            entryList.add(count, new OidReplEntry(dn, attrs));
            added = true;
            break;
        }
        if (!added) {
            entryList.add(new OidReplEntry(dn, attrs));
        }
    }
}

