/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import oracle.ldap.jremtool.OidChgNum;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplNamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OidReplAgreement {
    private static final OidReplLogger logger = OidReplLogger.getLogger(OidReplAgreement.class.getName());
    protected String m_agreementName;
    protected String m_agreementDN;
    protected String m_agreementID;
    protected OidReplAgreementType m_agreementType;
    protected Map<String, OidReplNamingContext> m_namingContexts = new Hashtable<String, OidReplNamingContext>();
    protected List<OidChgNum> m_queueStat = new Vector<OidChgNum>();
    protected String m_orclReplicationID;
    protected String m_sizelimit;
    protected String m_updateSchedule = "1";
    protected String m_hiqSchedule = "10";
    protected String m_replProtocol;
    protected boolean m_connKeepAlive = true;
    protected long m_maxNamingCtxId = 0L;
    protected Map<String, Object> m_modifiedItems = new HashMap<String, Object>();
    protected boolean m_isRecordChange = false;
    protected Set<OidReplNamingContext> m_newNamingContexts = new HashSet<OidReplNamingContext>();
    protected Set<OidReplNamingContext> m_removedNamingContexts = new HashSet<OidReplNamingContext>();
    protected OidReplContext m_replContext;

    public OidReplAgreement(OidReplContext replContext) {
        this.m_replContext = replContext;
    }

    public String getAgreementDN() {
        return this.m_agreementDN;
    }

    public void setAgreementDN(String dn) {
        this.m_agreementDN = dn;
    }

    public String getAgreementID() {
        return this.m_agreementID;
    }

    public void setAgreementID(String id) {
        this.m_agreementID = id;
    }

    public String getAgreementName() {
        return this.m_agreementName;
    }

    public void setAgreementName(String name) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclagreementname")) {
            this.m_modifiedItems.put("orclagreementname", this.m_agreementName);
        }
        this.m_agreementName = name;
    }

    public OidReplAgreementType getAgreementType() {
        return this.m_agreementType;
    }

    public void setAgreementType(OidReplAgreementType type) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclagreementtype")) {
            this.m_modifiedItems.put("orclagreementtype", (Object)this.m_agreementType);
        }
        this.m_agreementType = type;
    }

    public void setAgreementType(String type) throws OidReplException {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclagreementtype")) {
            this.m_modifiedItems.put("orclagreementtype", (Object)this.m_agreementType);
        }
        if (type.equals("0")) {
            this.m_agreementType = OidReplAgreementType.OID_ONEWAY;
        } else if (type.equals("1")) {
            this.m_agreementType = OidReplAgreementType.OID_TWOWAY;
        } else if (type.equals("2")) {
            this.m_agreementType = OidReplAgreementType.OID_MULTIMASTER;
        }
    }

    public String getUpdateSchedule() {
        return this.m_updateSchedule;
    }

    public void setUpdateSchedule(String val) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclupdateschedule")) {
            this.m_modifiedItems.put("orclupdateschedule", this.m_updateSchedule);
        }
        this.m_updateSchedule = val;
    }

    public String getHIQSchedule() {
        return this.m_hiqSchedule;
    }

    public void setHIQSchedule(String val) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclhiqschedule")) {
            this.m_modifiedItems.put("orclhiqschedule", this.m_hiqSchedule);
        }
        this.m_hiqSchedule = val;
    }

    public boolean isConnKeepAlive() {
        return this.m_connKeepAlive;
    }

    public void setConnKeepAlive(boolean val) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclldapconnkeepalive")) {
            this.m_modifiedItems.put("orclldapconnkeepalive", this.m_connKeepAlive ? "1" : "0");
        }
        this.m_connKeepAlive = val;
    }

    public void setReplProtocol(String protocol) {
        this.m_replProtocol = protocol;
    }

    public String getReplProtocol() {
        return this.m_replProtocol;
    }

    public String getReplicationID() {
        return this.m_orclReplicationID;
    }

    public void setReplicationID(String rid) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclreplicationid")) {
            this.m_modifiedItems.put("orclreplicationid", this.m_orclReplicationID);
        }
        this.m_orclReplicationID = rid;
    }

    public void addNamingContextToList(OidReplNamingContext ctx) throws OidReplException {
        if (ctx.getIncludedDN() != null) {
            String dn;
            if (this.m_isRecordChange) {
                this.m_newNamingContexts.add(ctx);
            }
            if ((dn = ctx.getIncludedNamingCtxDN()) == null) {
                this.setDNforNamingCtx(ctx);
            }
        } else {
            String msg = this.m_replContext.getString(18L, new Object[0]);
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        this.m_namingContexts.put(ctx.getIncludedDN(), ctx);
    }

    public void setDNforNamingCtx(OidReplNamingContext ctx) {
        long id = 1L;
        for (OidReplNamingContext nmgCtx : this.m_namingContexts.values()) {
            long tempid = nmgCtx.getIncludedNamingCtxId();
            id = tempid >= id ? tempid + 1L : id;
            String dn = nmgCtx.getIncludedNamingCtxDN();
            if (dn == null) continue;
            try {
                LdapName name = new LdapName(dn);
                String rdn = name.get(name.size() - 1).toLowerCase();
                if (!rdn.startsWith("cn=includednamingcontext")) continue;
                String tmp = rdn.substring("cn=includednamingcontext".length());
                id = (long)Integer.valueOf(tmp).intValue() >= id ? (long)(Integer.valueOf(tmp) + 1) : id;
            }
            catch (InvalidNameException ine) {}
        }
        String inclNamingCtxName = "cn=includednamingcontext" + String.format("%06d", id);
        ctx.setIncludedNamingCtxId(id);
        ctx.setIncludedNamingCtxName(inclNamingCtxName);
    }

    public void removeNamingContextFromList(OidReplNamingContext ctx) {
        if (this.m_isRecordChange) {
            this.m_removedNamingContexts.add(ctx);
        }
        this.m_namingContexts.remove(ctx.getIncludedDN());
        --this.m_maxNamingCtxId;
    }

    public void removeNamingContextFromList(String namingCtxDN) {
        if (this.m_isRecordChange) {
            this.m_removedNamingContexts.add(this.m_namingContexts.get(namingCtxDN));
        }
        this.m_namingContexts.remove(namingCtxDN);
        --this.m_maxNamingCtxId;
    }

    public List<OidReplNamingContext> getNamingContexts() {
        Vector<OidReplNamingContext> al = new Vector<OidReplNamingContext>(this.m_namingContexts.values());
        return al;
    }

    public void clearQueueStatistics() {
        this.m_queueStat.clear();
    }

    public void clearNamingContexts() {
        this.m_namingContexts.clear();
    }

    public void addQueueStatistics(OidChgNum qStat) {
        this.m_queueStat.add(qStat);
    }

    public List<OidChgNum> getQueueStatistics() {
        return this.m_queueStat;
    }

    public OidReplNamingContext getNamingContext(String includedDN) {
        for (Map.Entry<String, OidReplNamingContext> mapentry : this.m_namingContexts.entrySet()) {
            OidReplNamingContext ctx = mapentry.getValue();
            if (!ctx.getIncludedDN().equals(includedDN)) continue;
            return ctx;
        }
        return null;
    }

    public abstract List<String> validate() throws OidReplException;

    public abstract boolean updateChanges() throws OidReplException;

    public boolean isRecordChange() {
        return this.m_isRecordChange;
    }

    public void setRecordChange(boolean recordChange, boolean clearChange) {
        this.m_isRecordChange = recordChange;
        if (clearChange) {
            this.clearChanges();
        }
    }

    public void clearChanges() {
        this.m_modifiedItems.clear();
        this.m_newNamingContexts.clear();
        this.m_removedNamingContexts.clear();
    }

    public void cancelChanges() {
        String replID;
        String connType;
        OidReplAgreementType agrmtType;
        String agrmtName;
        String hiqSchd;
        if (this.m_modifiedItems == null) {
            return;
        }
        Iterator<OidReplNamingContext> ctxs = this.m_newNamingContexts.iterator();
        while (ctxs.hasNext()) {
            this.m_namingContexts.remove(ctxs.next().getIncludedDN());
        }
        for (OidReplNamingContext ctx : this.m_removedNamingContexts) {
            this.m_namingContexts.put(ctx.getIncludedDN(), ctx);
        }
        String updSchd = (String)this.m_modifiedItems.get("orclupdateschedule");
        if (updSchd != null) {
            this.m_updateSchedule = updSchd;
        }
        if ((hiqSchd = (String)this.m_modifiedItems.get("orclhiqschedule")) != null) {
            this.m_hiqSchedule = hiqSchd;
        }
        if ((agrmtName = (String)this.m_modifiedItems.get("orclagreementname")) != null) {
            this.m_agreementName = agrmtName;
        }
        if ((agrmtType = (OidReplAgreementType)((Object)this.m_modifiedItems.get("orclagreementtype"))) != null) {
            this.m_agreementType = agrmtType;
        }
        if ((connType = (String)this.m_modifiedItems.get("orclldapconnkeepalive")) != null) {
            this.m_connKeepAlive = connType.equals("1");
        }
        if ((replID = (String)this.m_modifiedItems.get("orclreplicationid")) != null) {
            this.m_orclReplicationID = replID;
        }
        this.m_modifiedItems.clear();
        this.m_newNamingContexts.clear();
        this.m_removedNamingContexts.clear();
    }

    public void close() {
        this.m_agreementName = null;
        this.m_agreementDN = null;
        this.m_agreementID = null;
        this.m_agreementType = null;
        if (this.m_namingContexts != null) {
            Collection<OidReplNamingContext> ncs = this.m_namingContexts.values();
            for (OidReplNamingContext nctx : ncs) {
                nctx.close();
            }
            this.m_namingContexts.clear();
            this.m_namingContexts = null;
        }
        if (this.m_queueStat != null) {
            for (OidChgNum chgNum : this.m_queueStat) {
                chgNum.close();
            }
            this.m_queueStat = null;
        }
        this.m_orclReplicationID = null;
        this.m_sizelimit = null;
        this.m_updateSchedule = null;
        this.m_hiqSchedule = null;
        this.m_replProtocol = null;
        this.clearChanges();
        this.m_modifiedItems = null;
        this.m_newNamingContexts = null;
        this.m_removedNamingContexts = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OidReplAgreementType {
        OID_ONEWAY,
        OID_TWOWAY,
        OID_MULTIMASTER;

    }
}

