/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplNamingContext;
import oracle.ldap.jremtool.OidReplUtil;
import oracle.ldap.jremtool.OidReplica;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidFanoutReplAgreement
extends OidReplAgreement {
    private OidReplica m_supplier;
    private OidReplica m_consumer;
    private static final OidReplLogger logger = OidReplLogger.getLogger(OidFanoutReplAgreement.class.getName());

    public OidFanoutReplAgreement(OidReplContext replContext) {
        super(replContext);
    }

    public OidFanoutReplAgreement(String agreementName, OidReplAgreement.OidReplAgreementType type, OidReplContext replContext) {
        super(replContext);
        this.m_agreementName = agreementName;
        this.m_agreementType = type;
    }

    public OidReplica getSupplier() {
        return this.m_supplier;
    }

    public void setSupplier(OidReplica supplier) {
        this.m_supplier = supplier;
    }

    public OidReplica getConsumer() {
        return this.m_consumer;
    }

    public void setConsumer(OidReplica consumer) {
        this.m_consumer = consumer;
    }

    @Override
    public boolean updateChanges() throws OidReplException {
        String replID;
        String connType;
        String agrmtType;
        String agrmtName;
        String hiqSchd;
        String direction = null;
        if (!this.m_isRecordChange) {
            logger.error("Not in Record mode. updateChanges() cannot be called.", new Object[0]);
            return false;
        }
        logger.dump("Updating changes of fanout replication agreement {0}.", this.m_agreementDN);
        HashSet<ModificationItem> mItems = new HashSet<ModificationItem>();
        String updSchd = (String)this.m_modifiedItems.get("orclupdateschedule");
        if (updSchd != null) {
            mItems.add(OidReplUtil.CreateModItem("orclupdateschedule", this.m_updateSchedule, 2));
        }
        if ((hiqSchd = (String)this.m_modifiedItems.get("orclhiqschedule")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclhiqschedule", this.m_hiqSchedule, 2));
        }
        if ((agrmtName = (String)this.m_modifiedItems.get("orclagreementname")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclagreementname", this.m_agreementName, 2));
        }
        if ((agrmtType = (String)this.m_modifiedItems.get("orclagreementtype")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclagreementtype", this.m_agreementType.toString(), 2));
        }
        if ((connType = (String)this.m_modifiedItems.get("orclldapconnkeepalive")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclldapconnkeepalive", this.m_connKeepAlive ? "1" : "0", 2));
        }
        if ((replID = (String)this.m_modifiedItems.get("orclreplicationid")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclreplicationid", this.m_orclReplicationID, 2));
        }
        LdapContext supCtx = this.m_supplier.getDirContext();
        LdapContext conCtx = this.m_consumer.getDirContext();
        ModificationItem[] modItems = new ModificationItem[mItems.size()];
        modItems = mItems.toArray(modItems);
        try {
            if (modItems.length > 0) {
                supCtx.modifyAttributes(this.m_agreementDN, modItems);
            }
            for (OidReplNamingContext newCtx : this.m_newNamingContexts) {
                OidReplNamingContext.OidReplDirection dir = newCtx.getDirection();
                if (dir == OidReplNamingContext.OidReplDirection.OID_REPL_SUPP_TO_CONS) {
                    direction = String.format(";%s$%s", this.m_supplier.getReplicaID(), this.m_consumer.getReplicaID());
                } else if (dir == OidReplNamingContext.OidReplDirection.OID_REPL_CONS_TO_SUPP) {
                    direction = String.format(";%s$%s", this.m_consumer.getReplicaID(), this.m_supplier.getReplicaID());
                }
                this.m_supplier.createNamingContextEntry(this.m_agreementDN, newCtx, direction);
            }
            for (OidReplNamingContext delCtx : this.m_removedNamingContexts) {
                this.m_supplier.deleteEntry(delCtx.getIncludedNamingCtxDN(), true);
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(9L, this.m_agreementDN, this.m_supplier.getHost(), this.m_supplier.getPort());
            logger.error(msg, ne);
            super.clearChanges();
            throw new OidReplException(msg, ne);
        }
        try {
            if (modItems.length > 0) {
                conCtx.modifyAttributes(this.m_agreementDN, modItems);
            }
            for (OidReplNamingContext newCtx : this.m_newNamingContexts) {
                this.m_consumer.createNamingContextEntry(this.m_agreementDN, newCtx, direction);
            }
            for (OidReplNamingContext delCtx : this.m_removedNamingContexts) {
                this.m_consumer.deleteEntry(delCtx.getIncludedNamingCtxDN(), true);
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(9L, this.m_agreementDN, this.m_consumer.getHost(), this.m_consumer.getPort());
            logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        this.m_modifiedItems.clear();
        this.m_isRecordChange = false;
        return true;
    }

    @Override
    public List<String> validate() throws OidReplException {
        String msg = null;
        LdapContext supCtx = null;
        LdapContext conCtx = null;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            supCtx = this.m_supplier.getDirContext();
        }
        catch (OidReplException ore) {
            logger.error(ore, "Validation failed.", new Object[0]);
            messages.add(ore.getMessage());
        }
        try {
            conCtx = this.m_consumer.getDirContext();
        }
        catch (OidReplException ore) {
            logger.error(ore, "Validation failed.", new Object[0]);
            messages.add(ore.getMessage());
        }
        if (supCtx == null || conCtx == null) {
            return messages;
        }
        if (this.m_agreementName == null || this.m_agreementName.trim().equals("")) {
            msg = this.m_replContext.getString(38L, new Object[0]);
            logger.error(msg, new Object[0]);
            messages.add(msg);
        } else {
            List<? extends OidReplAgreement> agrmts = this.m_replContext.getAgreements();
            for (OidReplAgreement oidReplAgreement : agrmts) {
                if (!oidReplAgreement.getAgreementName().trim().equalsIgnoreCase(this.m_agreementName.trim())) continue;
                msg = this.m_replContext.getString(39L, this.m_agreementName, oidReplAgreement.getAgreementDN());
                logger.error(msg, new Object[0]);
                messages.add(msg);
                break;
            }
        }
        try {
            this.m_consumer.setReplicaID();
        }
        catch (OidReplException ore) {
            messages.add(ore.getLocalizedMessage());
        }
        String consId = this.m_consumer.getReplicaID();
        if (consId == null) {
            msg = this.m_replContext.getString(11L, this.m_consumer.getHost(), this.m_consumer.getPort());
            messages.add(msg);
            logger.error(msg, new Object[0]);
        }
        try {
            this.m_supplier.setReplicaID();
        }
        catch (OidReplException ore) {
            messages.add(ore.getLocalizedMessage());
        }
        String supId = this.m_supplier.getReplicaID();
        if (supId == null) {
            msg = this.m_replContext.getString(11L, this.m_supplier.getHost(), this.m_supplier.getPort());
            messages.add(msg);
            logger.error(msg, new Object[0]);
        }
        if (consId == null || supId == null) {
            return messages;
        }
        if (consId.equalsIgnoreCase(supId)) {
            msg = this.m_replContext.getString(40L, consId);
            messages.add(msg);
            logger.error(msg, new Object[0]);
            return messages;
        }
        SearchControls searchControls = new SearchControls();
        try {
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> res = conCtx.search("cn=replication configuration", "(objectclass=orclreplagreemententry)", searchControls);
            block11: while (res.hasMore()) {
                NamingEnumeration<?> vals;
                SearchResult sr = res.next();
                String agrmntDN = sr.getNameInNamespace();
                String replid = OidReplUtil.getReplicaIdFromDN(agrmntDN);
                if (replid.equalsIgnoreCase(consId)) {
                    messages.add(this.m_replContext.getString(12L, consId, agrmntDN));
                    continue;
                }
                Attributes atrs = sr.getAttributes();
                Attribute replicas = null;
                replicas = OidReplUtil.getRequiredAttribute("orclreplicadn", atrs, true);
                if (replicas != null) {
                    vals = replicas.getAll();
                    while (vals != null & vals.hasMore()) {
                        replid = OidReplUtil.getReplicaIdFromDN((String)vals.next());
                        if (!replid.equalsIgnoreCase(consId)) continue;
                        messages.add(this.m_replContext.getString(12L, consId, agrmntDN));
                        continue block11;
                    }
                    continue;
                }
                replicas = OidReplUtil.getRequiredAttribute("orcldirreplgroupdsas", atrs, true);
                if (replicas == null) continue;
                vals = replicas.getAll();
                while (vals != null & vals.hasMore()) {
                    replid = (String)vals.next();
                    if (replid == null || !replid.equalsIgnoreCase(consId)) continue;
                    messages.add(this.m_replContext.getString(12L, consId, agrmntDN));
                    continue block11;
                }
            }
        }
        catch (NamingException ne) {
            messages.add(ne.getMessage());
        }
        if (messages.size() > 0) {
            return messages;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNamingContextEntries() throws OidReplException {
        int count = 0;
        String direction = null;
        Vector nctxs = new Vector(this.m_namingContexts.values());
        logger.dump("Creating naming context entries for {0} at ldap://{1}:{2}", this.m_agreementDN, this.m_supplier.getHost(), this.m_supplier.getPort());
        this.m_supplier.createNamingContextContainerEntry(this.m_agreementDN);
        try {
            for (OidReplNamingContext ctx : nctxs) {
                ++count;
                OidReplNamingContext.OidReplDirection dir = ctx.getDirection();
                if (dir == OidReplNamingContext.OidReplDirection.OID_REPL_SUPP_TO_CONS) {
                    direction = String.format(";%s$%s", this.m_supplier.getReplicaID(), this.m_consumer.getReplicaID());
                } else if (dir == OidReplNamingContext.OidReplDirection.OID_REPL_CONS_TO_SUPP) {
                    direction = String.format(";%s$%s", this.m_consumer.getReplicaID(), this.m_supplier.getReplicaID());
                }
                this.m_supplier.createNamingContextEntry(this.m_agreementDN, ctx, direction);
            }
        }
        finally {
            nctxs.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        this.m_supplier = null;
        this.m_consumer = null;
    }
}

