/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.logging.Level;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplica;

public class OidChgNum {
    private long m_logsToBeTransported = -1L;
    private long m_lastAppliedChangeNumberApply = -1L;
    private long m_lastAppliedChangeNumberTransport = -1L;
    private long m_new = -1L;
    private long m_retry = -1L;
    private long m_purge = -1L;
    private long m_hiq = -1L;
    private OidReplAgreement m_agreement;
    private OidReplica m_supplier;
    private OidReplica m_consumer;
    private static final OidReplLogger logger = OidReplLogger.getLogger(OidChgNum.class.getName());

    OidChgNum() {
    }

    public OidReplica getConsumer() {
        return this.m_consumer;
    }

    public void setConsumer(OidReplica consumer) {
        this.m_consumer = consumer;
    }

    public long getHiq() {
        return this.m_hiq;
    }

    public void setHiq(long hiq) {
        this.m_hiq = hiq;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "HIQ queue count is set to {0}", this.m_hiq);
        }
    }

    public long getLastAppliedChangeNumberApply() {
        return this.m_lastAppliedChangeNumberApply;
    }

    public void setLastAppliedChangeNumberApply(long appliedChangeNumber) {
        this.m_lastAppliedChangeNumberApply = appliedChangeNumber;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "Last applied change number for apply is set to {0}", this.m_lastAppliedChangeNumberApply);
        }
    }

    public long getLastAppliedChangeNumberTransport() {
        return this.m_lastAppliedChangeNumberTransport;
    }

    public void setLastAppliedChangeNumberTransport(long appliedChangeNumber) {
        this.m_lastAppliedChangeNumberTransport = appliedChangeNumber;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "Last applied change number for transport is set to {0}", this.m_lastAppliedChangeNumberTransport);
        }
    }

    public long getNew() {
        return this.m_new;
    }

    public void setNew(long newQueueCount) {
        this.m_new = newQueueCount;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "New change log queue count is set to {0}", this.m_new);
        }
    }

    public long getPurge() {
        return this.m_purge;
    }

    public void setPurge(long purgeQueueCount) {
        this.m_purge = purgeQueueCount;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "Purge queue count is set to {0}", this.m_purge);
        }
    }

    public long getRetry() {
        return this.m_retry;
    }

    public void setRetry(long retryQueueCount) {
        this.m_retry = retryQueueCount;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "Retry queue count is set to {0}", this.m_retry);
        }
    }

    public OidReplica getSupplier() {
        return this.m_supplier;
    }

    public void setSupplier(OidReplica supplier) {
        this.m_supplier = supplier;
    }

    public long getLogsToBeTransported() {
        return this.m_logsToBeTransported;
    }

    public void setLogsToBeTransported(long toBeTransported) {
        this.m_logsToBeTransported = toBeTransported;
        if (logger.isDumpEnabled()) {
            this.log(Level.FINE, "Number of change logs to be transported is set to {0}", this.m_logsToBeTransported);
        }
    }

    public OidReplAgreement getReplAgreement() {
        return this.m_agreement;
    }

    public void setReplAgreement(OidReplAgreement agreement) {
        this.m_agreement = agreement;
    }

    public void log(Level p, String o, Object ... params) {
        String info = "";
        if (this.m_supplier != null & this.m_consumer != null) {
            info = "Supplier = " + this.m_supplier.getReplicaID() + " : " + "Consumer = " + this.m_consumer.getReplicaID() + " : ";
        }
        info = info + o;
        logger.log(p, info, params);
    }

    public void close() {
        this.m_agreement = null;
        this.m_supplier = null;
        this.m_consumer = null;
    }
}

