/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import oracle.classloader.util.ClassLoadEnvironment;

public class URLParseUtil {
    private static boolean ENABLED = ClassLoadEnvironment.encodeResourceURLs();
    private static BitSet encodedInPath;

    public static String encodePath(String path) {
        return URLParseUtil.encodePath(path, true);
    }

    public static String encodePath(String path, boolean flag) {
        if (ENABLED) {
            char[] retCC = new char[path.length() * 2 + 16];
            int retLen = 0;
            char[] pathCC = path.toCharArray();
            int n = path.length();
            for (int i = 0; i < n; ++i) {
                char c = pathCC[i];
                if (!flag && c == '/' || flag && c == File.separatorChar) {
                    retCC[retLen++] = 47;
                } else if (c <= '\u007f') {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        retCC[retLen++] = c;
                    } else if (encodedInPath.get(c)) {
                        retLen = URLParseUtil.escape(retCC, c, retLen);
                    } else {
                        retCC[retLen++] = c;
                    }
                } else if (c > '\u07ff') {
                    retLen = URLParseUtil.escape(retCC, (char)(0xE0 | c >> 12 & 0xF), retLen);
                    retLen = URLParseUtil.escape(retCC, (char)(0x80 | c >> 6 & 0x3F), retLen);
                    retLen = URLParseUtil.escape(retCC, (char)(0x80 | c & 0x3F), retLen);
                } else {
                    retLen = URLParseUtil.escape(retCC, (char)(0xC0 | c >> 6 & 0x1F), retLen);
                    retLen = URLParseUtil.escape(retCC, (char)(0x80 | c & 0x3F), retLen);
                }
                if (retLen + 9 <= retCC.length) continue;
                int newLen = retCC.length * 2 + 16;
                if (newLen < 0) {
                    newLen = Integer.MAX_VALUE;
                }
                char[] buf = new char[newLen];
                System.arraycopy(retCC, 0, buf, 0, retLen);
                retCC = buf;
            }
            return new String(retCC, 0, retLen);
        }
        return path;
    }

    private static int escape(char[] cc, char c, int index) {
        cc[index++] = 37;
        cc[index++] = Character.forDigit(c >> 4 & 0xF, 16);
        cc[index++] = Character.forDigit(c & 0xF, 16);
        return index;
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    public static String decode(String s) {
        if (ENABLED && s != null && s.contains("%")) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c != '%') {
                    ++i;
                } else {
                    try {
                        c = URLParseUtil.unescape(s, i);
                        i += 3;
                        if ((c & 0x80) != 0) {
                            switch (c >> 4) {
                                case 12: 
                                case 13: {
                                    char c2 = URLParseUtil.unescape(s, i);
                                    i += 3;
                                    c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                    break;
                                }
                                case 14: {
                                    char c2 = URLParseUtil.unescape(s, i);
                                    char c3 = URLParseUtil.unescape(s, i += 3);
                                    i += 3;
                                    c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (!(path = URLParseUtil.encodePath(path)).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    static {
        if (ENABLED) {
            encodedInPath = new BitSet(256);
            encodedInPath.set(61);
            encodedInPath.set(59);
            encodedInPath.set(63);
            encodedInPath.set(35);
            encodedInPath.set(32);
            encodedInPath.set(60);
            encodedInPath.set(62);
            encodedInPath.set(37);
            encodedInPath.set(34);
            encodedInPath.set(123);
            encodedInPath.set(125);
            encodedInPath.set(124);
            encodedInPath.set(92);
            encodedInPath.set(94);
            encodedInPath.set(91);
            encodedInPath.set(93);
            encodedInPath.set(96);
            for (int i = 0; i < 32; ++i) {
                encodedInPath.set(i);
            }
            encodedInPath.set(127);
        }
    }
}

