/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.classloader.util.ClassLoadEnvironment;

public class PropertyUtils {
    public static String SERVICE_RESOURCE_PREFIX = "META-INF/services/";

    public static String getServiceResourcePath(String relativePath) {
        return SERVICE_RESOURCE_PREFIX + relativePath;
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = ClassLoadEnvironment.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("") || value.equalsIgnoreCase("true");
    }

    public static String getProperty(String key, String defaultValue) {
        String result = ClassLoadEnvironment.getProperty(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static List getPathsFromProperty(String propertyName) {
        ArrayList<String> list = new ArrayList<String>();
        String path = ClassLoadEnvironment.getProperty(propertyName);
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String p = st.nextToken().trim();
                if (p.startsWith("\"")) {
                    p = p.substring(1);
                }
                if (p.endsWith("\"")) {
                    p = p.substring(0, p.length() - 1);
                }
                list.add(p);
            }
        }
        return list;
    }

    public static String getServiceProperty(ClassLoader loader, String propertyName, String defaultValue) throws IOException {
        String result = null;
        if (propertyName != null && (result = ClassLoadEnvironment.getProperty(propertyName)) == null) {
            String resourceName = PropertyUtils.getServiceResourcePath(propertyName);
            InputStream is = loader.getResourceAsStream(resourceName);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                result = rd.readLine();
                rd.close();
            } else {
                result = defaultValue;
            }
        }
        return result;
    }
}

