/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Method;
import java.util.logging.Level;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.query.QueryProcessor;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadTracing;

public class MainClass {
    private String[] args;
    private String className;
    private PolicyClassLoader loader;

    public MainClass(String[] args, String className, PolicyClassLoader mainLoader) {
        this.args = args;
        this.className = className;
        this.loader = mainLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public PolicyClassLoader getLoader() {
        return this.loader;
    }

    public void invoke() throws Exception {
        Thread.currentThread().setContextClassLoader(this.loader);
        if (ClassLoadEnvironment.commitLoaderBeforeInvokeMain()) {
            this.loader.commit();
        }
        if (ClassLoadLogger.willLog(Level.FINE)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Initial class loaders created. Uptime: ");
            builder.append(ClassLoadTracing.getUpTime());
            builder.append("ms.");
            ClassLoadLogger.log(Level.FINE, builder.toString());
            builder.setLength(0);
            builder.append("Loading main class ");
            builder.append(this.className);
            builder.append("...");
            ClassLoadLogger.log(Level.FINE, builder.toString());
        }
        Class mainClass = this.loader.loadClass(this.className);
        Method main = mainClass.getMethod("main", String[].class);
        main.setAccessible(true);
        QueryProcessor.executeTransferQueries(ClassLoadLogger.getLogger());
        if (!QueryProcessor.shouldExit()) {
            if (ClassLoadLogger.willLog(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.className);
                builder.append("Main class loaded. Uptime: ");
                builder.append(ClassLoadTracing.getUpTime());
                builder.append("ms.");
                ClassLoadLogger.log(Level.FINE, builder.toString());
                builder.setLength(0);
                builder.append("Transferring to ");
                builder.append(this.className);
                builder.append(".main(");
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(this.args[i]);
                }
                builder.append(")...");
                ClassLoadLogger.log(Level.FINE, builder.toString());
            }
            main.invoke(null, new Object[]{this.args});
        }
    }
}

