/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedText {
    private String name;
    private ResourceBundle resources;

    public LocalizedText(String resourceBundleName, ResourceBundle bundle) {
        this.name = resourceBundleName;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(resourceBundleName);
        }
        this.resources = bundle;
    }

    public synchronized String getResourceString(String resourceKey) {
        try {
            return this.resources.getString(resourceKey);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String getText(String key) {
        String message = this.getResourceString(key);
        if (message == null) {
            throw new IllegalStateException("No text found for: \"" + key + "\" in " + this.name);
        }
        return message;
    }

    public String getText(String key, int sub0) {
        return this.getText(key, new Object[]{Integer.toString(sub0)});
    }

    public String getText(String key, Object sub0) {
        return this.getText(key, new Object[]{sub0});
    }

    public String getText(String key, Object sub0, Object sub1) {
        return this.getText(key, new Object[]{sub0, sub1});
    }

    public String getText(String key, Object sub0, Object sub1, Object sub2) {
        return this.getText(key, new Object[]{sub0, sub1, sub2});
    }

    public String getText(String key, Object sub0, Object sub1, Object sub2, Object sub3) {
        return this.getText(key, new Object[]{sub0, sub1, sub2, sub3});
    }

    public String getText(String key, Object[] substitutionValues) {
        return MessageFormat.format(this.getText(key), substitutionValues);
    }
}

