/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.PathElement;
import oracle.classloader.util.URLParseUtil;

public class FileUtils {
    public static final boolean ON_WINDOWS = FileUtils.onWindows();
    private static final boolean USE_NATIVE_CANONICALIZATION = ClassLoadEnvironment.shouldUseNativeCanonicalization();

    private static boolean onWindows() {
        return File.separatorChar == '\\';
    }

    public static File getCanonicalFile(File file) {
        return FileUtils.getCanonicalFile(file, (ConfigurationOrigin)null);
    }

    public static File getCanonicalFile(File file, ConfigurationOrigin origin) {
        File result;
        block4: {
            result = FileUtils.canonicalizeFileExceptForLinks(file);
            if (USE_NATIVE_CANONICALIZATION) {
                try {
                    result = result.getCanonicalFile();
                }
                catch (IOException e) {
                    if (!ClassLoadLogger.willLog(Level.INFO)) break block4;
                    StringBuffer buf = new StringBuffer();
                    buf.append("Could not canonicalize '");
                    buf.append(file);
                    buf.append("' (");
                    buf.append(e.getMessage());
                    buf.append(").");
                    if (origin != null) {
                        buf.append(" From ");
                        buf.append(origin);
                        buf.append('.');
                    }
                    ClassLoadLogger.log(Level.INFO, buf.toString());
                }
            }
        }
        return result;
    }

    public static File canonicalizeFileExceptForLinks(File file) {
        String path = FileUtils.removeDottedPathEntries(file.getAbsolutePath());
        if (ON_WINDOWS) {
            path.replace('/', '\\');
        } else {
            path.replace('\\', '/');
        }
        return new File(path);
    }

    private static String removeDottedPathEntries(String path) {
        if (path.indexOf(46) >= 0) {
            int limit;
            int i;
            if (path.indexOf(92) >= 0) {
                path = path.replace('\\', '/');
            }
            while ((i = path.indexOf("/./")) >= 0) {
                path = path.substring(0, i) + path.substring(i + 2);
            }
            i = 0;
            while ((i = path.indexOf("/../", i)) > 0) {
                limit = path.lastIndexOf(47, i - 1);
                if (limit >= 0) {
                    path = path.substring(0, limit) + path.substring(i + 3);
                    i = 0;
                    continue;
                }
                i += 3;
            }
            while (path.endsWith("/..") && (limit = path.lastIndexOf(47, (i = path.indexOf("/..")) - 1)) >= 0) {
                path = path.substring(0, limit + 1);
            }
            if (path.startsWith("./") && path.length() > 2) {
                path = path.substring(2);
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public static String getCanonicalPath(String s) {
        char sep = '/';
        char[] c = null;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.contains("//")) {
            char[] c0 = s.toCharArray();
            StringBuilder sb0 = new StringBuilder();
            int len = c0.length;
            for (int i = 0; i < len; ++i) {
                char tempChar = c0[i];
                if (tempChar == sep) {
                    if (i > 0 && c0[i - 1] == sep) continue;
                    sb0.append(tempChar);
                    continue;
                }
                sb0.append(tempChar);
            }
            c = new String(sb0).toCharArray();
        } else {
            c = new String(s).toCharArray();
        }
        int begin = 0;
        int index = s.indexOf(sep, begin);
        StringBuilder sb = new StringBuilder();
        do {
            if (c[begin] == '.') {
                if (c.length == begin + 1 || c[begin + 1] == sep) {
                    if ((begin += 2) > c.length) {
                        begin = c.length;
                    }
                } else if (c[begin + 1] == '.' && (c.length == begin + 2 || c[begin + 2] == sep)) {
                    if (sb.length() < 2) {
                        return null;
                    }
                    int lastIndex = -1;
                    for (int i = sb.length() - 2; i >= 0; --i) {
                        if (sb.charAt(i) != sep) continue;
                        lastIndex = i;
                        break;
                    }
                    sb.setLength(lastIndex + 1);
                    if ((begin += 3) > c.length) {
                        begin = c.length;
                    }
                } else {
                    if (index == -1) break;
                    sb.append(c, begin, index + 1 - begin);
                    begin = index + 1;
                }
            } else {
                if (index == -1) break;
                sb.append(c, begin, index + 1 - begin);
                begin = index + 1;
            }
            index = s.indexOf(sep, begin);
        } while (begin < c.length && index < c.length);
        if (begin < c.length) {
            sb.append(c, begin, c.length - begin);
        }
        return new String(sb);
    }

    public static List getCanonicalPaths(String parentDirPath, List paths) throws MalformedURLException {
        if (paths == null || paths.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        File parentDir = FileUtils.getCanonicalFile(null, parentDirPath);
        for (int i = 0; i < paths.size(); ++i) {
            PathElement elem = (PathElement)paths.get(i);
            File file = FileUtils.getCanonicalFile(parentDir, elem.getPathName());
            result.add(file.getAbsolutePath());
            if (!elem.getIncludeArchivesFlag() || !file.isDirectory()) continue;
            FileUtils.addArchivePaths(file, result);
        }
        return result;
    }

    public static File getCanonicalFile(File parentDir, String path) throws MalformedURLException {
        File file;
        if (path == null) {
            throw new MalformedURLException("null path");
        }
        if ((path = FileUtils.doPropertyReplacement(path)).startsWith("file:")) {
            URL url = new URL(path);
            path = url.getPath().replace('/', File.separatorChar);
            try {
                if (path.indexOf(37) > 0) {
                    path = URLDecoder.decode(path, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                ClassLoadLogger.logException("Could not decode " + path, e, false);
            }
        }
        if (!(file = new File(path)).isAbsolute()) {
            file = new File(parentDir, path);
        }
        return FileUtils.getCanonicalFile(file);
    }

    public static String doPropertyReplacement(String value) throws MalformedURLException {
        int end;
        int start;
        if (value != null && (start = value.indexOf("${")) >= 0 && (end = value.indexOf(125, start + 1)) > start) {
            String propertyName;
            String replacement;
            StringBuffer buf = new StringBuffer();
            if (start > 0) {
                buf.append(value.substring(0, start));
            }
            if ((replacement = ClassLoadEnvironment.getProperty(propertyName = value.substring(start + 2, end))) == null) {
                throw new MalformedURLException(value + ". '" + propertyName + "' not found in system properties.");
            }
            buf.append(replacement);
            buf.append(value.substring(end + 1));
            return FileUtils.doPropertyReplacement(buf.toString());
        }
        return value;
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", URLParseUtil.encodePath(path));
    }

    private static void addArchivePaths(File directory, List list) {
        if (directory != null && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                list.add(FileUtils.getCanonicalFile(file).getPath());
            }
        }
    }
}

