/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.CodeSourceSearchPolicy;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.query.ListQueries;
import oracle.classloader.query.Query;
import oracle.classloader.query.QueryProcessor;
import oracle.classloader.util.AnnotatedClassFormatError;
import oracle.classloader.util.AnnotatedClassNotFoundException;
import oracle.classloader.util.AnnotatedLinkageError;
import oracle.classloader.util.AnnotatedNoClassDefFoundError;
import oracle.classloader.util.AnnotatedThrowable;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadTracing;
import oracle.classloader.util.ClassLoaderUtilities;
import oracle.classloader.util.ClassPreprocessor;
import oracle.classloader.util.ClassPreprocessorSequence;
import oracle.classloader.util.PropertyUtils;
import oracle.classloader.util.ResourceFilter;
import oracle.classloader.util.SerializableAnnotation;
import oracle.classloader.util.ThrowableAnnotation;
import oracle.classloader.util.VersionNumber;

public class ClassLoadEnvironment {
    public static final String ENCODE_URLS_KEY = "encode.loader.urls";
    public static final String MANIFEST_DEPENDENCIES_WARN_ONLY = "manifest.dependencies.warn.only";
    public static final String DEFAULT_CLASS_LOAD_ENVIRONMENT_CLASS_KEY = "class.load.environment";
    public static final String DEFAULT_LOG_NAME = "oracle.classloader";
    public static final String ORIGINAL_CLASS_LOAD_TRACE_KEY = "class.load.trace";
    public static final String DEFAULT_CLASS_LOAD_TRACE_KEY = "class.load.log";
    public static final String DEFAULT_LOG_LEVEL_KEY = "class.load.log.level";
    public static final String DEFAULT_LOG_FILE_KEY = "class.load.log.file";
    public static final String DEFAULT_CLASS_LOAD_METRICS_KEY = "class.load.metrics";
    public static final String VERBOSE_METRICS_KEY = "class.load.metrics.verbose";
    public static final String CODE_SOURCE_POLICY_KEY = "code.source.policy";
    public static final String DEFAULT_TRANSFER_QUERY_KEY = "transfer.query";
    public static final String DEFAULT_START_QUERY_KEY = "start.query";
    public static final String JAVA_SPECIFICATION_KEY = "java.specification.version";
    public static final String NATIVE_CANONICALIZATION_KEY = "native.canonicalization";
    public static final String SET_MAIN_AS_SYSTEM_LOADER_KEY = "set.main.as.system.loader";
    public static final String CLEAN_JRE_LOADERS_KEY = "clean.jre.loaders";
    public static final String ANNOTATE_MISSING_CLASS_ERRORS = "annotate.missing.class.errors";
    public static final String DEFAULT_EXTENSION_INIT_ATTRIBUTE = "Extension-Init-Class";
    public static String DEFAULT_CLASS_PREPROCESSOR_KEY = "classloader.preprocessor";
    public static String DEFAULT_SYSTEM_CLASS_PREPROCESSOR_KEY = "system.classloader.preprocessor";
    public static final String DEFAULT_EXTENSION_KEY = "ext.dirs";
    public static final String DEFAULT_API_EXTENSION_KEY = "api.ext.dirs";
    public static final String DEFAULT_EXTENSION_DIRECTORY = "lib/ext";
    public static final String DEFAULT_API_EXTENSION_DIRECTORY = "lib/api-ext";
    public static final String DEFAULT_ROOT_LOADER_NAME = "jre.bootstrap";
    public static final String DEFAULT_EXTENSION_LOADER_NAME = "jre.extension";
    public static final String DEFAULT_API_LOADER_NAME = "api";
    public static final String DEFAULT_MAIN_LOADER_NAME = "main";
    public static final int DEFAULT_MINIMUM_CODE_SOURCE_IDLE_TICKS = 2;
    public static final String MINIMUM_CODE_SOURCE_IDLE_TICKS_KEY = "code.source.idle.ticks";
    public static final int DEFAULT_MAXIMUM_CODE_SOURCE_LRU_SIZE = 30;
    public static final String MAXIMUM_CODE_SOURCE_LRU_SIZE_KEY = "code.source.lru.size";
    public static final String DEFAULT_ORIGIN = "unknown";
    public static final String CLASS_TRANSFER_MODE_KEY = "class.transfer";
    public static final String EXTRA_TRANSFER_CLASSES_KEY = "extra.transfer.classes";
    public static final long START_TIME = System.currentTimeMillis();
    public static final String[] DEFAULT_QUERY_PACKAGES = new String[]{"oracle.classloader.query"};
    public static final ConfigurationOrigin DEFAULT_QUERY_LOADER_ORIGIN = new ConfigurationOrigin(ConfigurationType.RAW, "ClassLoading.executeQuery()");
    public static final String DEFAULT_PROPERTIES_FILE = "class-load.properties";
    public static final String DEFAULT_LEAK_DETECTOR_ACTIVATION_KEY = "detect.loader.leaks";
    public static final String MAXIMIZE_FILE_SHARING_KEY = "maximize.file.sharing";
    public static final String APPLICATION_LOG_MANAGER_ACTIVATION_KEY = "use.application.log.manager";
    public static final String MASK_JAXP_SYSTEM_RESOURCES_KEY = "mask.jaxp.system.resource";
    private static boolean maskJAXPSystemResources;
    public static final String DIRECTORY_FILE_URL_KEY = "dir.file.url";
    public static final String VERBOSE_TOSTRING_KEY = "verbose.loader.tostring";
    public static final String BACKUP_SYSTEM_CLASS_LOADER_FIELD = "system.loader.field";
    public static final String EXTERNAL_CLASSES_FILE_KEY = "external.classes.file";
    public static final String EXTERNAL_CLASSES_FILE = "external-classes.txt";
    public static boolean ORACLE_DOMAIN;
    public static final Class[] FRAMEWORK_EXTERNAL_CLASSES;
    public static final String[] FIXED_TRANSFER_CLASSES;
    private static VersionNumber queryLoaderVersion;
    private static ClassLoadEnvironment delegate;
    private static File ourLocation;
    private static boolean javaSystemLoader;
    private static File configurationDirectory;
    private Properties properties;
    private static Map queryNameMap;

    private static boolean isOracleDomain() {
        boolean result = false;
        try {
            result = InetAddress.getLocalHost().getCanonicalHostName().endsWith("oracle.com");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isOracleTestEnvironment() {
        return ORACLE_DOMAIN && System.getenv("T_WORK") != null;
    }

    private static synchronized void createDelegate() {
        ClassLoader loader = ClassLoadEnvironment.class.getClassLoader();
        String key = DEFAULT_CLASS_LOAD_ENVIRONMENT_CLASS_KEY;
        try {
            String name = PropertyUtils.getServiceProperty(loader, key, null);
            if (name != null) {
                loader.loadClass(name).newInstance();
            }
        }
        catch (Throwable e) {
            System.out.println("WARNING: Could not create envrironment instance: " + e);
        }
        if (delegate == null) {
            new ClassLoadEnvironment();
        }
        delegate.init();
    }

    public static ClassLoadEnvironment getDelegate() {
        if (delegate == null) {
            ClassLoadEnvironment.createDelegate();
        }
        return delegate;
    }

    public static ClassLoadEnvironment setDelegate(ClassLoadEnvironment newDelegate) {
        ClassLoadEnvironment old = delegate;
        delegate = newDelegate;
        return old;
    }

    public static String getProperty(String key) {
        if (key == DEFAULT_CLASS_LOAD_ENVIRONMENT_CLASS_KEY) {
            return System.getProperty(key);
        }
        return ClassLoadEnvironment.getDelegate().doGetProperty(key);
    }

    public static File getOurCodeSourceFile() {
        if (ourLocation == null) {
            try {
                Class<ClassLoadEnvironment> ourClass = ClassLoadEnvironment.class;
                ProtectionDomain ourDomain = ourClass.getProtectionDomain();
                CodeSource ourSource = ourDomain.getCodeSource();
                URL ourURL = ourSource.getLocation();
                String ourPath = ourURL.getPath();
                ourLocation = new File(ourPath).getAbsoluteFile();
            }
            catch (Throwable e) {
                System.out.println("Could not get code-source location: " + e);
            }
        }
        return ourLocation;
    }

    public static boolean isJavaSystemClassLoader() {
        return javaSystemLoader;
    }

    public static int getClassTransferMode() {
        return ClassLoadEnvironment.getDelegate().doGetClassTransferMode();
    }

    public static List getExtraTransferClasses() {
        return ClassLoadEnvironment.getDelegate().doGetExtraTransferClasses();
    }

    public static boolean maximizeFileSharing() {
        return ClassLoadEnvironment.getDelegate().doMaximizeFileSharing();
    }

    public static int getFileEqualityPolicyFor(File canonicalFile, SharedCodeSource existing, PolicyClassLoader subscriber, int defaultPolicy) {
        return ClassLoadEnvironment.getDelegate().doGetFileEqualityPolicyFor(canonicalFile, existing, subscriber, defaultPolicy);
    }

    public static String getDependencyResolutionMethodName() {
        return ClassLoadEnvironment.getDelegate().doGetDependencyResolutionMethodName();
    }

    public static boolean canThrowNoClassDefFoundError() {
        return ClassLoadEnvironment.getDelegate().doCanThrowNoClassDefFoundError();
    }

    public static boolean maskJAXPSystemResources() {
        return ClassLoadEnvironment.getDelegate().doMaskJAXPSystemResources();
    }

    public static CodeSourceSearchPolicy getDefaultCodeSourceSearchPolicy() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultCodeSourceSearchPolicy();
    }

    public static String getMetricsKey() {
        return ClassLoadEnvironment.getDelegate().doGetMetricsKey();
    }

    public static boolean enableMetrics() {
        return ClassLoadEnvironment.getDelegate().doEnableMetrics();
    }

    public static String getTraceKey() {
        return ClassLoadEnvironment.getDelegate().doGetTraceKey();
    }

    public static String getTraceOptions() {
        return ClassLoadEnvironment.getDelegate().doGetTraceOptions();
    }

    public static Level getTraceLogLevel() {
        return ClassLoadEnvironment.getDelegate().doGetTraceLogLevel();
    }

    public static String getLogName() {
        return ClassLoadEnvironment.getDelegate().doGetLogName();
    }

    public static String getLogLevelKey() {
        return ClassLoadEnvironment.getDelegate().doGetLogLevelKey();
    }

    public static String getLogFileKey() {
        return ClassLoadEnvironment.getDelegate().doGetLogFileKey();
    }

    public static String getTransferQueryKey() {
        return ClassLoadEnvironment.getDelegate().doGetTransferQueryKey();
    }

    public static String getTransferQuery() {
        return ClassLoadEnvironment.getDelegate().doGetTransferQuery();
    }

    public static String getStartQueryKey() {
        return ClassLoadEnvironment.getDelegate().doGetStartQueryKey();
    }

    public static String getStartQuery() {
        return ClassLoadEnvironment.getDelegate().doGetStartQuery();
    }

    public static void assertValidRuntime() {
        ClassLoadEnvironment.getDelegate().doAssertValidRuntime();
    }

    public static String getDisplayPath(String path) {
        return ClassLoadEnvironment.getDelegate().doGetDisplayPath(path);
    }

    public static boolean getVerboseMetrics() {
        return ClassLoadEnvironment.getDelegate().doGetVerboseMetrics();
    }

    public static boolean shouldUseNativeCanonicalization() {
        return ClassLoadEnvironment.getDelegate().doShouldUseNativeCanonicalization();
    }

    public static boolean setMainAsSystemLoader() {
        return ClassLoadEnvironment.getDelegate().doSetMainAsSystemLoader();
    }

    public static boolean cleanJRELoaders() {
        return ClassLoadEnvironment.getDelegate().doCleanJRELoaders();
    }

    public static boolean annotateMissingClassErrors() {
        return ClassLoadEnvironment.getDelegate().doAnnotateMissingClassErrors();
    }

    public static String getExtensionInitAttribute() {
        return ClassLoadEnvironment.getDelegate().doGetExtensionInitAttribute();
    }

    public static String getRootLoaderName() {
        return ClassLoadEnvironment.getDelegate().doGetRootLoaderName();
    }

    public static String getExtensionLoaderName() {
        return ClassLoadEnvironment.getDelegate().doGetExtensionLoaderName();
    }

    public static String getAPILoaderName() {
        return ClassLoadEnvironment.getDelegate().doGetAPILoaderName();
    }

    public static String getMainLoaderName() {
        return ClassLoadEnvironment.getDelegate().doGetMainLoaderName();
    }

    public static VersionNumber getAPIVersion() {
        return ClassLoadEnvironment.getDelegate().doGetAPIVersion();
    }

    public static VersionNumber getMainVersion() {
        return ClassLoadEnvironment.getDelegate().doGetMainVersion();
    }

    public static String getCustomManifestClassPathAtttribute() {
        return ClassLoadEnvironment.getDelegate().doGetCustomManifestClassPathAtttribute();
    }

    public static String getClassPreprocessorKey() {
        return ClassLoadEnvironment.getDelegate().doGetClassPreprocessorKey();
    }

    public static boolean allowClassPreprocessing() {
        return ClassLoadEnvironment.getDelegate().doAllowClassPreprocessing();
    }

    public static String getSystemClassPreprocessorKey() {
        return ClassLoadEnvironment.getDelegate().doGetSystemClassPreprocessorKey();
    }

    public static String getDefaultExtensionKey() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultExtensionKey();
    }

    public static String getDefaultApiExtensionKey() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultApiExtensionKey();
    }

    public static String getDefaultExtensionDirectory() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultExtensionDirectory();
    }

    public static String getDefaultApiExtensionDirectory() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultApiExtensionDirectory();
    }

    public static List filterJREExtensionCodeSource(List codeSourcePaths) {
        return ClassLoadEnvironment.getDelegate().doFilterJREExtensionCodeSource(codeSourcePaths);
    }

    public static SearchPolicy filterSearchPolicy(SearchPolicy policy, PolicyClassLoader loader) {
        return ClassLoadEnvironment.getDelegate().doFilterSearchPolicy(policy, loader);
    }

    public static int getDefaultMinimumCodeSourceIdleTicks() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultMinimumCodeSourceIdleTicks();
    }

    public static boolean shouldCloseOnIdle(SharedCodeSource source, int idleTicks) {
        return ClassLoadEnvironment.getDelegate().doShouldCloseOnIdle(source, idleTicks);
    }

    public static boolean allowCodeSource(SharedCodeSource cs, PolicyClassLoader pcl) {
        return ClassLoadEnvironment.getDelegate().doAllowCodeSource(cs, pcl);
    }

    public static int getDefaultMaximumCodeSourceLRUSize() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultMaximumCodeSourceLRUSize();
    }

    public static String getApplicationName(PolicyClassLoader loader) {
        return ClassLoadEnvironment.getDelegate().doGetApplicationName(loader);
    }

    public static int getMainScopeLevel() {
        return ClassLoadEnvironment.getDelegate().doGetMainScopeLevel();
    }

    public static String getDefaultSharedCodeSourceOrigin() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultSharedCodeSourceOrigin();
    }

    public static String getDefaultInitialLoadersConfigurationOrigin() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultInitialLoadersConfigurationOrigin();
    }

    public static String getDefaultInheritedSharedLibrariesOrigin() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultInheritedSharedLibrariesOrigin();
    }

    public static boolean canWebLoaderOverrideClassOrResource(String classOrResourceName) {
        return ClassLoadEnvironment.getDelegate().doCanWebLoaderOverrideClassOrResource(classOrResourceName);
    }

    public static Class loadQueryClass(ClassLoader loader, String queryClassName, boolean allowAlias) throws ClassNotFoundException {
        return ClassLoadEnvironment.getDelegate().doLoadQueryClass(loader, queryClassName, allowAlias);
    }

    public static PolicyClassLoader createQueryLoader() {
        return ClassLoadEnvironment.getDelegate().doCreateQueryLoader();
    }

    public static String[] getDefaultQueryPackageNames() {
        return ClassLoadEnvironment.getDelegate().doGetDefaultQueryPackageNames();
    }

    public static void addQueryCodeSources(List codeSources) {
        ClassLoadEnvironment.getDelegate().doAddQueryCodeSources(codeSources);
    }

    public static Map getQueryDescriptions(List queryClassNames) {
        return ClassLoadEnvironment.getDelegate().doGetQueryDescriptions(queryClassNames);
    }

    public static Object setProperty(String key, String value) {
        return ClassLoadEnvironment.getDelegate().doSetProperty(key, value);
    }

    public static boolean activateLoaderLeakDetection() {
        return ClassLoadEnvironment.getDelegate().doActivateLoaderLeakDetection();
    }

    public static boolean encodeResourceURLs() {
        return ClassLoadEnvironment.getDelegate().doEncodeResourceURLs();
    }

    public static void exit(boolean force) {
        ClassLoadEnvironment.getDelegate().doExit(force);
    }

    public static boolean useFileSchemeForDirectoryURLs() {
        return ClassLoadEnvironment.getDelegate().doUseFileSchemeForDirectoryURLs();
    }

    public static void initURLHandling() throws Exception {
        ClassLoadEnvironment.getDelegate().doInitURLHandling();
    }

    public static boolean autoInstallURLHandlerFactory() {
        return ClassLoadEnvironment.getDelegate().doAutoInstallURLHandlerFactory();
    }

    public static boolean commitLoaderBeforeInvokeMain() {
        return ClassLoadEnvironment.getDelegate().doCommitLoaderBeforeInvokeMain();
    }

    public static boolean getVerboseLoaderToString() {
        return ClassLoadEnvironment.getDelegate().doGetVerboseLoaderToString();
    }

    public static String getBackupSystemClassLoaderFieldName() {
        return ClassLoadEnvironment.getDelegate().doGetBackupSystemClassLoaderFieldName();
    }

    public static String[] getExternalClassNames() throws IOException {
        return ClassLoadEnvironment.getDelegate().doGetExternalClassNames();
    }

    public static void setConfigurationDirectory(File directory) {
        configurationDirectory = directory;
    }

    public static File getConfigurationDirectory() {
        return configurationDirectory;
    }

    public static String getQueryClassName(String alias) {
        return ClassLoadEnvironment.getDelegate().doGetQueryClassName(alias);
    }

    protected ClassLoadEnvironment() {
        delegate = this;
    }

    protected void init() {
        this.properties = this.doGetSystemPropertiesOverrides();
        String type = this.doGetProperty("java.system.class.loader");
        if (type != null && type.indexOf("PolicyClassLoader") > 0) {
            javaSystemLoader = true;
        }
        if (this.doActivateApplicationLogManager()) {
            ClassLoadEnvironment.setProperty("java.util.logging.manager", "oracle.classloader.util.ApplicationLogManager");
            if (javaSystemLoader) {
                ClassLoadEnvironment.setProperty(CLASS_TRANSFER_MODE_KEY, "delegate");
            }
        }
        boolean maskJAXPSystemResourcesDefault = true;
        String javaSpec = ClassLoadEnvironment.getProperty(JAVA_SPECIFICATION_KEY);
        if (javaSpec == null || javaSpec.equals("1.1") || javaSpec.equals("1.2") || javaSpec.equals("1.3") || javaSpec.equals("1.4")) {
            maskJAXPSystemResourcesDefault = false;
        }
        maskJAXPSystemResources = PropertyUtils.getBooleanProperty(MASK_JAXP_SYSTEM_RESOURCES_KEY, maskJAXPSystemResourcesDefault);
    }

    protected Properties doGetSystemPropertiesOverrides() {
        try {
            File ourDir;
            File propsFile;
            File ourFile = ClassLoadEnvironment.getOurCodeSourceFile();
            if (ourFile != null && (propsFile = new File(ourDir = ourFile.getParentFile(), DEFAULT_PROPERTIES_FILE)).exists()) {
                Properties result = new Properties();
                FileInputStream in = new FileInputStream(propsFile);
                result.load(in);
                in.close();
                return result;
            }
        }
        catch (Throwable e) {
            System.out.println("Could not load properties file: " + e);
        }
        return null;
    }

    protected boolean doActivateApplicationLogManager() {
        return PropertyUtils.getBooleanProperty(APPLICATION_LOG_MANAGER_ACTIVATION_KEY, false);
    }

    protected String doGetProperty(String key) {
        String result;
        if (this.properties != null && (result = this.properties.getProperty(key)) != null) {
            return result;
        }
        return System.getProperty(key);
    }

    protected int doGetClassTransferMode() {
        int mode = 0;
        String prop = ClassLoadEnvironment.getProperty(CLASS_TRANSFER_MODE_KEY);
        if (prop != null) {
            if (prop.equalsIgnoreCase("fixed")) {
                mode = 0;
            } else if (prop.equalsIgnoreCase("scan")) {
                mode = 1;
            } else if (prop.equalsIgnoreCase("delegate")) {
                mode = 2;
            }
        }
        return mode;
    }

    protected List doGetExtraTransferClasses() {
        String value = ClassLoadEnvironment.getProperty(EXTRA_TRANSFER_CLASSES_KEY);
        if (value == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(value, ":;");
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    protected int doGetFileEqualityPolicyFor(File canonicalFile, SharedCodeSource existing, PolicyClassLoader subscriber, int defaultPolicy) {
        return defaultPolicy;
    }

    protected String doGetDependencyResolutionMethodName() {
        StackTraceElement[] stack = DependencyLoader.getCallStack();
        return stack[2].getMethodName();
    }

    protected boolean doCanThrowNoClassDefFoundError() {
        return true;
    }

    protected CodeSourceSearchPolicy doGetDefaultCodeSourceSearchPolicy() {
        CodeSourceSearchPolicy result;
        String policy = ClassLoadEnvironment.getProperty(CODE_SOURCE_POLICY_KEY);
        if (policy == null || policy.equals("linear")) {
            result = new CodeSourceSearchPolicy.Linear();
        } else if (policy.equals("index1")) {
            result = new CodeSourceSearchPolicy.RuntimeIndex1();
            ClassLoadLogger.log(Level.FINE, "Runtime package based code-source indexing scheme 1 enabled.");
        } else if (policy.equals("index2")) {
            result = new CodeSourceSearchPolicy.RuntimeIndex2();
            ClassLoadLogger.log(Level.FINE, "Runtime package based code-source indexing scheme 2 enabled.");
        } else {
            throw new Error("Unknown code.source.policy: " + policy);
        }
        return result;
    }

    protected String doGetMetricsKey() {
        return DEFAULT_CLASS_LOAD_METRICS_KEY;
    }

    protected boolean doEnableMetrics() {
        if (PropertyUtils.getBooleanProperty(this.doGetMetricsKey(), false)) {
            return true;
        }
        String query = this.doGetTransferQuery();
        if (query != null && query.indexOf("ClassLoadMetrics") >= 0) {
            return true;
        }
        query = this.doGetStartQuery();
        return query != null && query.indexOf("ClassLoadMetrics") >= 0;
    }

    protected String doGetTraceKey() {
        return DEFAULT_CLASS_LOAD_TRACE_KEY;
    }

    protected String doGetTraceOptions() {
        String result = ClassLoadEnvironment.getProperty(this.doGetTraceKey());
        if (result == null) {
            result = ClassLoadEnvironment.getProperty(ORIGINAL_CLASS_LOAD_TRACE_KEY);
        }
        return result;
    }

    protected Level doGetTraceLogLevel() {
        return Level.INFO;
    }

    protected String doGetLogName() {
        return DEFAULT_LOG_NAME;
    }

    protected String doGetLogLevelKey() {
        return DEFAULT_LOG_LEVEL_KEY;
    }

    protected String doGetLogFileKey() {
        return DEFAULT_LOG_FILE_KEY;
    }

    protected String doGetTransferQueryKey() {
        return DEFAULT_TRANSFER_QUERY_KEY;
    }

    protected String doGetTransferQuery() {
        String result = this.doGetProperty(this.doGetTransferQueryKey());
        if (result == null && (result = this.doGetProperty(DEFAULT_TRANSFER_QUERY_KEY)) == null) {
            result = this.doGetProperty("boot.query");
        }
        return result;
    }

    protected String doGetStartQueryKey() {
        return DEFAULT_START_QUERY_KEY;
    }

    protected String doGetStartQuery() {
        String result = this.doGetProperty(this.doGetStartQueryKey());
        if (result == null) {
            result = this.doGetProperty(DEFAULT_START_QUERY_KEY);
        }
        return result;
    }

    protected String doGetDisplayPath(String path) {
        return path;
    }

    protected void doAssertValidRuntime() {
        String javaSpec = ClassLoadEnvironment.getProperty(JAVA_SPECIFICATION_KEY);
        if (javaSpec == null || javaSpec.equals("1.1") || javaSpec.equals("1.2") || javaSpec.equals("1.3")) {
            throw new Error("Java runtime version 1.4 (or greater) is required. Found: " + javaSpec);
        }
    }

    protected boolean doGetVerboseMetrics() {
        return PropertyUtils.getBooleanProperty(VERBOSE_METRICS_KEY, false);
    }

    protected boolean doShouldUseNativeCanonicalization() {
        return PropertyUtils.getBooleanProperty(NATIVE_CANONICALIZATION_KEY, true);
    }

    protected boolean doSetMainAsSystemLoader() {
        return PropertyUtils.getBooleanProperty(SET_MAIN_AS_SYSTEM_LOADER_KEY, false);
    }

    protected boolean doCleanJRELoaders() {
        return PropertyUtils.getBooleanProperty(CLEAN_JRE_LOADERS_KEY, false);
    }

    protected boolean doAnnotateMissingClassErrors() {
        return PropertyUtils.getBooleanProperty(ANNOTATE_MISSING_CLASS_ERRORS, true);
    }

    protected String doGetExtensionInitAttribute() {
        return DEFAULT_EXTENSION_INIT_ATTRIBUTE;
    }

    protected String doGetRootLoaderName() {
        return DEFAULT_ROOT_LOADER_NAME;
    }

    protected String doGetExtensionLoaderName() {
        return DEFAULT_EXTENSION_LOADER_NAME;
    }

    protected String doGetAPILoaderName() {
        return DEFAULT_API_LOADER_NAME;
    }

    protected String doGetMainLoaderName() {
        return DEFAULT_MAIN_LOADER_NAME;
    }

    protected VersionNumber doGetAPIVersion() {
        return VersionNumber.ZERO;
    }

    protected VersionNumber doGetMainVersion() {
        return VersionNumber.ZERO;
    }

    protected String doGetCustomManifestClassPathAtttribute() {
        return DEFAULT_EXTENSION_INIT_ATTRIBUTE;
    }

    protected String doGetClassPreprocessorKey() {
        return DEFAULT_CLASS_PREPROCESSOR_KEY;
    }

    protected String doGetSystemClassPreprocessorKey() {
        return DEFAULT_SYSTEM_CLASS_PREPROCESSOR_KEY;
    }

    protected boolean doAllowClassPreprocessing() {
        return true;
    }

    protected String doGetDefaultExtensionKey() {
        return DEFAULT_EXTENSION_KEY;
    }

    protected String doGetDefaultApiExtensionKey() {
        return DEFAULT_API_EXTENSION_KEY;
    }

    protected String doGetDefaultExtensionDirectory() {
        return DEFAULT_EXTENSION_DIRECTORY;
    }

    protected String doGetDefaultApiExtensionDirectory() {
        return DEFAULT_API_EXTENSION_DIRECTORY;
    }

    protected List doFilterJREExtensionCodeSource(List codeSourcePaths) {
        return codeSourcePaths;
    }

    protected SearchPolicy doFilterSearchPolicy(SearchPolicy policy, PolicyClassLoader loader) {
        return policy;
    }

    protected int doGetDefaultMinimumCodeSourceIdleTicks() {
        String idleTicks = ClassLoadEnvironment.getProperty(MINIMUM_CODE_SOURCE_IDLE_TICKS_KEY);
        if (idleTicks != null) {
            return Integer.parseInt(idleTicks);
        }
        return 2;
    }

    protected boolean doShouldCloseOnIdle(SharedCodeSource source, int idleTicks) {
        return true;
    }

    protected boolean doAllowCodeSource(SharedCodeSource cs, PolicyClassLoader pcl) {
        return true;
    }

    protected int doGetDefaultMaximumCodeSourceLRUSize() {
        String lruSize = ClassLoadEnvironment.getProperty(MAXIMUM_CODE_SOURCE_LRU_SIZE_KEY);
        if (lruSize != null) {
            return Integer.parseInt(lruSize);
        }
        return 30;
    }

    protected String doGetApplicationName(PolicyClassLoader loader) {
        return loader.getName();
    }

    protected int doGetMainScopeLevel() {
        return Integer.MAX_VALUE;
    }

    protected String doGetDefaultSharedCodeSourceOrigin() {
        return DEFAULT_ORIGIN;
    }

    protected String doGetDefaultInitialLoadersConfigurationOrigin() {
        return DEFAULT_ORIGIN;
    }

    protected String doGetDefaultInheritedSharedLibrariesOrigin() {
        return DEFAULT_ORIGIN;
    }

    protected boolean doCanWebLoaderOverrideClassOrResource(String classOrResourceName) {
        if (classOrResourceName.startsWith("javax")) {
            String name = classOrResourceName.replace('/', '.');
            return !name.startsWith(".servlet.", 5);
        }
        return true;
    }

    protected String[] doGetDefaultQueryPackageNames() {
        return DEFAULT_QUERY_PACKAGES;
    }

    protected Class doLoadQueryClass(ClassLoader loader, String queryClassName, boolean allowAlias) throws ClassNotFoundException {
        if (queryClassName.indexOf(46) >= 0) {
            return loader.loadClass(queryClassName);
        }
        String queryClass = allowAlias ? ClassLoadEnvironment.getQueryClassName(queryClassName) : queryClassName;
        String[] packages = this.doGetDefaultQueryPackageNames();
        for (int i = 0; i < packages.length; ++i) {
            String name = packages[i] + "." + queryClass;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
        }
        return loader.loadClass(queryClassName);
    }

    protected synchronized PolicyClassLoader doCreateQueryLoader() {
        queryLoaderVersion = new VersionNumber(queryLoaderVersion.getVersionAt(0) + 1, 0, 0);
        return new PolicyClassLoader("query", queryLoaderVersion, ClassLoaderQuery.getMainLoader(), DEFAULT_QUERY_LOADER_ORIGIN, ConfigurationPolicy.RAW, SearchPolicy.ASK_PARENT, ProtectionPolicy.MAIN_PERMISSIONS);
    }

    protected void doAddQueryCodeSources(List codeSources) {
        codeSources.add(ClassLoaderQuery.getCodeSourceFor(ListQueries.class));
    }

    protected Map doGetQueryDescriptions(List queryClassNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String className : queryClassNames) {
            try {
                int modifiers;
                Class queryClass = QueryProcessor.loadQueryClass(className, false);
                if (!Query.class.isAssignableFrom(queryClass) || !Modifier.isPublic(modifiers = queryClass.getModifiers()) || Modifier.isAbstract(modifiers)) continue;
                Query query = (Query)queryClass.newInstance();
                result.put(className, query.getDescription());
            }
            catch (Exception e) {
                ClassLoadLogger.log(Level.INFO, "Could not load query class: " + e);
            }
        }
        return result;
    }

    protected Object doSetProperty(String key, String value) {
        String result = System.setProperty(key, value);
        if (key.equals(this.doGetTraceKey())) {
            ClassLoadTracing.activate(value);
        } else if (key.equals(this.doGetLogLevelKey())) {
            ClassLoadLogger.setLogLevel(value);
        } else if (key.equals(this.doGetLogFileKey())) {
            ClassLoadLogger.resetHandlers();
        }
        return result;
    }

    protected boolean doActivateLoaderLeakDetection() {
        return PropertyUtils.getBooleanProperty(DEFAULT_LEAK_DETECTOR_ACTIVATION_KEY, false);
    }

    protected boolean doEncodeResourceURLs() {
        return PropertyUtils.getBooleanProperty(ENCODE_URLS_KEY, false);
    }

    protected void doExit(boolean force) {
        System.exit(1);
    }

    protected boolean doMaximizeFileSharing() {
        return PropertyUtils.getBooleanProperty(MAXIMIZE_FILE_SHARING_KEY, false);
    }

    protected boolean doMaskJAXPSystemResources() {
        return maskJAXPSystemResources;
    }

    protected boolean doUseFileSchemeForDirectoryURLs() {
        return PropertyUtils.getBooleanProperty(DIRECTORY_FILE_URL_KEY, true);
    }

    protected void doInitURLHandling() throws Exception {
        SharedCodeSourceURL.register();
    }

    protected boolean doAutoInstallURLHandlerFactory() {
        return true;
    }

    protected boolean doCommitLoaderBeforeInvokeMain() {
        return true;
    }

    protected boolean doGetVerboseLoaderToString() {
        boolean result = PropertyUtils.getBooleanProperty(VERBOSE_TOSTRING_KEY, false);
        if (!result) {
            result = ClassLoadEnvironment.getProperty(DEFAULT_CLASS_LOAD_TRACE_KEY) != null;
        }
        return result;
    }

    protected String doGetBackupSystemClassLoaderFieldName() {
        String result = ClassLoadEnvironment.getProperty(BACKUP_SYSTEM_CLASS_LOADER_FIELD);
        if (result == null) {
            result = "applicationClassLoader";
        }
        return result;
    }

    protected String[] doGetExternalClassNames() throws IOException {
        File file;
        ArrayList list = null;
        String path = ClassLoadEnvironment.getProperty(EXTERNAL_CLASSES_FILE_KEY);
        if (path != null) {
            list = new ArrayList();
            ClassLoadEnvironment.parseFileLines(new File(path), list);
        }
        if (configurationDirectory != null && (file = new File(configurationDirectory, EXTERNAL_CLASSES_FILE)).exists()) {
            if (list == null) {
                list = new ArrayList();
            }
            ClassLoadEnvironment.parseFileLines(file, list);
        }
        if (list != null) {
            return (String[])ArrayUtils.toArray(String.class, list, false);
        }
        return null;
    }

    protected static void parseFileLines(File file, List result) throws IOException {
        if (file != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String name = in.readLine();
            while (name != null) {
                if ((name = name.trim()).length() > 0) {
                    result.add(name);
                }
                name = in.readLine();
            }
            in.close();
        }
    }

    protected String doGetQueryClassName(String alias) {
        if (queryNameMap == null) {
            queryNameMap = ClassLoadEnvironment.buildQueryNameMap();
        }
        return (String)queryNameMap.get(alias);
    }

    private static Map buildQueryNameMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            List queryClassNames = ListQueries.getQueryClassNames();
            Iterator iterator = queryClassNames.iterator();
            while (iterator.hasNext()) {
                String className;
                String name = className = (String)iterator.next();
                result.put(name, className);
                result.put(name.toLowerCase(), className);
            }
            result.put("find", "FindResource");
            result.put("audit", "AuditLoader");
            result.put("loaders", "LoaderTree");
            result.put("help", "ListQueries");
            result.put("?", "ListQueries");
            result.put("list", "ListQueries");
            result.put("!!!!!", "Exit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static {
        ORACLE_DOMAIN = ClassLoadEnvironment.isOracleDomain();
        FRAMEWORK_EXTERNAL_CLASSES = new Class[]{ClassPreprocessor.class, ClassPreprocessorSequence.class, ClassLoaderUtilities.class, ResourceFilter.class, VersionNumber.class, AnnotatedThrowable.class, ThrowableAnnotation.class, SerializableAnnotation.class, AnnotatedClassFormatError.class, AnnotatedClassNotFoundException.class, AnnotatedLinkageError.class, AnnotatedNoClassDefFoundError.class};
        FIXED_TRANSFER_CLASSES = new String[]{"oracle.classloader.CodeSourceAccessor", "oracle.classloader.Resource", "oracle.classloader.ResourceAccessor", "oracle.classloader.ResourceDataAccessor", "oracle.classloader.ResourcePathVisitor", "oracle.classloader.ResourceCollector", "oracle.classloader.MetaInfResourceCollector", "oracle.classloader.ClassLoaderFilters", "oracle.classloader.ExtensionDeclaration", "oracle.classloader.ClosedLoaderReference", "oracle.classloader.util.ClassLoadMonitor", "oracle.classloader.util.ClassDependencies", "oracle.classloader.util.ClassDependencies$Visitor", "oracle.classloader.MBean", "oracle.classloader.query.QueryProcessor", "oracle.classloader.util.ClassPreprocessor", "oracle.classloader.util.LoaderLeakDetector", "oracle.classloader.util.LoaderLeakDetector$State", "oracle.classloader.util.MissingClass", "oracle.classloader.util.PathElement"};
        queryLoaderVersion = VersionNumber.ZERO;
    }

    private static class DependencyLoader
    extends ClassLoader {
        private static final String CLASS_NAME = "load.C4";
        private static byte[] CLASS_DATA = new byte[]{-54, -2, -70, -66, 0, 0, 0, 48, 0, 18, 10, 0, 3, 0, 14, 7, 0, 15, 7, 0, 16, 7, 0, 17, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 18, 76, 111, 99, 97, 108, 86, 97, 114, 105, 97, 98, 108, 101, 84, 97, 98, 108, 101, 1, 0, 4, 116, 104, 105, 115, 1, 0, 9, 76, 108, 111, 97, 100, 47, 67, 52, 59, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 7, 67, 52, 46, 106, 97, 118, 97, 12, 0, 5, 0, 6, 1, 0, 7, 108, 111, 97, 100, 47, 67, 52, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 1, 0, 6, 108, 111, 97, 100, 47, 89, 0, 33, 0, 2, 0, 3, 0, 1, 0, 4, 0, 0, 0, 1, 0, 1, 0, 5, 0, 6, 0, 1, 0, 7, 0, 0, 0, 47, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 2, 0, 8, 0, 0, 0, 6, 0, 1, 0, 0, 0, 9, 0, 9, 0, 0, 0, 12, 0, 1, 0, 0, 0, 5, 0, 10, 0, 11, 0, 0, 0, 1, 0, 12, 0, 0, 0, 2, 0, 13};

        private DependencyLoader() {
        }

        public static StackTraceElement[] getCallStack() {
            DependencyLoader loader = new DependencyLoader();
            try {
                loader.defineClass(CLASS_NAME, CLASS_DATA, 0, CLASS_DATA.length);
            }
            catch (Throwable e) {
                return e.getStackTrace();
            }
            return null;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new Error();
        }
    }
}

