/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.tools;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import oracle.classloader.tools.ManifestFormatter;
import oracle.classloader.tools.ManifestState;

public class ManifestTreeFormatter
extends ManifestFormatter {
    private static final String FORMAT_OPTION = "-tree";
    private static final String OPTIONS = "[-a(bsolutePaths)] [-v(erbose)]";
    private static final String EMPTY = "   ";
    private static final String LINE = " | ";
    private static final String JOIN = " +-";
    private static final String JOIN_BOTTOM = " +-";
    private boolean verbose;
    private boolean[] parentDepth;
    private boolean firstJar;
    private boolean multipleJars;

    public String formatOption() {
        return FORMAT_OPTION;
    }

    public String options() {
        return OPTIONS;
    }

    protected boolean checkArgument(String argument) {
        if (argument.startsWith("-v")) {
            this.verbose = true;
            super.checkArgument("-a");
            return true;
        }
        return super.checkArgument(argument);
    }

    protected void append(ManifestState root, int currentIndex, int maxIndex) {
        this.parentDepth = new boolean[ManifestState.getActualMaxDepth() + 2];
        this.firstJar = currentIndex == 0;
        boolean bl = this.multipleJars = maxIndex > 0;
        if (!this.multipleJars && !this.verbose) {
            this.parentDepth[0] = true;
        }
        this.appendNode(root, false);
        if (currentIndex == maxIndex) {
            this.appendln();
        }
    }

    protected void appendNode(ManifestState manifest, boolean parentsLastChild) {
        ManifestState[] children;
        int depth = this.getDepth(manifest);
        if (!this.firstJar || depth > 1) {
            this.newLine(depth);
        }
        this.newNodeLine(depth, parentsLastChild);
        this.append(Character.valueOf(' '));
        if (depth == 1) {
            this.appendJarPath(manifest, true);
        } else {
            this.appendJarPath(manifest);
        }
        if (this.verbose) {
            this.appendAttributes(manifest);
        }
        if (parentsLastChild) {
            this.parentDepth[depth - 1] = true;
        }
        if ((children = manifest.getChildren()) != null) {
            int childCount = children.length;
            int lastChild = childCount - 1;
            for (int i = 0; i < childCount; ++i) {
                ManifestState child = children[i];
                if (child == null) continue;
                this.appendNode(child, i == lastChild);
            }
        }
        this.parentDepth[depth] = false;
    }

    private int getDepth(ManifestState manifest) {
        return manifest.getDepth() + 1;
    }

    private void appendAttributes(ManifestState manifestState) {
        Manifest manifest = manifestState.getManifest();
        if (manifest != null) {
            int depth = this.getDepth(manifestState);
            this.newLine(depth);
            this.append(manifest.getMainAttributes(), depth);
            for (Map.Entry<String, Attributes> e : manifest.getEntries().entrySet()) {
                this.newLine(depth);
                this.append("Name: ");
                String value = e.getKey();
                this.append(value);
                this.append(e.getValue(), depth);
            }
            String[] classPath = manifestState.getClassPath();
            if (classPath.length > 0) {
                this.newLine(depth);
                this.append(Attributes.Name.CLASS_PATH);
                this.append(":");
                for (int i = 0; i < classPath.length; ++i) {
                    this.append(Character.valueOf(' '));
                    this.append(classPath[i]);
                }
            }
        }
    }

    private void append(Attributes attributes, int depth) {
        for (Attributes.Name name : attributes.keySet()) {
            if (name.equals(Attributes.Name.CLASS_PATH)) continue;
            String value = attributes.getValue(name);
            this.newLine(depth);
            this.append(name);
            this.append(": ");
            this.append(value);
        }
    }

    private void indent(int depth) {
        for (int i = 0; i < depth; ++i) {
            if (this.parentDepth[i]) {
                this.append(EMPTY);
                continue;
            }
            this.append(LINE);
        }
    }

    private void newLine(int depth) {
        this.appendln();
        this.indent(depth);
    }

    private void newNodeLine(int depth, boolean parentsLastChild) {
        if (depth > 0) {
            this.appendln();
        }
        this.indent(depth - 1);
        if (depth > 0) {
            if (parentsLastChild) {
                this.append(" +-");
            } else {
                this.append(" +-");
            }
        }
    }
}

