/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.ClassLoadTracing;

public class Uptime
extends ReportQuery {
    private static final int MIILIS_PER_SECOND = 1000;
    private static final int MIILIS_PER_MINUTE = 60000;
    private static final int MIILIS_PER_HOUR = 3600000;
    private static final int MIILIS_PER_DAY = 86400000;

    public String getDescription() {
        return "Report how long the system has been running.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.append("System uptime: ");
        Uptime.appendUpTime(this.getReportBuffer());
    }

    public static void appendUpTime(StringBuffer buffer) {
        long uptime = ClassLoadTracing.getUpTime();
        long millis = Uptime.appendElapsed(uptime, 86400000, buffer, null);
        millis = Uptime.appendElapsed(millis, 3600000, buffer, ":");
        millis = Uptime.appendElapsed(millis, 60000, buffer, ":");
        millis = Uptime.appendElapsed(millis, 1000, buffer, ":");
        Uptime.appendElapsed(millis, 1, buffer, " ");
        buffer.append("ms");
    }

    private static long appendElapsed(long millis, int millisInUnit, StringBuffer buffer, String prefix) {
        if (prefix != null) {
            buffer.append(prefix);
        }
        if (millis > (long)millisInUnit) {
            int units = (int)millis / millisInUnit;
            millis -= (long)(units * millisInUnit);
            if (units < 10) {
                buffer.append('0');
            }
            buffer.append(Integer.toString(units));
        } else {
            buffer.append("00");
        }
        return millis;
    }
}

