/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.SharedCodeSource;

public class UnusedCodeSources
extends ClassLoaderQuery {
    public String getDescription() {
        return "List any code-sources from which no classes or resources have been loaded.";
    }

    public void createQueryReport(String[] args) throws Exception {
        List unused = UnusedCodeSources.find();
        if (unused.size() == 0) {
            this.appendln("No unused code-sources found.");
        } else {
            this.appendln("The following code-sources have not been used:");
            for (SharedCodeSource source : unused) {
                this.indent();
                this.appendln(source);
            }
            this.appendln();
        }
    }

    public static List find() {
        ArrayList<SharedCodeSource> result = new ArrayList<SharedCodeSource>();
        for (SharedCodeSource source : UnusedCodeSources.getAllCodeSources()) {
            if (source.getLastReadTick() >= 0) continue;
            result.add(source);
        }
        return result;
    }
}

