/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.Query;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public abstract class ReportQuery
implements Query {
    private static final int WRAP_WHITESPACE_SLOP = 16;
    public static final String EOL = ClassLoadLogger.EOL;
    public static final String INDENT = "    ";
    private StringBuffer report = new StringBuffer();

    public abstract String getDescription();

    public Serializable execute(String[] args) throws Exception {
        if (args.length == 1 && args[0].equals("-help")) {
            String description = this.getDescription();
            this.appendln();
            this.appendWrapped("", 0, 80, description);
            this.appendln();
        } else {
            this.createQueryReport(args);
        }
        return this.getReport();
    }

    public abstract void createQueryReport(String[] var1) throws Exception;

    protected void append(char c) {
        this.report.append(c);
    }

    protected void append(int number) {
        this.report.append(number);
    }

    protected void appendAlignRight(int number, int fieldWidth) {
        String value = Integer.toString(number);
        int pad = fieldWidth - value.length();
        for (int i = 0; i < pad; ++i) {
            this.report.append(' ');
        }
        this.report.append(value);
    }

    protected void appendln(char c) {
        this.report.append(c);
        this.report.append(EOL);
    }

    protected void appendln(int number) {
        this.report.append(number);
        this.report.append(EOL);
    }

    protected void append(Object message) {
        this.report.append(message);
    }

    protected void appendln(Object message) {
        this.report.append(message);
        this.report.append(EOL);
    }

    protected void appendln() {
        this.report.append(EOL);
    }

    protected void indent() {
        this.report.append(INDENT);
    }

    protected void indent(int count) {
        for (int i = 0; i < count; ++i) {
            this.indent();
        }
    }

    protected void appendSpaces(int numberOfSpaces) {
        for (int i = 0; i < numberOfSpaces; ++i) {
            this.report.append(' ');
        }
    }

    protected void appendAndPadTo(String message, int padLength) {
        this.appendAndPadTo(message, padLength, ' ');
    }

    protected void appendAndPadTo(String message, int padLength, char padChar) {
        this.append(message);
        int padCount = padLength - message.length();
        for (int i = 0; i < padCount; ++i) {
            this.report.append(padChar);
        }
    }

    protected void appendNumberedList(Collection c) {
        int line = 1;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            this.indentLineNumber(line++);
            this.appendln(iterator.next());
        }
    }

    protected void appendNumberedList(Object[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.indentLineNumber(i + 1);
            this.appendln(list[i]);
        }
    }

    protected void indentLineNumber(int lineNumber) {
        this.indent();
        this.appendLineNumber(lineNumber);
    }

    protected void appendLineNumber(int lineNumber) {
        if (lineNumber < 10) {
            this.report.append(' ');
        }
        this.report.append(lineNumber);
        this.report.append(". ");
    }

    protected List sort(Collection c) {
        ArrayList result = c instanceof List ? (ArrayList)c : new ArrayList(c);
        Collections.sort(result);
        return result;
    }

    protected static String getDisplayPath(SharedCodeSource cs) {
        return ClassLoadEnvironment.getDisplayPath(cs.getLocation().getPath());
    }

    protected void appendDisplayPath(SharedCodeSource cs) {
        this.append(ReportQuery.getDisplayPath(cs));
    }

    protected void appendDisplayPath(String path) {
        this.append(ClassLoadEnvironment.getDisplayPath(path));
    }

    protected StringBuffer getReportBuffer() {
        return this.report;
    }

    protected String getReport() {
        return this.report.toString();
    }

    protected void appendWrapped(Object prefix, int messageStartColumn, int messageWrapColumn, Object message) {
        int charCount;
        int charsPerLine = messageWrapColumn - messageStartColumn;
        if (charsPerLine <= 0) {
            throw new IllegalArgumentException();
        }
        String prefixText = prefix.toString();
        int startColumn = prefixText.length();
        String text = message.toString();
        int charLength = text.length();
        char[] chars = new char[charLength];
        text.getChars(0, charLength, chars, 0);
        this.report.append(prefix);
        for (int startChar = 0; startChar < charLength; startChar += charCount) {
            for (int i = startColumn; i < messageStartColumn; ++i) {
                this.report.append(' ');
            }
            boolean wrap = false;
            charCount = charLength - startChar;
            if (charCount > charsPerLine) {
                int position = charCount = charsPerLine;
                while (position-- > 16) {
                    if (!Character.isWhitespace(chars[startChar + position])) continue;
                    charCount = position;
                    wrap = true;
                    break;
                }
                if (!wrap) {
                    for (int i = charCount; i < charCount + 16; ++i) {
                        if (!Character.isWhitespace(chars[startChar + i])) continue;
                        charCount = i;
                        wrap = true;
                        break;
                    }
                }
            }
            for (int i = 0; i < charCount; ++i) {
                if (chars[startChar + i] != '\n') continue;
                charCount = i;
                wrap = true;
                break;
            }
            this.report.append(chars, startChar, charCount);
            if (wrap) {
                this.report.append(EOL);
                ++charCount;
            }
            startColumn = 0;
        }
    }
}

