/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;

public class Packages
extends ClassLoaderQuery {
    private SharedCodeSource codeSource;
    private PolicyClassLoader loader;
    private List codeSources;

    public String getDescription() {
        return "List the package names contained within the specified code-source(s).\n\nArgs: [loaderName | codeSourcePath]\n\nIf no argument is specified, searches all available code-sources. If a loader name is specified, only code-sources within that loader are searched.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        Map map = Packages.getPackages(this.codeSources);
        String[] keys = Packages.getSortedKeys(map);
        boolean singleCodeSource = false;
        if (this.codeSource == null) {
            this.appendln("Code-sources searched:\n");
            this.appendNumberedList(this.codeSources);
            this.appendln();
            boolean bl = singleCodeSource = this.codeSources.size() == 1;
        }
        if (this.codeSource != null) {
            this.append("Packages found in code-source '");
            this.append(this.codeSource.getLocation().getPath());
            this.appendln("':");
            singleCodeSource = true;
        } else if (this.loader != null) {
            this.append("Packages found in loader '");
            this.append(this.loader.getDisplayName());
            this.appendln("':");
        } else {
            this.appendln("Packages found in all available code-sources:");
        }
        this.appendln();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            this.indent();
            this.append(key);
            if (!singleCodeSource) {
                int[] indices = (int[])map.get(key);
                int count = indices.length;
                if (count == 1) {
                    this.append(" (code-source: ");
                } else {
                    this.append(" (code-sources: ");
                }
                boolean first = true;
                for (int j = 0; j < indices.length; ++j) {
                    if (!first) {
                        this.append(", ");
                    }
                    first = false;
                    this.append(indices[j] + 1);
                }
                this.append(")");
            }
            this.appendln();
        }
    }

    private static String[] getSortedKeys(Map map) {
        Set keys = map.keySet();
        int size = keys.size();
        Object[] result = new String[size];
        keys.toArray(result);
        Arrays.sort(result);
        return result;
    }

    public static Map getPackages(List codeSources) {
        HashMap result = new HashMap();
        int count = codeSources.size();
        for (int i = 0; i < count; ++i) {
            SharedCodeSource cs = (SharedCodeSource)codeSources.get(i);
            try {
                String[] paths = cs.listFilePaths();
                for (int j = 0; j < paths.length; ++j) {
                    int lastSlash;
                    String fileName = paths[j];
                    if (!fileName.endsWith(".class") || (lastSlash = fileName.lastIndexOf("/")) < 0) continue;
                    String packageName = fileName.substring(0, lastSlash);
                    packageName = packageName.replace('/', '.');
                    Packages.addEntry(result, packageName, i);
                }
                continue;
            }
            catch (IOException e) {
                Packages.addEntry(result, "errors", i);
            }
        }
        return result;
    }

    private static void addEntry(Map map, String key, int index) {
        int[] indices = (int[])map.get(key);
        if (indices == null) {
            indices = new int[]{index};
        } else {
            int count = indices.length;
            for (int i = 0; i < count; ++i) {
                if (index != indices[i]) continue;
                return;
            }
            int[] newIndices = new int[count + 1];
            System.arraycopy(indices, 0, newIndices, 0, count);
            newIndices[count] = index;
        }
        map.put(key, indices);
    }

    private void parseArgs(String[] args) {
        int count = args.length;
        if (count == 1) {
            String arg = args[0];
            if (arg.indexOf(47) >= 0 || arg.indexOf(92) >= 0) {
                this.codeSource = Packages.findCodeSource(arg);
                if (this.codeSource == null) {
                    throw new IllegalArgumentException("Code-source not found: " + arg);
                }
            } else {
                this.loader = Packages.findLoader(arg);
                if (this.loader == null) {
                    throw new IllegalArgumentException("Loader not found: " + arg);
                }
            }
        } else if (count > 1) {
            throw new IllegalArgumentException("Only 1 argument allowed.");
        }
        this.initCodeSources();
    }

    private void initCodeSources() {
        if (this.codeSource != null) {
            this.codeSources = new ArrayList();
            this.codeSources.add(this.codeSource);
        } else if (this.loader != null) {
            SharedCodeSource[] sources = this.loader.getCodeSources(true);
            this.codeSources = new ArrayList(sources.length);
            for (int i = 0; i < sources.length; ++i) {
                this.codeSources.add(sources[i]);
            }
        } else {
            this.codeSources = Packages.getAllCodeSources();
        }
    }
}

