/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;

public class ListClasses
extends ClassLoaderQuery {
    private PolicyClassLoader loader;
    private Filter filter;

    public String getDescription() {
        return "List all classes available from a given loader.\n\nArgs: loaderName \n\n";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        Object[] classes = ListClasses.availableClasses(this.loader, this.filter);
        Arrays.sort(classes);
        for (int i = 0; i < classes.length; ++i) {
            this.appendln(classes[i]);
        }
    }

    public static String[] availableClasses(PolicyClassLoader loader, Filter filter) throws Exception {
        HashSet<String> classes = new HashSet<String>();
        SharedCodeSource[] sources = loader.getCodeSources(true);
        for (int i = 0; i < sources.length; ++i) {
            SharedCodeSource source = sources[i];
            String[] resources = source.listFilePaths();
            for (int j = 0; j < resources.length; ++j) {
                String resource = resources[j];
                if (!resource.endsWith(".class")) continue;
                String name = resource.substring(0, resource.length() - ".class".length());
                if (!filter.include(name = name.replace('/', '.'))) continue;
                classes.add(name);
            }
        }
        Object[] result = new String[classes.size()];
        classes.toArray(result);
        Arrays.sort(result);
        return result;
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-internalsOnly")) {
                this.filter = new InternalsOnly();
                continue;
            }
            if (arg.equalsIgnoreCase("-externalsOnly")) {
                this.filter = new ExternalsOnly();
                continue;
            }
            this.loader = ListClasses.findLoader(args[i]);
            if (this.loader != null) continue;
            throw new IllegalArgumentException("Loader \"" + args[i] + "\" not found.");
        }
        if (this.loader == null) {
            throw new IllegalArgumentException("Loader name required");
        }
        if (this.filter == null) {
            this.filter = new AllClasses();
        }
    }

    public static class ExternalsOnly
    implements Filter {
        private Map<String, Class> externals = SearchPolicy.getExternalClasses();

        public boolean include(String className) {
            return this.externals.containsKey(className);
        }
    }

    public static class InternalsOnly
    implements Filter {
        private Map<String, Class> externals = SearchPolicy.getExternalClasses();

        public boolean include(String className) {
            return !this.externals.containsKey(className);
        }
    }

    public static class AllClasses
    implements Filter {
        public boolean include(String className) {
            return true;
        }
    }

    public static interface Filter {
        public boolean include(String var1);
    }
}

