/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.List;
import oracle.classloader.ClosedLoaderReference;
import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.LoaderLeakDetector;

public class LeakedLoaders
extends ReportQuery {
    public String getDescription() {
        return "Control detection of class loader leaks and inspect results." + EOL + EOL + "Args: [activate|list|deactivate]" + EOL + EOL + "Defaults to 'list'.";
    }

    public void createQueryReport(String[] args) throws Exception {
        if (args.length == 0) {
            if (LoaderLeakDetector.isActive()) {
                this.list();
            } else {
                this.appendln("Loader leak detection is not active. Specify 'activate' to enable.");
            }
        } else if (args.length == 1) {
            String cmd = args[0];
            if (cmd.equalsIgnoreCase("activate")) {
                if (LoaderLeakDetector.activate()) {
                    this.appendln("Loader leak detection activated.");
                } else {
                    this.appendln("Loader leak detection was already active.");
                }
            } else if (cmd.equalsIgnoreCase("list")) {
                if (LoaderLeakDetector.isActive()) {
                    this.list();
                } else {
                    this.appendln("Loader leak detection has not been activated. Specify 'activate' to enable.");
                }
            } else if (cmd.equalsIgnoreCase("deactivate")) {
                if (LoaderLeakDetector.deactivate()) {
                    this.appendln("Loader leak detection deactivated.");
                } else {
                    this.appendln("Loader leak detection was not active.");
                }
            } else {
                this.appendln("Unknown argument: " + cmd);
            }
        } else {
            this.appendln("Unexpected arguments.");
        }
    }

    private void list() {
        List<ClosedLoaderReference> leaked = LoaderLeakDetector.getClosedButNotCollected(true);
        if (leaked == null) {
            this.appendln("Loader leak detection must be activated.");
        } else {
            Object[] names = leaked.toArray();
            int count = names.length;
            if (count == 0) {
                this.appendln("No leaked loaders found.");
            } else if (count == 1) {
                this.append("The '");
                this.append(names[0]);
                this.appendln("' appears to have been leaked.");
            } else {
                this.appendln("The following loaders appear to have been leaked:");
                this.appendNumberedList(names);
            }
        }
    }
}

