/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;

public class FindResource
extends ClassLoaderQuery {
    public static final int EQUALS_MATCH = 0;
    public static final int STARTS_WITH_MATCH = 1;
    public static final int ENDS_WITH_MATCH = 2;
    public static final int CONTAINS_MATCH = 3;
    public static final int PACKAGE_MATCH = 4;
    public static final int PATTERN_MATCH = 5;
    private String matchPath;
    private int matchType = 0;
    private String target;

    public String getDescription() {
        return "List the code-sources containing the specified resource.\n\nArgs: resourcePath | className \n\nA leading or trailing '*' can be used for a simple wildcard search, or a leading '~' may be used to indicate that the argument should be treated as a regular expression.\n\nNon-regex arguments containing two or more '.' will be treated as class names and converted to resource path form (e.g. 'a.b.Foo' --> 'a/b/Foo.class'). To search for classes with zero or one, '.' in the name, the resource path form must be used explicitly (e.g. 'Bar.class' to find class 'Bar').";
    }

    public void createQueryReport(String[] args) throws Exception {
        String target = this.parseArgs(args);
        List sources = this.findMatchingCodeSources(target);
        int count = sources.size();
        this.append(target);
        if (count == 0) {
            this.append(" not found.");
        } else {
            if (this.matchType == 0) {
                this.appendln(" found in:");
            } else {
                this.appendln(" found:");
            }
            this.appendln();
            int lineNumber = 1;
            for (Match match : sources) {
                for (int i = 0; i < match.resourceCount; ++i) {
                    PolicyClassLoader[] loaders = match.codeSource.getSubscribers().getSubscribers();
                    PolicyClassLoader loader = loaders.length == 0 ? null : loaders[0];
                    String path = match.resources[i];
                    this.appendLineNumber(lineNumber++);
                    if (this.shouldAppendResource(this.matchType == 0)) {
                        this.appendResourcePath(path, loader, match.codeSource);
                        this.append(" in ");
                    }
                    this.appendCodeSourcePath(match.codeSource, loader);
                    this.append(". ");
                    this.appendLoaders(loaders);
                    this.appendln();
                }
            }
        }
    }

    protected void appendLoaders(PolicyClassLoader[] loaders) {
        boolean first = true;
        if (loaders != null) {
            for (int i = 0; i < loaders.length; ++i) {
                PolicyClassLoader loader = loaders[i];
                if (loader == null) continue;
                if (first) {
                    this.append("Loader ");
                    first = false;
                } else {
                    this.append(", ");
                }
                this.appendLoader(loader);
            }
            if (!first) {
                this.append('.');
            }
        }
    }

    protected void appendLoader(PolicyClassLoader loader) {
        this.append(loader.getDisplayName());
    }

    protected boolean shouldAppendResource(boolean exactMatch) {
        return !exactMatch;
    }

    protected void appendResourcePath(String resourcePath, PolicyClassLoader loader, SharedCodeSource source) {
        this.append(resourcePath);
    }

    protected void appendCodeSourcePath(SharedCodeSource source, PolicyClassLoader loader) {
        this.appendDisplayPath(source);
    }

    public List findMatchingCodeSources(String target) {
        this.parsePath(target);
        List result = FindResource.findMatchingCodeSources(this.matchPath, this.matchType, true);
        if (result.isEmpty()) {
            String search;
            if (!(this.matchPath.endsWith(".class") || this.matchType != 0 && this.matchType != 2)) {
                search = this.matchPath + ".class";
                if (this.matchType == 0 && this.matchPath.indexOf(47) < 0) {
                    search = "/" + search;
                }
                result = FindResource.findMatchingCodeSources(search, 2, true);
            }
            if (result.isEmpty() && (result = FindResource.findMatchingCodeSources(search = this.matchPath.replace('.', '/'), 3, true)).isEmpty()) {
                result = FindResource.findMatchingCodeSources(this.matchPath, 3, true);
            }
        }
        return result;
    }

    public static List findMatchingCodeSources(String resourcePath, int matchType, boolean listAllMatching) {
        ArrayList result = new ArrayList();
        List codeSources = FindResource.getAllCodeSources();
        Pattern pattern = null;
        if (matchType == 5) {
            pattern = Pattern.compile(resourcePath);
        }
        for (SharedCodeSource cs : codeSources) {
            try {
                FindResource.checkCodeSource(cs, resourcePath, pattern, matchType, listAllMatching, result);
            }
            catch (IOException e) {}
        }
        return result;
    }

    private static void checkCodeSource(SharedCodeSource cs, String path, Pattern pattern, int matchType, boolean listMatches, List results) throws IOException {
        if (matchType == 0) {
            if (cs.containsResource(path)) {
                results.add(new Match(cs, path));
            }
        } else {
            Match match = new Match(cs);
            String[] resources = cs.list();
            for (int i = 0; i < resources.length; ++i) {
                String resource = resources[i];
                switch (matchType) {
                    case 1: {
                        if (!resource.startsWith(path)) break;
                        match.add(resource, results);
                        break;
                    }
                    case 2: {
                        if (!resource.endsWith(path)) break;
                        match.add(resource, results);
                        break;
                    }
                    case 3: {
                        if (resource.indexOf(path) < 0) break;
                        match.add(resource, results);
                        break;
                    }
                    case 4: {
                        if (!resource.endsWith(".class") || !resource.startsWith(path)) break;
                        match.add(resource, results);
                        break;
                    }
                    case 5: {
                        if (!pattern.matcher(resource).matches()) break;
                        match.add(resource, results);
                        break;
                    }
                }
                if (match.resourceCount != 0 && !listMatches) break;
            }
        }
    }

    private String parseArgs(String[] args) {
        String result = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                throw new IllegalArgumentException("Unknown argument: " + arg);
            }
            if (result != null) {
                throw new IllegalArgumentException("Only one resourcePath or className can be specified.");
            }
            result = arg;
        }
        if (result == null) {
            throw new IllegalArgumentException("resourcePath or className required.");
        }
        return result;
    }

    public void parsePath(String path) {
        this.target = path;
        if (path.startsWith("~")) {
            this.matchPath = path.substring(1);
            this.matchType = 5;
        } else if (path.startsWith("*")) {
            if ((path = path.substring(1)).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
                this.matchType = 3;
            } else {
                this.matchType = 2;
            }
            this.matchPath = FindResource.convertIfClass(path);
        } else if (path.endsWith("*")) {
            if ((path = path.substring(0, path.length() - 1)).indexOf(46) > 0) {
                this.matchPath = path.replace('.', '/');
                this.matchType = 4;
            } else {
                this.matchPath = FindResource.removeLeadingSlash(path);
                this.matchType = 1;
            }
        } else if (path.indexOf(47) < 0) {
            this.matchPath = FindResource.convertIfClass(path);
            this.matchType = 0;
        } else {
            this.matchPath = FindResource.removeLeadingSlash(path);
            this.matchType = 0;
        }
    }

    public String getTargetPath() {
        return this.target;
    }

    public String getMatchPath() {
        return this.matchPath;
    }

    public int getMatchType() {
        return this.matchType;
    }

    private static String convertIfClass(String path) {
        int dot;
        if (path.indexOf(47) < 0 && !path.endsWith(".class") && (dot = path.indexOf(46)) >= 0 && (dot = path.indexOf(46, dot + 1)) > 0) {
            path = path.replace('.', '/') + ".class";
        }
        return path;
    }

    private static String removeLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static class Match {
        public SharedCodeSource codeSource;
        public int resourceCount;
        public String[] resources;

        Match(SharedCodeSource cs, String path) {
            this.codeSource = cs;
            this.resourceCount = 1;
            this.resources = new String[]{path};
        }

        Match(SharedCodeSource cs) {
            this.codeSource = cs;
        }

        void add(String path, List addSelfIfFirstPath) {
            if (this.resourceCount == 0) {
                addSelfIfFirstPath.add(this);
            }
            this.resources = (String[])ArrayUtils.append(String.class, this.resources, this.resourceCount++, path);
        }
    }
}

