/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;

public class ClassPath
extends ClassLoaderQuery {
    private PolicyClassLoader root;
    protected boolean list;

    public String getDescription() {
        return "List the code-sources in use.\n\nArgs: [-list] [loaderName]\n\nUse the -list option to get a line-separated, numbered list. A loader name can be specified from which to compute the classpath; if not specified, it defaults to the main loader.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        if (this.list) {
            int lineNumber = 1;
            this.appendln("Class path:");
            this.appendln();
            List list = ClassPath.getClassPathAsList(this.root, true);
            for (String path : list) {
                this.indentLineNumber(lineNumber++);
                this.appendCodeSource(path);
                this.appendln();
            }
            this.appendln();
        } else {
            ClassPath.appendClassPath(this.root, true, true, this.getReportBuffer());
        }
    }

    protected void appendCodeSource(String codeSourcePath) {
        this.append(codeSourcePath);
    }

    protected void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-list")) {
                this.list = true;
                continue;
            }
            this.root = ClassPath.findLoader(arg);
            if (this.root != null) continue;
            throw new IllegalArgumentException("Loader \"" + arg + "\" not found.");
        }
        if (this.root == null) {
            this.root = ClassPath.getMainLoader();
        }
    }
}

