/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import oracle.classloader.SharedCodeSourceSet;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.URLHandlerFactory;
import oracle.classloader.util.URLParseUtil;

public class SharedCodeSourceURL
extends URLStreamHandler {
    public static final String PROTOCOL = "code-source";
    public static final String JAR_PROTOCOL = "jar";
    public static final String FILE_PROTOCOL = "file:";
    public static final SharedCodeSourceURL HANDLER = new SharedCodeSourceURL();
    private static boolean registered;
    private static boolean triedRegistration;

    public static void register() throws IOException {
        if (!triedRegistration) {
            triedRegistration = true;
            try {
                URLHandlerFactory.register(PROTOCOL, HANDLER);
                new URL("code-source:/foo");
                registered = true;
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public static URL create(URL codeSourceURL, String relativePath) {
        try {
            if (!triedRegistration && ClassLoadEnvironment.autoInstallURLHandlerFactory()) {
                SharedCodeSourceURL.register();
            }
            String canonicalPath = codeSourceURL.getPath();
            StringBuilder buffer = new StringBuilder(canonicalPath.length() + relativePath.length() + 1);
            buffer.append(canonicalPath);
            buffer.append('!');
            if (!relativePath.startsWith("/")) {
                buffer.append('/');
            }
            buffer.append(URLParseUtil.encodePath(relativePath));
            if (registered) {
                return new URL(PROTOCOL, null, 0, buffer.toString(), HANDLER);
            }
            buffer.insert(0, FILE_PROTOCOL);
            return new URL(JAR_PROTOCOL, null, 0, buffer.toString());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equals(PROTOCOL)) {
            return HANDLER;
        }
        return null;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        return new Connection(u);
    }

    static class Connection
    extends URLConnection {
        public Connection(URL theURL) {
            super(theURL);
        }

        public void connect() {
        }

        public String getContentType() {
            String file = this.url.getPath();
            int lastSlash = file.lastIndexOf(47);
            if (lastSlash > 0 && lastSlash + 1 < file.length()) {
                file = file.substring(lastSlash + 1);
            }
            return Connection.getFileNameMap().getContentTypeFor(file);
        }

        public int getContentLength() {
            return (int)SharedCodeSourceSet.getResourceLength(this.url);
        }

        public long getLastModified() {
            return SharedCodeSourceSet.getLastModifiedTime(this.url);
        }

        public InputStream getInputStream() throws IOException {
            return SharedCodeSourceSet.getResourceStream(this.url);
        }
    }
}

