/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.InterceptorSearchSequence;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.PropertyUtils;

public class SearchPolicyToLogClassesLoadedByMainLoader
extends InterceptorSearchSequence {
    private String logFileLocation;
    private PolicyClassLoader mainClassLoader;
    private static String WRITE_LIST_OF_EXTERNAL_CLASSES_KEY = "record.external.classes";
    private static Map classesLoadedByMainLoaderinAppLoader = new HashMap();
    private String DEFAULT_LOG_FILE_FOR_STATS = "classesloadedbymainloader.log";
    private static String DEFAULT_EXTERNAL_CLASSS_LIST_FILE_NAME = "record-externalclasses.txt";
    private static boolean finishedRecordingExternalClasses = false;
    private static FileWriter logStatsFileWriter;
    public static final String LOG_FILE_NAME_LOGGING_CLASSES_FROM_MAIN_KEY = "log.file.name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchPolicyToLogClassesLoadedByMainLoader(String policyName, SearchPolicy[] policies) {
        super(policyName, policies);
        try {
            this.setClassLoaderLogsFileLocation();
            SearchPolicyToLogClassesLoadedByMainLoader searchPolicyToLogClassesLoadedByMainLoader = this;
            synchronized (searchPolicyToLogClassesLoadedByMainLoader) {
                if (this.logFileLocation != null && logStatsFileWriter == null) {
                    File logFile = new File(this.logFileLocation);
                    if (logFile.exists()) {
                        logFile.delete();
                    }
                    logStatsFileWriter = new FileWriter(this.logFileLocation);
                }
            }
        }
        catch (Exception ex) {
            ClassLoadLogger.logException("Failed to initialize with exception : ", ex, false);
        }
        this.setMainClassLoader();
        if (!finishedRecordingExternalClasses) {
            SearchPolicyToLogClassesLoadedByMainLoader.writeExternalClassesToFile();
        }
    }

    private static boolean doWriteListOfExternalClasses() {
        return PropertyUtils.getBooleanProperty(WRITE_LIST_OF_EXTERNAL_CLASSES_KEY, false);
    }

    public static Map getMapForClassesLoadedByMain() {
        return classesLoadedByMainLoaderinAppLoader;
    }

    private void setMainClassLoader() {
        this.mainClassLoader = ClassLoaderQuery.getMainLoader();
    }

    private PolicyClassLoader getMainClassLoader() {
        return this.mainClassLoader;
    }

    protected Class exitGetClass(Class cl, String className, PolicyClassLoader loader, boolean fromChild) {
        if (cl != null && cl.getClassLoader() == this.getMainClassLoader() && !SearchPolicyToLogClassesLoadedByMainLoader.getExternalClasses().containsKey(className)) {
            String loaderName = loader.getName();
            if (!SearchPolicyToLogClassesLoadedByMainLoader.getMapForClassesLoadedByMain().containsKey(className)) {
                SearchPolicyToLogClassesLoadedByMainLoader.getMapForClassesLoadedByMain().put(className, loaderName);
                SearchPolicyToLogClassesLoadedByMainLoader.logToStatsFile("Classname=" + className + "\n" + ",invoking loader=" + loader);
                SearchPolicyToLogClassesLoadedByMainLoader.logToStatsFile("--------------------------- Printing stack ------------------------ ");
                StackTraceElement[] elems = new Error().getStackTrace();
                if (elems != null) {
                    for (int i = 0; i < elems.length; ++i) {
                        SearchPolicyToLogClassesLoadedByMainLoader.logToStatsFile(elems[i].toString());
                    }
                }
            }
        }
        return cl;
    }

    protected void setClassLoaderLogsFileLocation() {
        this.logFileLocation = PropertyUtils.getProperty(LOG_FILE_NAME_LOGGING_CLASSES_FROM_MAIN_KEY, this.DEFAULT_LOG_FILE_FOR_STATS);
    }

    protected String getClassLoaderLogsFileLocation() {
        return this.logFileLocation;
    }

    public static FileWriter getLogStatsWriter() {
        return logStatsFileWriter;
    }

    public static synchronized void logToStatsFile(String message) {
        try {
            if (logStatsFileWriter != null) {
                logStatsFileWriter.write(message + "\n");
                logStatsFileWriter.flush();
            }
        }
        catch (Exception ex) {
            ClassLoadLogger.logException("Failed to write to stats file with exception : ", ex, false);
            try {
                if (logStatsFileWriter != null) {
                    logStatsFileWriter.close();
                }
            }
            catch (Exception closeex) {
                ClassLoadLogger.logException("Failed to close stats file with exception : ", closeex, false);
            }
        }
    }

    private static synchronized void writeExternalClassesToFile() {
        if (SearchPolicyToLogClassesLoadedByMainLoader.doWriteListOfExternalClasses()) {
            if (SearchPolicyToLogClassesLoadedByMainLoader.getExternalClasses() != null) {
                try {
                    File externalClassesFile = new File(DEFAULT_EXTERNAL_CLASSS_LIST_FILE_NAME);
                    if (externalClassesFile.exists()) {
                        externalClassesFile.delete();
                    }
                    FileWriter externalfileWriter = new FileWriter(DEFAULT_EXTERNAL_CLASSS_LIST_FILE_NAME, true);
                    if (SearchPolicyToLogClassesLoadedByMainLoader.getExternalClasses() != null) {
                        TreeMap<String, Class> map = new TreeMap<String, Class>(SearchPolicyToLogClassesLoadedByMainLoader.getExternalClasses());
                        for (Map.Entry<String, Class> pairs : map.entrySet()) {
                            externalfileWriter.write(pairs.getKey() + "\n");
                            externalfileWriter.flush();
                        }
                        externalfileWriter.close();
                    }
                }
                catch (Exception ex) {
                    ClassLoadLogger.logException("Failed to write external classes list with exception : ", ex, false);
                }
            }
            finishedRecordingExternalClasses = true;
        }
    }
}

