/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import oracle.classloader.CodeSourceAccessor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadLogger;

public class ResourceAccessor
extends CodeSourceAccessor {
    private final String path;
    private final boolean includeManifestSources;
    private SharedCodeSource codeSource;

    ResourceAccessor(String resourcePath, boolean includeManifestSources) {
        super(includeManifestSources);
        this.path = resourcePath;
        this.includeManifestSources = includeManifestSources;
    }

    SharedCodeSource getCodeSource() {
        return this.codeSource;
    }

    protected void setCodeSource(SharedCodeSource source) {
        this.codeSource = source;
    }

    public String getResourcePath() {
        return this.path;
    }

    public File getFile() {
        if (this.codeSource != null) {
            try {
                return this.codeSource.getFile(this.path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean visit(PolicyClassLoader loader) {
        return loader.visitCodeSources(this, this.includeManifestSources);
    }

    public boolean visit(SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        try {
            if (codeSource.containsResource(this.path)) {
                this.setCodeSource(codeSource);
                return false;
            }
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Unable to access code-source: " + codeSource + ".", e, false);
        }
        return true;
    }
}

