/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;

public class Resource {
    private String resourcePath;
    private SharedCodeSource codeSource;
    private PolicyClassLoader loader;

    public Resource(String resourcePath, SharedCodeSource codeSource, PolicyClassLoader loader) {
        this.resourcePath = resourcePath;
        this.codeSource = codeSource;
        this.loader = loader;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public SharedCodeSource getCodeSource() {
        return this.codeSource;
    }

    public PolicyClassLoader getLoader() {
        return this.loader;
    }

    public URL createURL() {
        return this.codeSource.createURL(this.resourcePath);
    }

    public InputStream getInputStream() throws IOException {
        return this.codeSource.getStream(this.resourcePath);
    }

    public String toString() {
        return this.resourcePath + ", from " + this.codeSource.getLocation().getPath() + " in " + this.loader.getDisplayName();
    }
}

