/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SharedCodeSource;

public class RecoverableByteBuffer {
    private static int READ_BUFFER_SIZE = 1024;
    private static int READ_BUFFER_GROWTH_THRESHOLD = 128;
    private static int READ_BUFFER_GROWTH_FACTOR = 2;
    private static int MAX_IDLE_TICKS = 3;
    private static byte[] MINIMUM_BUFFER = new byte[0];
    private byte[] buffer;
    private int bytesUsed;
    private Certificate[] certificates;
    private SharedCodeSource codeSource;
    private ProtectionPolicy policy;
    private int lastReadTick = 0;

    public RecoverableByteBuffer(int requiredSize) {
        this.reset(requiredSize);
    }

    public byte[] getArray() {
        return this.buffer;
    }

    public SharedCodeSource getCodeSource() {
        return this.codeSource;
    }

    public ProtectionPolicy getProtectionPolicy() {
        return this.policy;
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public int getBytesUsed() {
        return this.bytesUsed;
    }

    public void reset(int requiredSize) {
        if (this.buffer == null || requiredSize > this.buffer.length) {
            this.buffer = new byte[requiredSize];
        }
        this.bytesUsed = 0;
        this.certificates = null;
        this.policy = null;
        this.codeSource = null;
    }

    public void resize(int newSize) {
        if (newSize == this.buffer.length) {
            return;
        }
        if (newSize < this.buffer.length) {
            this.bytesUsed = newSize;
        }
        byte[] newArray = new byte[newSize];
        System.arraycopy(this.buffer, 0, newArray, 0, this.bytesUsed);
        this.buffer = newArray;
    }

    public void trim() {
        this.resize(this.bytesUsed);
    }

    public void recover(int currentMaintenanceTick, boolean force) {
        int idleTicks;
        if (!force && (idleTicks = currentMaintenanceTick - this.lastReadTick) >= MAX_IDLE_TICKS) {
            force = true;
        }
        if (force) {
            this.buffer = MINIMUM_BUFFER;
            this.bytesUsed = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SharedCodeSource codeSource, int currentMaintenanceTick, InputStream in, int length) throws IOException {
        try {
            if (length > 0) {
                this.reset(length);
                while (length > 0) {
                    int readSize = in.read(this.buffer, this.bytesUsed, length);
                    if (readSize == -1) {
                        throw new IOException("Unexpected EOF");
                    }
                    length -= readSize;
                    this.bytesUsed += readSize;
                }
            } else {
                int readSize;
                this.reset(READ_BUFFER_SIZE);
                while ((readSize = in.read(this.buffer, this.bytesUsed, this.buffer.length - this.bytesUsed)) != -1) {
                    this.bytesUsed += readSize;
                    if (this.buffer.length - this.bytesUsed >= READ_BUFFER_GROWTH_THRESHOLD) continue;
                    this.resize(this.buffer.length * READ_BUFFER_GROWTH_FACTOR);
                }
            }
            this.codeSource = codeSource;
        }
        finally {
            in.close();
            this.lastReadTick = currentMaintenanceTick;
        }
    }

    public void setCodeSource(SharedCodeSource codeSource) {
        this.codeSource = codeSource;
    }

    public void setProtectionPolicy(ProtectionPolicy policy) {
        this.policy = policy;
    }

    public void setCertificates(Certificate[] certificates) {
        this.certificates = certificates;
    }
}

