/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.util.Enumeration;
import oracle.classloader.ClassLoaderPrincipal;
import oracle.classloader.ClassLoaderScope;

public class ProtectionPolicy {
    private static final Permissions emptyPermissions = new Permissions();
    public static final ProtectionPolicy NO_PERMISSIONS = new ProtectionPolicy(null, null, false);
    public static final ProtectionPolicy ALL_PERMISSIONS;
    public static final ProtectionPolicy MAIN_PERMISSIONS;
    public static final ProtectionPolicy ROOT_PERMISSIONS;
    public static final ProtectionPolicy JRE_EXTENSION_PERMISSIONS;
    public static final ProtectionPolicy EXTENSION_PERMISSIONS;
    private final PermissionCollection permissions;
    private final Principal[] principals;

    public static ProtectionPolicy defaultFor(ClassLoaderScope scope) {
        if (scope.isRoot()) {
            return ROOT_PERMISSIONS;
        }
        if (scope == ClassLoaderScope.MAIN) {
            return MAIN_PERMISSIONS;
        }
        return NO_PERMISSIONS;
    }

    protected static ProtectionPolicy protection(Principal principal) {
        return new ProtectionPolicy(null, new Principal[]{principal});
    }

    public static ProtectionPolicy sharedLibraryPolicy(String sharedLibraryName) {
        ClassLoaderPrincipal.SharedLibrary principal = new ClassLoaderPrincipal.SharedLibrary(sharedLibraryName);
        return ProtectionPolicy.protection(principal);
    }

    public ProtectionPolicy(PermissionCollection permissions, Principal[] principals) {
        this(permissions, principals, true);
    }

    protected ProtectionPolicy(PermissionCollection permissions, Principal[] principals, boolean enableCloning) {
        this.permissions = permissions == null ? (enableCloning ? ProtectionPolicy.clone(emptyPermissions) : emptyPermissions) : (enableCloning ? ProtectionPolicy.clone(permissions) : permissions);
        this.principals = principals;
    }

    static boolean needCloning(PermissionCollection permissions) {
        return permissions == emptyPermissions || permissions == ROOT_PERMISSIONS.getPermissions() || permissions == MAIN_PERMISSIONS.getPermissions();
    }

    static PermissionCollection clone(PermissionCollection permissions) {
        if (!ProtectionPolicy.needCloning(permissions)) {
            return permissions;
        }
        Permissions newPermissions = new Permissions();
        Enumeration<Permission> en = permissions.elements();
        while (en.hasMoreElements()) {
            ((PermissionCollection)newPermissions).add(en.nextElement());
        }
        return newPermissions;
    }

    public PermissionCollection getPermissions() {
        return this.permissions;
    }

    public Principal[] getPrincipals() {
        return this.principals;
    }

    static {
        AllPermission all = new AllPermission();
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(all);
        ALL_PERMISSIONS = new ProtectionPolicy(permissions, null, false);
        MAIN_PERMISSIONS = ProtectionPolicy.protection(new ClassLoaderPrincipal.MAIN("main"));
        ROOT_PERMISSIONS = ALL_PERMISSIONS;
        JRE_EXTENSION_PERMISSIONS = ProtectionPolicy.protection(new ClassLoaderPrincipal.MAIN("jre_extension"));
        EXTENSION_PERMISSIONS = ProtectionPolicy.protection(new ClassLoaderPrincipal.MAIN("main_extension"));
    }
}

