/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.classloader.ClassLoaderFilter;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.LoaderReference;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadAsserts;
import oracle.classloader.util.LoaderLeakDetector;
import oracle.classloader.util.VersionNumber;

public class PolicyClassLoaderSet {
    private static Map loaders = new HashMap();
    private static List systemSharedLoaders = new ArrayList();

    static synchronized List getAllLoaders(ClassLoaderFilter filter) {
        LoaderReference.expungeStaleReferences();
        ArrayList result = new ArrayList();
        for (LoaderList list : loaders.values()) {
            list.addAll(filter, result);
        }
        return result;
    }

    static synchronized PolicyClassLoader find(String name, VersionNumber minVersion, VersionNumber maxVersion) {
        PolicyClassLoader result = null;
        LoaderReference.expungeStaleReferences();
        LoaderList list = (LoaderList)loaders.get(name);
        if (list != null) {
            return list.find(minVersion, maxVersion);
        }
        return result;
    }

    static synchronized PolicyClassLoader[] findAll(String name) {
        LoaderReference.expungeStaleReferences();
        LoaderList list = (LoaderList)loaders.get(name);
        if (list != null) {
            return list.list();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyClassLoader[] getSystemSharedLoaders() {
        List list = systemSharedLoaders;
        synchronized (list) {
            return (PolicyClassLoader[])ArrayUtils.toArray(PolicyClassLoader.class, systemSharedLoaders, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(PolicyClassLoader loader) {
        String name = loader.getName();
        LoaderReference ref = new LoaderReference(name, loader);
        LoaderList list = (LoaderList)loaders.get(name);
        if (list == null) {
            loaders.put(name, new LoaderList(ref, loader.getConfigurationPolicy()));
        } else {
            list.insert(ref, loader);
        }
        PolicyClassLoader parent = loader.parent();
        if (parent != null) {
            parent.addChildReference(ref);
        }
        if (loader.isSystemSharedLoader()) {
            List list2 = systemSharedLoaders;
            synchronized (list2) {
                systemSharedLoaders.add(loader);
            }
        }
    }

    static synchronized void remove(PolicyClassLoader loader, boolean removeFromParent) {
        LoaderReference ref;
        LoaderList list = (LoaderList)loaders.get(loader.getName());
        if (list != null && (ref = list.findReference(loader)) != null) {
            PolicyClassLoaderSet.remove(ref, list, removeFromParent);
        }
    }

    static void remove(LoaderReference ref, LoaderList list, boolean removeFromParent) {
        PolicyClassLoader parent;
        String name = ref.getLoaderName();
        if (list == null) {
            list = (LoaderList)loaders.get(name);
        }
        if (list != null && list.remove(ref)) {
            loaders.remove(name);
        }
        if (removeFromParent && (parent = ref.getParent()) != null) {
            parent.removeChildReference(ref);
        }
    }

    public static void doPeriodicMaintenance(int currentMaintenanceTick) {
        LoaderLeakDetector.doPeriodicMaintenance(currentMaintenanceTick);
        if (currentMaintenanceTick % 2 == 0) {
            List list = PolicyClassLoaderSet.getAllLoaders(null);
            for (PolicyClassLoader loader : list) {
                loader.recover(currentMaintenanceTick, false);
            }
        }
    }

    private static class LoaderList {
        private ConfigurationPolicy policy;
        private int count;
        private LoaderReference[] list;

        public LoaderList(LoaderReference ref, ConfigurationPolicy policy) {
            this.policy = policy;
            this.list = new LoaderReference[4];
            this.list[0] = ref;
            this.count = 1;
        }

        public PolicyClassLoader[] list() {
            Object[] result = new PolicyClassLoader[this.count];
            int index = 0;
            for (int i = 0; i < this.count; ++i) {
                PolicyClassLoader loader;
                LoaderReference ref = this.list[i];
                if (ref == null || (loader = ref.getLoader()) == null) continue;
                result[index++] = loader;
            }
            if (index != this.count) {
                result = (PolicyClassLoader[])ArrayUtils.copyAndCompress(result, index);
            }
            return result;
        }

        public PolicyClassLoader find(VersionNumber minVersion, VersionNumber maxVersion) {
            for (int i = 0; i < this.count; ++i) {
                VersionNumber version;
                PolicyClassLoader loader;
                LoaderReference ref = this.list[i];
                if (ref == null || (loader = ref.getLoader()) == null || !(version = loader.getVersionNumber()).inRange(minVersion, maxVersion)) continue;
                return loader;
            }
            return null;
        }

        public LoaderReference findReference(PolicyClassLoader loader) {
            for (int i = 0; i < this.count; ++i) {
                LoaderReference ref = this.list[i];
                if (ref.getLoader() != loader) continue;
                return ref;
            }
            return null;
        }

        public void insert(LoaderReference ref, PolicyClassLoader loader) {
            this.policy.assertDuplicateAllowed(loader);
            int insertIndex = this.count;
            VersionNumber version = loader.getVersionNumber();
            for (int i = 0; i < this.count; ++i) {
                PolicyClassLoader slotLoader = this.list[i].getLoader();
                if (slotLoader == null) continue;
                VersionNumber slotVersion = slotLoader.getVersionNumber();
                int order = version.compare(slotVersion);
                if (order == 0) {
                    ClassLoadAsserts.fail("loader.already.exists", ref.getLoaderUniqueName(), loader.getOrigin(), slotLoader.getOrigin());
                    continue;
                }
                if (order <= 0) continue;
                insertIndex = i;
                break;
            }
            this.list = (LoaderReference[])ArrayUtils.insert(LoaderReference.class, this.list, this.count++, ref, insertIndex);
        }

        public boolean remove(LoaderReference ref) {
            this.count = ArrayUtils.remove((Object[])this.list, this.count, ref);
            return this.count == 0;
        }

        public void addAll(ClassLoaderFilter filter, List list) {
            for (int i = 0; i < this.count; ++i) {
                PolicyClassLoader loader = this.list[i].getLoader();
                if (loader == null || filter != null && !filter.match(loader)) continue;
                list.add(loader);
            }
        }
    }
}

