/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.PolicyClassLoaderSet;

public class LoaderReference
extends WeakReference {
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private String name;
    private String uniqueName;
    private boolean shared;
    private PolicyClassLoader parent;

    LoaderReference(String uniqueName, PolicyClassLoader loader) {
        super(loader, referenceQueue);
        this.name = loader.getName();
        this.uniqueName = uniqueName;
        this.shared = loader.isSharedLoader();
        this.parent = loader.parent();
    }

    PolicyClassLoader getLoader() {
        return (PolicyClassLoader)this.get();
    }

    String getLoaderName() {
        return this.name;
    }

    String getLoaderUniqueName() {
        return this.uniqueName;
    }

    boolean isShared() {
        return this.shared;
    }

    PolicyClassLoader getParent() {
        return this.parent;
    }

    static void expungeStaleReferences() {
        Reference ref;
        while ((ref = referenceQueue.poll()) != null) {
            PolicyClassLoaderSet.remove((LoaderReference)ref, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lockAndExpungeStaleReferences() {
        Class<PolicyClassLoaderSet> clazz = PolicyClassLoaderSet.class;
        synchronized (PolicyClassLoaderSet.class) {
            LoaderReference.expungeStaleReferences();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

