/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.EventDispatcher;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.ExtensionDependency;
import oracle.classloader.ExtensionDependencyNotSatisfiedError;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.LocalizedText;

public class ExtensionDependencyQuery
implements ClassLoaderVisitor,
CodeSourceVisitor {
    private PolicyClassLoader initialLoader;
    private ExtensionDependency dependency;
    private int candidateCount;
    private ExtensionDeclaration[] candidates;
    private int[] candidateCompatibility;
    private PolicyClassLoader autoImport;
    private PolicyClassLoader existingImport;
    private PolicyClassLoader nonUniqueAutoImport;
    private int firstMatchIndex;
    private PolicyClassLoader firstLoader;
    private int secondMatchIndex;
    private PolicyClassLoader secondLoader;
    private boolean checkedFirstCodeSource;
    public static final int COMPATIBLE = 0;
    public static final int MATCHING_EXTENSION_NAME_NOT_FOUND = 1;
    public static final int SPECIFICATION_VERSION_REQUIRED = 2;
    public static final int IMPLEMENTATION_VENDOR_ID_REQUIRED = 3;
    public static final int IMPLEMENTATION_VERSION_REQUIRED = 4;
    public static final int INVALID_SPECIFICATION_VERSION = 5;
    public static final int SPECIFICATION_UPGRADE_REQUIRED = 6;
    public static final int VENDOR_SWITCH_REQUIRED = 7;
    public static final int INVALID_IMPLEMENTATION_VERSION = 8;
    public static final int IMPLEMENTATION_UPGRADE_REQUIRED = 9;
    public static final int MATCHING_EXTENSION_NOT_REACHABLE = 10;
    public static final int NON_MATCHING_EXTENSION_NOT_REACHABLE = 11;
    public static final int MATCHING_EXTENSION_NOT_REACHABLE_LOADER_SEARCH_ORDER = 12;
    public static final int MATCHING_EXTENSION_NOT_REACHABLE_CODE_SOURCE_ORDER = 13;
    public static final int MATCHING_EXTENSION_NOT_REACHABLE_EXISTING_IMPORT = 14;
    public static final int MATCHING_EXTENSION_NOT_REACHABLE_IMPORT = 15;
    private static final String[] MESSAGE_KEYS = new String[]{"compatible", "extension.not.found", "extension.spec-version.missing", "extension.vendor-id.missing", "extension.impl-version.missing", "extension.invalid.spec-version", "extension.specification.upgrade", "extension.vendor.switch", "extension.invalid.impl-version", "extension.implementation.upgrade", "extension.not.reachable", "extension.not.reachable.non.matching", "extension.not.reachable.loader.order", "extension.not.reachable.source.order", "extension.not.reachable.existing.import", "extension.not.reachable.import"};

    public static String getCompatibilityString(int compatibility) {
        return MESSAGE_KEYS[compatibility];
    }

    public ExtensionDependencyQuery(PolicyClassLoader initialLoader, ExtensionDependency dependency, boolean failIfNotSatisfied) {
        this.initialLoader = initialLoader;
        this.dependency = dependency;
        this.firstMatchIndex = -1;
        this.secondMatchIndex = -1;
        int result = this.findCompatibleExtension();
        if (result == 0) {
            EventDispatcher.codeSourceExtensionDependencySatisfied(dependency, this.candidates[this.firstMatchIndex], this.autoImport);
        } else {
            EventDispatcher.codeSourceExtensionDependencyNotSatisfied(dependency, result);
            ExtensionDependencyNotSatisfiedError error = new ExtensionDependencyNotSatisfiedError(this);
            if (failIfNotSatisfied) {
                throw error;
            }
            ClassLoadLogger.log(Level.WARNING, error.getMessage());
        }
    }

    public int getCompatibility() {
        if (this.firstMatchIndex < 0) {
            return 1;
        }
        return this.candidateCompatibility[this.firstMatchIndex];
    }

    public ExtensionDeclaration getResolvedBy() {
        if (this.firstMatchIndex >= 0) {
            return this.candidates[this.firstMatchIndex];
        }
        return null;
    }

    private int findCompatibleExtension() {
        this.candidates = ExtensionDeclaration.find(this.dependency.getExtensionName());
        if (this.candidates != null) {
            this.candidateCount = ArrayUtils.countNonNull(this.candidates, this.candidates.length);
            if (this.candidateCount > 0) {
                boolean foundCompatible = this.getCandidateCompatibility();
                ClassLoaderQuery.visitLoadersInSearchOrder(this.initialLoader, this);
                if (this.getCompatibility() == 0) {
                    return 0;
                }
                if (foundCompatible) {
                    if (!this.canUseSharedLibrary()) {
                        this.useFirstCompatibleCandidate();
                    }
                } else {
                    this.useFirstCompatibleCandidate();
                }
            }
        }
        return this.getCompatibility();
    }

    private boolean getCandidateCompatibility() {
        boolean foundCompatible = false;
        this.candidateCompatibility = new int[this.candidateCount];
        for (int i = 0; i < this.candidateCount; ++i) {
            ExtensionDeclaration candidate = this.candidates[i];
            if (candidate != null) {
                int compatibility;
                this.candidateCompatibility[i] = compatibility = this.dependency.getCompatibilityWith(candidate);
                if (compatibility != 0) continue;
                foundCompatible = true;
                continue;
            }
            this.candidateCompatibility[i] = -1;
        }
        return foundCompatible;
    }

    private boolean canUseSharedLibrary() {
        for (int i = 0; i < this.candidateCount; ++i) {
            PolicyClassLoader shared;
            if (this.candidateCompatibility[i] != 0 || (shared = this.getSubscribedSharedLoader(i)) == null) continue;
            boolean uniqueImport = this.isUniqueImport(shared);
            if (this.firstMatchIndex < 0 && uniqueImport) {
                this.candidateCompatibility[i] = 0;
                this.autoImport = shared;
                String originStr = this.candidates[i].toString();
                ConfigurationOrigin origin = new ConfigurationOrigin(ConfigurationType.AUTO_IMPORTED_LOADER, originStr);
                this.initialLoader.importLoader(shared, origin);
            } else if (uniqueImport) {
                this.candidateCompatibility[i] = 15;
                this.nonUniqueAutoImport = shared;
                this.secondMatchIndex = this.firstMatchIndex;
                this.secondLoader = this.firstLoader;
            } else {
                this.candidateCompatibility[i] = 14;
            }
            this.firstMatchIndex = i;
            return true;
        }
        return false;
    }

    private PolicyClassLoader getSubscribedSharedLoader(int index) {
        SubscriberSet set = this.candidates[index].getCodeSource().getSubscribers();
        PolicyClassLoader[] subs = set.getSubscribers();
        for (int i = 0; i < subs.length; ++i) {
            PolicyClassLoader loader = subs[i];
            if (subs == null || !loader.isSharedLoader()) continue;
            return loader;
        }
        return null;
    }

    private boolean isUniqueImport(PolicyClassLoader candidate) {
        String candidateName = candidate.getName();
        PolicyClassLoader[] imports = this.initialLoader.getImports();
        if (imports != null) {
            for (int i = 0; i < imports.length; ++i) {
                String existingName = imports[i].getName();
                if (!existingName.equals(candidateName)) continue;
                this.nonUniqueAutoImport = candidate;
                this.existingImport = imports[i];
                return false;
            }
        }
        return true;
    }

    private void useFirstCompatibleCandidate() {
        if (this.firstMatchIndex < 0) {
            int index = -1;
            int compat = 11;
            for (int i = 0; i < this.candidateCount; ++i) {
                ExtensionDeclaration candidate = this.candidates[i];
                if (candidate == null) continue;
                if (this.candidateCompatibility[i] == 0) {
                    index = i;
                    compat = 10;
                    break;
                }
                if (index >= 0) continue;
                index = i;
            }
            this.firstMatchIndex = index;
            this.firstLoader = this.candidates[index].getCodeSource().getSubscribers().getFirstSubscriber();
            this.candidateCompatibility[index] = compat;
        }
    }

    public boolean visit(PolicyClassLoader loader) {
        for (int i = 0; i < this.candidateCount; ++i) {
            SharedCodeSource source;
            ExtensionDeclaration candidate = this.candidates[i];
            if (candidate == null || !(source = candidate.getCodeSource()).getSubscribers().containsSubscriber(loader)) continue;
            if (this.firstMatchIndex < 0) {
                this.firstMatchIndex = i;
                this.firstLoader = loader;
                continue;
            }
            this.secondMatchIndex = i;
            this.secondLoader = loader;
            if (this.firstLoader == this.secondLoader) {
                this.resolveSameLoaderOrder();
            } else {
                this.resolveDifferentLoadersOrder();
            }
            return false;
        }
        return this.firstMatchIndex < 0 || this.candidateCompatibility[this.firstMatchIndex] != 0;
    }

    private void resolveDifferentLoadersOrder() {
        if (this.candidateCompatibility[this.secondMatchIndex] == 0) {
            this.candidateCompatibility[this.firstMatchIndex] = 12;
        }
    }

    private void resolveSameLoaderOrder() {
        this.firstLoader.visitCodeSources(this, true);
        if (this.candidateCompatibility[this.firstMatchIndex] != 0 && this.candidateCompatibility[this.secondMatchIndex] == 0) {
            this.candidateCompatibility[this.firstMatchIndex] = 13;
        }
    }

    public boolean visit(SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        for (int i = 0; i < this.candidateCount; ++i) {
            ExtensionDeclaration candidate = this.candidates[i];
            if (candidate == null || codeSource != candidate.getCodeSource()) continue;
            if (!this.checkedFirstCodeSource) {
                this.checkedFirstCodeSource = true;
                this.firstMatchIndex = i;
                continue;
            }
            this.secondMatchIndex = i;
            return false;
        }
        return true;
    }

    public String getNotSatisfiedMessage() {
        StringBuffer buffer = new StringBuffer(4096);
        LocalizedText text = ClassLoadLogger.getText();
        String dep = this.dependency.toString(false);
        String loaderName = this.initialLoader.getDisplayName();
        SharedCodeSource source = this.dependency.getCodeSource();
        String cs = source.getLocation().getPath();
        String origin = ClassLoaderQuery.getFirstOrigin(source, this.initialLoader).toString();
        String msg = text.getText("extension.not.satisfied", dep, loaderName, cs, origin);
        buffer.append(msg);
        int compatibility = this.getCompatibility();
        String key = ExtensionDependencyQuery.getCompatibilityString(compatibility);
        msg = text.getText(key);
        buffer.append(msg);
        switch (compatibility) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.appendExtensionDescription(true, text, buffer);
                break;
            }
            case 10: 
            case 11: {
                if (System.getSecurityManager() == null) {
                    buffer.append(text.getText("extension.not.reachable.non.secure"));
                    this.appendLoaderAndCodeSourceDescription(true, text, buffer);
                    break;
                }
                buffer.append(text.getText("extension.not.reachable.secure"));
                break;
            }
            case 12: {
                this.appendLoaderOrderDescription(text, buffer);
                break;
            }
            case 13: {
                this.appendCodeSourceOrderDescription(text, buffer);
                break;
            }
            case 14: {
                this.appendExistingImportDescription(text, buffer);
                break;
            }
            case 15: {
                this.appendImportDescription(text, buffer);
                break;
            }
        }
        String url = this.dependency.getImplementationURL();
        if (url != null) {
            buffer.append(text.getText("extension.url", url));
        }
        msg = buffer.toString();
        return msg;
    }

    private void appendLoaderAndCodeSourceDescription(boolean first, LocalizedText text, StringBuffer buffer) {
        int index = first ? this.firstMatchIndex : this.secondMatchIndex;
        PolicyClassLoader loader = first ? this.firstLoader : this.secondLoader;
        String loaderName = loader != null ? loader.getDisplayName() : "n/a";
        SharedCodeSource source = this.candidates[index].getCodeSource();
        String cs = source.getLocation().getPath();
        String origin = this.getOrigin(loader, source);
        String msg = text.getText("loader.code.source.description", loaderName, cs, origin);
        buffer.append(msg);
    }

    private String getOrigin(PolicyClassLoader loader, SharedCodeSource source) {
        SubscriberSet set = source.getSubscribers();
        String result = "unknown";
        if (loader != null) {
            result = set.getFirstOriginFor(loader).toString();
        }
        return result;
    }

    private void appendExtensionDescription(boolean first, LocalizedText text, StringBuffer buffer) {
        int index = first ? this.firstMatchIndex : this.secondMatchIndex;
        PolicyClassLoader loader = first ? this.firstLoader : this.secondLoader;
        String dep = this.candidates[index].toString(false);
        String loaderName = loader != null ? loader.getDisplayName() : "n/a";
        SharedCodeSource source = this.candidates[index].getCodeSource();
        String cs = source.getLocation().getPath();
        String origin = this.getOrigin(loader, source);
        String msg = text.getText("extension.description", dep, loaderName, cs, origin);
        buffer.append(msg);
    }

    private void appendLoaderOrderDescription(LocalizedText text, StringBuffer buffer) {
        this.appendLoaderAndCodeSourceDescription(true, text, buffer);
        buffer.append(text.getText("masked.extension"));
        this.appendLoaderAndCodeSourceDescription(false, text, buffer);
    }

    private void appendCodeSourceDescription(boolean first, LocalizedText text, StringBuffer buffer) {
        int index = first ? this.firstMatchIndex : this.secondMatchIndex;
        PolicyClassLoader loader = first ? this.firstLoader : this.secondLoader;
        SharedCodeSource source = this.candidates[index].getCodeSource();
        String cs = source.getLocation().getPath();
        String origin = ClassLoaderQuery.getFirstOrigin(source, loader).toString();
        String msg = text.getText("code.source.description", cs, origin);
        buffer.append(msg);
    }

    private void appendCodeSourceOrderDescription(LocalizedText text, StringBuffer buffer) {
        this.appendCodeSourceDescription(true, text, buffer);
        buffer.append(text.getText("masked.extension"));
        this.appendCodeSourceDescription(false, text, buffer);
    }

    private void appendExistingImportDescription(LocalizedText text, StringBuffer buffer) {
        String candidate = this.nonUniqueAutoImport.getDisplayName();
        String existing = this.existingImport.getDisplayName();
        buffer.append(text.getText("existing.import", candidate, existing));
    }

    private void appendImportDescription(LocalizedText text, StringBuffer buffer) {
        String candidate = this.nonUniqueAutoImport.getDisplayName();
        buffer.append(text.getText("existing.code.source", candidate));
        this.appendExtensionDescription(false, text, buffer);
    }
}

