/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.net.URL;
import java.util.List;
import java.util.jar.Manifest;
import oracle.classloader.ClassSearchListener;
import oracle.classloader.CodeSourceListener;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.LoaderLifeCycleListener;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ResourceSearchListener;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;

public class EventDispatcher {
    private static volatile int loaderListenersCount;
    private static Object loaderListenersLock;
    private static LoaderLifeCycleListener[] loaderListeners;
    private static volatile int codeSourceListenersCount;
    private static Object codeSourceListenersLock;
    private static CodeSourceListener[] codeSourceListeners;
    private static volatile int classSearchListenersCount;
    private static Object classSearchListenersLock;
    private static ClassSearchListener[] classSearchListeners;
    private static volatile int resourceSearchListenersCount;
    private static Object resourceSearchListenersLock;
    private static ResourceSearchListener[] resourceSearchListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeListenersLoadedBy(PolicyClassLoader loader) {
        Object object = loaderListenersLock;
        synchronized (object) {
            loaderListenersCount = EventDispatcher.remove(loader, loaderListenersCount, loaderListeners);
        }
        object = codeSourceListenersLock;
        synchronized (object) {
            codeSourceListenersCount = EventDispatcher.remove(loader, codeSourceListenersCount, codeSourceListeners);
        }
        object = classSearchListenersLock;
        synchronized (object) {
            classSearchListenersCount = EventDispatcher.remove(loader, classSearchListenersCount, classSearchListeners);
        }
        object = classSearchListenersLock;
        synchronized (object) {
            resourceSearchListenersCount = EventDispatcher.remove(loader, resourceSearchListenersCount, classSearchListeners);
        }
    }

    private static int remove(PolicyClassLoader loader, int count, Object[] array) {
        int resultCount = count;
        if (array == null) {
            return resultCount;
        }
        for (int i = count - 1; i >= 0; --i) {
            ClassLoader target = array[i].getClass().getClassLoader();
            if (loader != target) continue;
            resultCount = ArrayUtils.remove(array, resultCount, i);
        }
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(LoaderLifeCycleListener listener) {
        Object object = loaderListenersLock;
        synchronized (object) {
            loaderListeners = (LoaderLifeCycleListener[])ArrayUtils.append(LoaderLifeCycleListener.class, loaderListeners, loaderListenersCount, listener);
            ++loaderListenersCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(LoaderLifeCycleListener listener) {
        Object object = loaderListenersLock;
        synchronized (object) {
            loaderListenersCount = ArrayUtils.remove((Object[])loaderListeners, loaderListenersCount, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(CodeSourceListener listener) {
        Object object = codeSourceListenersLock;
        synchronized (object) {
            codeSourceListeners = (CodeSourceListener[])ArrayUtils.append(CodeSourceListener.class, codeSourceListeners, codeSourceListenersCount, listener);
            ++codeSourceListenersCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(CodeSourceListener listener) {
        Object object = codeSourceListenersLock;
        synchronized (object) {
            codeSourceListenersCount = ArrayUtils.remove((Object[])codeSourceListeners, codeSourceListenersCount, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ClassSearchListener listener) {
        Object object = classSearchListenersLock;
        synchronized (object) {
            classSearchListeners = (ClassSearchListener[])ArrayUtils.append(ClassSearchListener.class, classSearchListeners, classSearchListenersCount, listener);
            ++classSearchListenersCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ClassSearchListener listener) {
        Object object = classSearchListenersLock;
        synchronized (object) {
            classSearchListenersCount = ArrayUtils.remove((Object[])classSearchListeners, classSearchListenersCount, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ResourceSearchListener listener) {
        Object object = resourceSearchListenersLock;
        synchronized (object) {
            resourceSearchListeners = (ResourceSearchListener[])ArrayUtils.append(ResourceSearchListener.class, resourceSearchListeners, resourceSearchListenersCount, listener);
            ++resourceSearchListenersCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ResourceSearchListener listener) {
        Object object = resourceSearchListenersLock;
        synchronized (object) {
            resourceSearchListenersCount = ArrayUtils.remove((Object[])resourceSearchListeners, resourceSearchListenersCount, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loaderCreated(PolicyClassLoader loader) {
        if (loaderListenersCount > 0) {
            Object object = loaderListenersLock;
            synchronized (object) {
                for (int i = 0; i < loaderListenersCount; ++i) {
                    loaderListeners[i].loaderCreated(loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loaderCommitted(PolicyClassLoader loader) {
        if (loaderListenersCount > 0) {
            Object object = loaderListenersLock;
            synchronized (object) {
                for (int i = 0; i < loaderListenersCount; ++i) {
                    loaderListeners[i].loaderCommitted(loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loaderClosing(PolicyClassLoader loader) {
        if (loaderListenersCount > 0) {
            Object object = loaderListenersLock;
            synchronized (object) {
                for (int i = 0; i < loaderListenersCount; ++i) {
                    loaderListeners[i].loaderClosing(loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loaderDestroyed(PolicyClassLoader loader) {
        if (loaderListenersCount > 0) {
            Object object = loaderListenersLock;
            synchronized (object) {
                for (int i = 0; i < loaderListenersCount; ++i) {
                    loaderListeners[i].loaderDestroyed(loader);
                }
                EventDispatcher.removeListenersLoadedBy(loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loaderCollected(String loaderName, String loaderIdentityHashCode) {
        if (loaderListenersCount > 0) {
            Object object = loaderListenersLock;
            synchronized (object) {
                for (int i = 0; i < loaderListenersCount; ++i) {
                    loaderListeners[i].loaderCollected(loaderName, loaderIdentityHashCode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceCreated(SharedCodeSource codeSource, ConfigurationOrigin origin) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceCreated(codeSource, origin);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceStateChanged(SharedCodeSource codeSource, int newState) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceStateChanged(codeSource, newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceExtensionDependencySatisfied(ExtensionDeclaration dependency, ExtensionDeclaration satisfiedBy, PolicyClassLoader importedLoader) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceExtensionDependencySatisfied(dependency, satisfiedBy, importedLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceExtensionDependencyNotSatisfied(ExtensionDeclaration dependency, int reason) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceExtensionDependencyNotSatisfied(dependency, reason);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceManifestProcessed(SharedCodeSource codeSource, Manifest manifest) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceManifestProcessed(codeSource, manifest);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeSourceDestroyed(URL codeSourceLocation) {
        if (codeSourceListenersCount > 0) {
            Object object = codeSourceListenersLock;
            synchronized (object) {
                for (int i = 0; i < codeSourceListenersCount; ++i) {
                    codeSourceListeners[i].codeSourceDestroyed(codeSourceLocation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classDefine(String className, int classSize, PolicyClassLoader loader, SharedCodeSource codeSource, boolean processed) {
        if (classSearchListenersCount > 0) {
            Object object = classSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < classSearchListenersCount; ++i) {
                    classSearchListeners[i].classDefine(className, classSize, loader, codeSource, processed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classFound(Class theClass, PolicyClassLoader loader) {
        if (classSearchListenersCount > 0) {
            Object object = classSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < classSearchListenersCount; ++i) {
                    classSearchListeners[i].classFound(theClass, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classFoundTrusted(Class theClass, PolicyClassLoader loader) {
        if (classSearchListenersCount > 0) {
            Object object = classSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < classSearchListenersCount; ++i) {
                    classSearchListeners[i].classFoundTrusted(theClass, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classNotFound(String className, PolicyClassLoader loader) {
        if (classSearchListenersCount > 0) {
            Object object = classSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < classSearchListenersCount; ++i) {
                    classSearchListeners[i].classNotFound(className, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classError(String className, PolicyClassLoader loader, Throwable error) {
        if (classSearchListenersCount > 0) {
            Object object = classSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < classSearchListenersCount; ++i) {
                    classSearchListeners[i].classError(className, loader, error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resourceFound(URL resource, PolicyClassLoader loader) {
        if (resourceSearchListenersCount > 0) {
            Object object = resourceSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < resourceSearchListenersCount; ++i) {
                    resourceSearchListeners[i].resourceFound(resource, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resourceFoundTrusted(URL resource, PolicyClassLoader loader) {
        if (resourceSearchListenersCount > 0) {
            Object object = resourceSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < resourceSearchListenersCount; ++i) {
                    resourceSearchListeners[i].resourceFoundTrusted(resource, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resourcesFound(List resources, PolicyClassLoader loader) {
        if (resourceSearchListenersCount > 0) {
            Object object = resourceSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < resourceSearchListenersCount; ++i) {
                    resourceSearchListeners[i].resourcesFound(resources, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resourcesFoundTrusted(List resources, PolicyClassLoader loader) {
        if (resourceSearchListenersCount > 0) {
            Object object = resourceSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < resourceSearchListenersCount; ++i) {
                    resourceSearchListeners[i].resourcesFoundTrusted(resources, loader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resourceNotFound(String resourcePath, PolicyClassLoader loader) {
        if (resourceSearchListenersCount > 0) {
            Object object = resourceSearchListenersLock;
            synchronized (object) {
                for (int i = 0; i < resourceSearchListenersCount; ++i) {
                    resourceSearchListeners[i].resourceNotFound(resourcePath, loader);
                }
            }
        }
    }

    static {
        loaderListenersLock = new Object();
        codeSourceListenersLock = new Object();
        classSearchListenersLock = new Object();
        resourceSearchListenersLock = new Object();
    }
}

