/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.CodeSourceSearchPolicy;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.PolicyClassLoaderSet;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceList;
import oracle.classloader.util.ClassLoadAsserts;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public class ConfigurationPolicy {
    public static final int SYSTEM = 0;
    public static final int SYSTEM_SHARED = 1;
    public static final int APPLICATION_SHARED = 2;
    public static final int APPLICATION = 3;
    public static final int TEST = 4;
    public static final int FILE_EQUALITY_NAME_ONLY = 0;
    public static final int FILE_EQUALITY_FULL_PATH = 1;
    public static final int FILE_EQUALITY_NAME_AND_SIZES = 2;
    public static final int FILE_EQUALITY_NAME_AND_ENTRIES = 3;
    public static final int FILE_EQUALITY_NAME_AND_BITWISE = 4;
    public static final int FILE_EQUALITY_NEVER = 5;
    public static final int NON_SHARED = 0;
    public static final int SHARED_PUBLIC = 1;
    public static final int SHARED_PRIVATE = 2;
    public static final ConfigurationPolicy JRE_BOOT = new ConfigurationPolicy(ConfigurationType.JRE_BOOT, 0, false, 1, true, 0);
    public static final ConfigurationPolicy JRE_EXTENSION = new ConfigurationPolicy(ConfigurationType.JRE_EXTENSION, 0, false, 1, true, 0);
    public static final ConfigurationPolicy API = new ConfigurationPolicy(ConfigurationType.API, 0, false, 1, true, 0);
    public static final ConfigurationPolicy SHARED_BOOT_PUBLIC = new ConfigurationPolicy(ConfigurationType.SHARED_BOOT, 1, false, 1, true, 1);
    public static final ConfigurationPolicy SHARED_BOOT_PRIVATE = new ConfigurationPolicy(ConfigurationType.SHARED_BOOT, 2, false, 1, true, 1);
    public static final ConfigurationPolicy SHARED = new ConfigurationPolicy(ConfigurationType.SHARED, 1, false, 1, true, 2);
    public static final ConfigurationPolicy MAIN = new ConfigurationPolicy(ConfigurationType.MAIN, 0, false, 1, true, 0);
    public static final ConfigurationPolicy MAIN_MATCH_FILE_NAMES = new ConfigurationPolicy(ConfigurationType.MAIN, 0, false, 0, true, 0);
    public static final ConfigurationPolicy RAW = new ConfigurationPolicy(ConfigurationType.NO_CODE_SOURCES, 0, false, 0, true, 0);
    private static final String[] CATEGORY_NAMES = new String[]{"system", "system-shared", "application-shared", "application", "test"};
    private static final boolean ANNOTATE_MISSING_CLASS_ERRORS = ClassLoadEnvironment.annotateMissingClassErrors();
    private static boolean autoCommitBootLoaders = false;
    private ConfigurationType[] types;
    private ClassLoaderScope scope;
    private int sharingPolicy;
    private boolean inheritImports;
    private int defaultEqualityPolicy;
    private boolean autoCommit;
    private int category;
    private boolean inheritImportsFromCommiitedOnly;

    public static void setAutoCommitBootLoaders(boolean autoCommit) {
        autoCommitBootLoaders = autoCommit;
    }

    public SharedCodeSourceList.Index createIndex() {
        return CodeSourceSearchPolicy.DEFAULT.createIndex();
    }

    public ConfigurationPolicy(ConfigurationType[] types, int sharingPolicy, boolean inheritImports, int defaultEqualityPolicy, boolean autoCommit, int category) {
        this(types, sharingPolicy, inheritImports, defaultEqualityPolicy, autoCommit, category, true);
    }

    public ConfigurationPolicy(ConfigurationType[] types, int sharingPolicy, boolean inheritImports, int defaultEqualityPolicy, boolean autoCommit, int category, boolean inheritImportsFromCommiitedOnly) {
        this.types = types;
        this.sharingPolicy = sharingPolicy;
        this.inheritImports = inheritImports;
        this.defaultEqualityPolicy = defaultEqualityPolicy;
        this.autoCommit = autoCommit;
        this.category = category;
        this.inheritImportsFromCommiitedOnly = inheritImportsFromCommiitedOnly;
        int count = types.length;
        if (count == 0) {
            this.scope = ClassLoaderScope.MAIN;
        } else {
            this.scope = types[0].getScope();
            for (int i = 0; i < count; ++i) {
                ConfigurationType type = types[i];
                int id = type.getID();
                for (int j = 0; j < types.length; ++j) {
                    if (j == i || types[j].getID() != id) continue;
                    throw new IllegalArgumentException("All configuration types in the same policy must be unique. Found '" + this.scope + "' and '" + type.getScope() + "'.");
                }
                if (i <= 0 || this.scope.equals(type.getScope())) continue;
                throw new IllegalArgumentException("All configuration types in the same policy must have the same scope! Found '" + this.scope + "' and '" + type.getScope() + "'.");
            }
        }
    }

    public void assertAccepted(String loaderName, ConfigurationOrigin loaderOrigin, ConfigurationOrigin origin) {
        int id = origin.getType().getID();
        for (int i = 0; i < this.types.length; ++i) {
            if (id != this.types[i].getID()) continue;
            return;
        }
        ClassLoadAsserts.fail("loader.invalid.config", loaderName, loaderOrigin, origin);
    }

    public boolean isShared() {
        return this.sharingPolicy != 0;
    }

    public boolean isSharedPublic() {
        return this.sharingPolicy == 1;
    }

    public boolean isApplicationScope() {
        return this.scope.isApplication();
    }

    public boolean shouldInheritImports() {
        return this.inheritImports;
    }

    public boolean shouldAnnotateMissingClass(String missingClassName) {
        return ANNOTATE_MISSING_CLASS_ERRORS;
    }

    public void assertDuplicateAllowed(PolicyClassLoader loader) {
        if (this.scope.compareTo(loader.getScope()) != 0) {
            ClassLoadAsserts.fail("loader.wrong.scope", loader.getUniqueName(), loader.getOrigin(), this.getScope(), loader.getScope());
        }
    }

    public ProtectionPolicy getProtection(PolicyClassLoader loader, SharedCodeSource source, ProtectionPolicy protection) {
        ProtectionPolicy result = protection;
        if (result == null) {
            result = loader.getProtection();
        }
        return result;
    }

    public int getFileEqualityPolicyFor(File canonicalFile, SharedCodeSource existing, PolicyClassLoader subscriber) {
        return ClassLoadEnvironment.getFileEqualityPolicyFor(canonicalFile, existing, subscriber, this.defaultEqualityPolicy);
    }

    public ConfigurationType[] getTypes() {
        return (ConfigurationType[])this.types.clone();
    }

    public ClassLoaderScope getScope() {
        return this.scope;
    }

    public int getCategory() {
        return this.category;
    }

    public String getCategoryName() {
        return CATEGORY_NAMES[this.category];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Category: ");
        buffer.append(this.getCategoryName());
        buffer.append(". Scope: ");
        buffer.append(this.scope.toString());
        buffer.append(". Supported configurations: ");
        buffer.append(ClassLoadLogger.EOL);
        for (int i = 0; i < this.types.length; ++i) {
            ConfigurationType type = this.types[i];
            buffer.append("    ");
            buffer.append(i + 1);
            buffer.append(". ");
            buffer.append(type.toString());
            buffer.append(ClassLoadLogger.EOL);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configure(PolicyClassLoader loader, ClassLoader parent, PolicyClassLoader policyParent, ConfigurationOrigin origin) {
        String name = loader.getName();
        ClassLoadAsserts.assertTrue(name.indexOf(58) < 0, "loader.name.invalid", name, origin);
        PolicyClassLoader[] parentImports = null;
        if (policyParent != null && this.shouldInheritImports()) {
            parentImports = this.getParentImports(policyParent, loader, origin);
        }
        Class<PolicyClassLoaderSet> clazz = PolicyClassLoaderSet.class;
        synchronized (PolicyClassLoaderSet.class) {
            this.assertValid(loader, parent, policyParent, origin);
            if (parentImports != null) {
                ConfigurationOrigin importOrigin = new ConfigurationOrigin(ConfigurationType.INHERITED_SHARED_LIBRARIES, "Parent loader: " + policyParent.getUniqueName());
                for (int i = 0; i < parentImports.length; ++i) {
                    loader.importLoader(parentImports[i], importOrigin);
                }
            }
            PolicyClassLoaderSet.add(loader);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    void loaderCommitting(PolicyClassLoader loader) {
        if (loader.isApplicationLoader() && loader.getSearchPolicy() == SearchPolicy.STANDARD) {
            boolean hasImports;
            boolean hasCodeSources = loader.hasCodeSources();
            boolean hasNativeCodeSources = loader.hasNativeCodeSources();
            boolean bl = hasImports = loader.getImportedLoadersCount() > 0;
            if (!(hasCodeSources || hasNativeCodeSources || hasImports)) {
                loader.setSearchPolicy(SearchPolicy.ASK_PARENT, null);
            } else if (!hasImports) {
                loader.setSearchPolicy(SearchPolicy.STANDARD_NO_IMPORTS, null);
            }
        }
    }

    protected void assertValid(PolicyClassLoader loader, ClassLoader parent, PolicyClassLoader policyParent, ConfigurationOrigin origin) {
        if (parent == null) {
            if (!origin.isTest()) {
                ClassLoadAsserts.assertTrue(loader.getName() == ClassLoadEnvironment.getRootLoaderName(), "loader.parent.null", loader.getName(), origin);
            }
        } else if (policyParent != null) {
            int parentLevel = policyParent.getScope().getLevel();
            int loaderLevel = this.getScope().getLevel();
            if (!ClassLoadEnvironment.setMainAsSystemLoader() || policyParent.getName() != ClassLoadEnvironment.getMainLoaderName()) {
                ClassLoadAsserts.assertTrue(loaderLevel >= parentLevel, "loader.parent.lower.scope", loader.getName(), origin, policyParent.getUniqueName());
            }
            boolean parentIsShared = policyParent.isSharedLoader();
            boolean loaderIsShared = loader.isSharedLoader();
            ClassLoadAsserts.assertFalse(parentIsShared && !loaderIsShared, "loader.parent.shared", loader.getName(), origin, policyParent.getUniqueName());
            if (loaderIsShared && !parentIsShared) {
                ClassLoadAsserts.assertTrue(parentLevel <= ClassLoaderScope.GLOBAL.getLevel(), "loader.parent.non.shared", loader.getName(), origin, policyParent.getUniqueName());
            }
        }
        ClassLoadAsserts.assertTrue(origin.getScope() == this.getScope(), "loader.invalid.config", loader.getName(), origin, origin.getScope());
    }

    protected PolicyClassLoader[] getParentImports(PolicyClassLoader parent, PolicyClassLoader child, ConfigurationOrigin childOrigin) {
        if (parent != null) {
            if (this.inheritImportsFromCommiitedOnly) {
                ClassLoadAsserts.assertTrue(parent.isCommitted(), "loader.import.parent.not.committed", child.getUniqueName(), childOrigin, parent.getUniqueName());
            }
            return parent.getImports();
        }
        return null;
    }

    boolean shouldAutoCommit() {
        if (this.scope.isApplication() || this.sharingPolicy != 0) {
            return this.autoCommit;
        }
        return autoCommitBootLoaders;
    }
}

