/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderReference;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.GarbageCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosedLoaderReference
extends WeakReference<PolicyClassLoader> {
    private static ReferenceQueue<PolicyClassLoader> QUEUE = new ReferenceQueue();
    private String name;
    private String identity;
    private StackTraceElement[] creationStack;
    private String parentID;

    public ClosedLoaderReference(PolicyClassLoader loader) {
        super(loader, QUEUE);
        this.name = loader.getUniqueName();
        this.identity = loader.getIdentityHashCode();
        this.creationStack = loader.getCreationStack();
        ClassLoader parent = loader.getParent();
        if (parent == null) {
            this.parentID = "none";
        } else if (parent instanceof PolicyClassLoader) {
            PolicyClassLoader PolicyClassLoader2 = (PolicyClassLoader)parent;
            this.parentID = PolicyClassLoader2.getUniqueName() + " ID #" + PolicyClassLoader2.getIdentityHashCode();
        } else {
            this.parentID = parent.toString();
        }
    }

    public static ClosedLoaderReference poll() {
        LoaderReference.lockAndExpungeStaleReferences();
        ClosedLoaderReference result = (ClosedLoaderReference)QUEUE.poll();
        if (result != null) {
            try {
                EventDispatcher.loaderCollected(result.name, result.identity);
            }
            catch (Throwable t) {
                GarbageCollection.log(Level.WARNING, "ClosedLoaderReference.poll() caught " + t);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        GarbageCollection.log(Level.INFO, this.toString() + "CLEARED!");
    }

    public boolean wasCleared() {
        return this.get() == null;
    }

    public String getName() {
        return this.name;
    }

    public StackTraceElement[] getCreationStack() {
        return this.creationStack;
    }

    public String toString() {
        String state = this.get() == null ? "CLEARED" : "LIVE";
        return this.name + " (ID #" + this.identity + ", parent " + this.parentID + "): " + state;
    }
}

