/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.user;

import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.user.UserExtensionResources;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserExtensionAddin
implements Addin {
    private static final Logger LOGGER = Logger.getLogger(UserExtensionAddin.class.getName());

    public void initialize() {
        String string = Ide.getProductHomeDirectory();
        URL uRL = URLFactory.newDirURL((String)string);
        URL[] uRLArray = URLFileSystem.list((URL)(uRL = URLFactory.newDirURL((URL)uRL, (String)"userextensions")), (URLFilenameFilter)new URLFilenameFilter(){

            public boolean accept(URL uRL, String string) {
                return string.toLowerCase().endsWith(".xml");
            }
        });
        if (uRLArray != null) {
            SAXParser sAXParser = new SAXParser();
            ExtensionsHandler extensionsHandler = new ExtensionsHandler();
            sAXParser.setValidationMode(0);
            sAXParser.setContentHandler((ContentHandler)extensionsHandler);
            sAXParser.setEntityResolver((EntityResolver)extensionsHandler);
            sAXParser.setDTDHandler((DTDHandler)extensionsHandler);
            sAXParser.setErrorHandler((ErrorHandler)extensionsHandler);
            sAXParser.setPreserveWhitespace(false);
            for (URL uRL2 : uRLArray) {
                extensionsHandler.init(uRL2);
                try {
                    sAXParser.parse(URLFileSystem.openInputStream((URL)uRL2));
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, MessageFormat.format(UserExtensionResources.get("ERROR_PARSE_ERROR"), URLFileSystem.getPath((URL)uRL2), exception.getLocalizedMessage()));
                }
            }
        }
    }

    private static final class ExtensionsHandler
    extends DefaultHandler {
        private URL m_url;
        private String m_root;

        private ExtensionsHandler() {
        }

        private void init(URL uRL) {
            this.m_url = uRL;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.m_root == null) {
                this.m_root = string3;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.m_root != null) {
                if ("navigator".equals(this.m_root)) {
                    NavigatorHook.registerURL((URL)this.m_url);
                } else if ("items".equals(this.m_root)) {
                    XMLBasedObjectAction.registerContextMenus((URL)this.m_url);
                } else if ("displays".equals(this.m_root)) {
                    ViewerAddin.registerEditors((String)this.m_url.toString());
                } else {
                    LOGGER.log(Level.INFO, MessageFormat.format(UserExtensionResources.get("ERROR_BAD_ROOT"), this.m_root, URLFileSystem.getPlatformPathName((URL)this.m_url)));
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.m_root = null;
        }
    }
}

