/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.jdao;

import oracle.dbtools.migration.workbench.plugin.jdao.JDaoDatabase;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoObject;

public class JDaoTableDef
extends JDaoObject {
    public static final int dbAttachExclusive = 65536;
    public static final int dbAttachSavePWD = 131072;
    public static final int dbSystemObject = -2147483646;
    public static final int dbAttachedTable = 0x40000000;
    public static final int dbAttachedODBC = 0x20000000;
    public static final int dbHiddenObject = 1;

    private native int _jni_initialize(int var1) throws JDaoException;

    private native int _jni_delete(int var1);

    private native void _jni_open(int var1, String var2) throws JDaoException;

    private native void _jni_close(int var1) throws JDaoException;

    private native String _jni_getName(int var1) throws JDaoException;

    private native String _jni_getConnect(int var1) throws JDaoException;

    private native String _jni_getSourceTableName(int var1) throws JDaoException;

    private native int _jni_getAttributes(int var1) throws JDaoException;

    private native int _jni_getFieldCount(int var1) throws JDaoException;

    private native int _jni_getIndexCount(int var1) throws JDaoException;

    private native String _jni_getFieldName(int var1, int var2) throws JDaoException;

    private native short _jni_getFieldType(int var1, int var2) throws JDaoException;

    private native void _jni_setName(int var1, String var2) throws JDaoException;

    private native void _jni_setConnect(int var1, String var2) throws JDaoException;

    private native void _jni_setSourceTableName(int var1, String var2) throws JDaoException;

    private native void _jni_create(int var1, String var2) throws JDaoException;

    private native void _jni_append(int var1) throws JDaoException;

    public JDaoTableDef(JDaoDatabase jDaoDatabase) throws JDaoException {
        int n = jDaoDatabase.getCObjectID();
        this.cObjectID = this._jni_initialize(n);
    }

    @Override
    public void deinit() {
        if (this.cObjectID != -1) {
            this.println("JDaoTableDef.deinit()");
            this.cObjectID = this._jni_delete(this.cObjectID);
            this.cObjectID = -1;
        }
    }

    public void open(String string) throws JDaoException {
        this._jni_open(this.cObjectID, string);
    }

    public void close() throws JDaoException {
        this._jni_close(this.cObjectID);
    }

    public String getName() throws JDaoException {
        return this._jni_getName(this.cObjectID);
    }

    public int getAttributes() throws JDaoException {
        return this._jni_getAttributes(this.cObjectID);
    }

    public String getConnect() throws JDaoException {
        return this._jni_getConnect(this.cObjectID);
    }

    public String getSourceTableName() throws JDaoException {
        return this._jni_getSourceTableName(this.cObjectID);
    }

    public String getTableTypeStr() throws JDaoException {
        int n = this.getAttributes();
        if ((0x80000002 & n) != 0) {
            return "System Table";
        }
        if ((0x40000000 & n) != 0) {
            return "Attached Table";
        }
        if ((0x20000000 & n) != 0) {
            return "Attached ODBC Table";
        }
        if ((1 & n) != 0) {
            return "Hidden Table";
        }
        return "User Table";
    }

    public int getFieldCount() throws JDaoException {
        return this._jni_getFieldCount(this.cObjectID);
    }

    public String getFieldName(int n) throws JDaoException {
        return this._jni_getFieldName(this.cObjectID, n);
    }

    public short getFieldType(int n) throws JDaoException {
        return this._jni_getFieldType(this.cObjectID, n);
    }

    public int getIndexCount() throws JDaoException {
        return this._jni_getIndexCount(this.cObjectID);
    }

    public void setName(String string) throws JDaoException {
        this._jni_setName(this.cObjectID, string);
    }

    public void setConnect(String string) throws JDaoException {
        this._jni_setConnect(this.cObjectID, string);
    }

    public void setSourceTableName(String string) throws JDaoException {
        this._jni_setSourceTableName(this.cObjectID, string);
    }

    public void create(String string) throws JDaoException {
        this._jni_create(this.cObjectID, string);
    }

    public void append() throws JDaoException {
        this._jni_append(this.cObjectID);
    }
}

