/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.MSAccessController;
import oracle.dbtools.migration.workbench.plugin.MSAccessConverter;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessOfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.MSAccessQuoter;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessThirdPartyProvider;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class MSAccessPlugin
extends AbstractMigrationPlugin {
    public static final String MY_PLATFORM = "ACCESS";
    public static final String MDE_ACCESS_97 = "omwb97";
    public static final String MDE_ACCESS_2000 = "omwb2000";
    public static final String MDE_ACCESS_2002 = "omwb2002";
    public static final String MDE_ACCESS_2003 = "omwb2003";
    public static final String MDE_ACCESS_2007 = "omwb2007";
    public static final String REMOVE_LOCAL_TABLES = "RemoveLocalTables";
    protected Converter m_converter;

    public String getVersionNumber() {
        return "5.0";
    }

    public int getPlatformMask() {
        return 512;
    }

    public String getPluginName() {
        return MY_PLATFORM;
    }

    public String getPlatformName() {
        return "MSAccess";
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MSAccessConverter();
        }
        return this.m_converter;
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        return null;
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        return null;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new MSAccessOfflineCapturer((MigrationStorer)new BasicMigrationStorer(MigrationAddin.getPersistenceManager()));
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        return null;
    }

    public String getPublishedVersion() {
        return null;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(MY_PLATFORM)) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new MSAccessThirdPartyProvider(connection);
    }

    public void initialize() {
        super.initialize();
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            public void mainWindowOpened(IdeEvent ideEvent) {
                MSAccessPlugin.this.addToMigrationMenu();
            }
        });
    }

    protected String getSupportedMapsXMLFileName() {
        return "MSAccessSupportedDataTypesMap.xml";
    }

    private void addToMigrationMenu() {
        MSAccessController mSAccessController = new MSAccessController();
        MigrationMenuManager migrationMenuManager = MigrationAddin.getMigrationMenuManager();
        JMenu jMenu = this.createAccessSubMenu();
        if (jMenu != null) {
            migrationMenuManager.addMenuItem((JMenuItem)jMenu, false, 2);
        }
        JMenuItem jMenuItem = this.createMigrationMenuItem(mSAccessController, "ACTION_CHANGE_MDB", MSAccessMigrationAddinArb.getString("ACCESS_CHANGE_MDB_LABEL"), 109);
    }

    private JMenu createAccessSubMenu() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return null;
        }
        MSAccessController mSAccessController = new MSAccessController();
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)MSAccessMigrationAddinArb.getString("ACCESS_EXPORTER_LABEL")));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)MSAccessMigrationAddinArb.getString("ACCESS_EXPORTER_LABEL")));
        JMenuItem jMenuItem = this.createMigrationMenuItem(mSAccessController, "ACTION_RUN_ACCESS_97", MSAccessMigrationAddinArb.getString("ACCESS_RUN_EXPORTER_97_LABEL"), 109);
        JMenuItem jMenuItem2 = this.createMigrationMenuItem(mSAccessController, "ACTION_RUN_ACCESS_2000", MSAccessMigrationAddinArb.getString("ACCESS_RUN_EXPORTER_2000_LABEL"), 109);
        JMenuItem jMenuItem3 = this.createMigrationMenuItem(mSAccessController, "ACTION_RUN_ACCESS_2002", MSAccessMigrationAddinArb.getString("ACCESS_RUN_EXPORTER_2002_LABEL"), 109);
        JMenuItem jMenuItem4 = this.createMigrationMenuItem(mSAccessController, "ACTION_RUN_ACCESS_2003", MSAccessMigrationAddinArb.getString("ACCESS_RUN_EXPORTER_2003_LABEL"), 109);
        JMenuItem jMenuItem5 = this.createMigrationMenuItem(mSAccessController, "ACTION_RUN_ACCESS_2007", MSAccessMigrationAddinArb.getString("ACCESS_RUN_EXPORTER_2007_LABEL"), 109);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    private JMenuItem createMigrationMenuItem(Controller controller, String string, String string2, int n) {
        int n2 = Ide.findOrCreateCmdID((String)string);
        IdeAction ideAction = IdeAction.get((int)n2, null, (String)StringUtils.stripMnemonic((String)string2), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string2)), null, null, (boolean)true);
        ideAction.addController(controller);
        JMenuItem jMenuItem = new JMenuItem((Action)ideAction);
        return jMenuItem;
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.access");
    }

    public Quoter getQuoter() {
        return new MSAccessQuoter();
    }

    public boolean doIReturnUnloadScripts() {
        return false;
    }

    public boolean getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        return true;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/access/images/microsoftaccess.png";
    }

    public String createDataFileName(String string, String string2) {
        if (string2 != null && string2.startsWith("[") && string2.endsWith("]") && string2.length() > 2) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2 + ".dat";
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        String string3 = mdColumn.getColumnType();
        String string4 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if (string4.equalsIgnoreCase("CHAR") || string4.equalsIgnoreCase("NCHAR") || string4.equalsIgnoreCase("VARCHAR2") || string4.equalsIgnoreCase("NVARCHAR2") || string4.equalsIgnoreCase("CLOB") || string4.equalsIgnoreCase("NCLOB")) {
            if (n2 >= 255) {
                string = "CHAR(" + n2 + ")";
            }
            if (string4.equalsIgnoreCase("CLOB") || string4.equalsIgnoreCase("NCLOB")) {
                string = string + "CHAR(2000000)";
            }
        } else if (string4.equalsIgnoreCase("TIMESTAMP")) {
            string = "\"TO_TIMESTAMP(:" + string2 + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (string3.equalsIgnoreCase("TIME")) {
            string = "\"TO_DATE(:" + string2 + ",  'HH24:mi:ss')\"";
        } else if (string4.equalsIgnoreCase("DATE")) {
            string = "\"TO_DATE(:" + string2 + ",  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        } else if (string3.equalsIgnoreCase("CURRENCY")) {
            string = "\"TRANSLATE (:" + string2 + ",'1, $','1')\"";
        } else if (string4.equalsIgnoreCase("BLOB")) {
            string = "CHAR(10000000)";
        }
        return string;
    }

    public static String getMDEFileForVersion(int n) {
        switch (n) {
            case 8: {
                return MDE_ACCESS_97;
            }
            case 9: {
                return MDE_ACCESS_2000;
            }
            case 10: {
                return MDE_ACCESS_2002;
            }
            case 11: {
                return MDE_ACCESS_2003;
            }
            case 12: {
                return MDE_ACCESS_2007;
            }
        }
        return MDE_ACCESS_2007;
    }

    public static String getModelNameFromMDBFileName(String string) {
        String string2 = new File(string).getName();
        String string3 = string2.substring(0, string2.lastIndexOf("."));
        return string3.concat(" (Access)");
    }

    public String getPlatformNameforNavigator() {
        return "MSAccess";
    }
}

