/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.plugin.MSAccessController;
import oracle.dbtools.util.Resource;

public class AccessExecutor
extends Thread {
    private String m_mdeFile = null;
    private boolean m_standalone;
    private String m_mdbFile;
    private String m_msaccessExe;
    private String m_password;
    private boolean m_includeSchemaInformation;
    private boolean m_includeApplicationInformation;
    private boolean m_includeData;
    private String m_tempDir;
    private String m_fileToMonitor;

    public AccessExecutor(String string) {
        this.m_mdeFile = string;
        this.m_standalone = true;
    }

    public AccessExecutor(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        this.m_msaccessExe = string;
        this.m_mdeFile = string2;
        this.m_standalone = false;
        this.m_mdbFile = string3;
        this.m_password = string4;
        this.m_includeApplicationInformation = bl2;
        this.m_includeSchemaInformation = bl;
        this.m_includeData = bl3;
        this.m_tempDir = Resource.raptorUserTmp.getAbsolutePath();
        if (!this.m_tempDir.endsWith("/") && !this.m_tempDir.endsWith("\\")) {
            this.m_tempDir = this.m_tempDir + System.getProperty("file.separator");
        }
        this.storeFileToMonitor();
    }

    @Override
    public void run() {
        try {
            String string = MSAccessController.writeFile("omwb", true);
            String string2 = MSAccessController.writeFile(this.m_mdeFile, false);
            String[] stringArray = this.generateCommandArray(string2);
            for (String string3 : stringArray) {
                System.out.print(string3 + " ");
            }
            System.out.println();
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(string2.substring(0, string2.lastIndexOf(92))));
            EatMe eatMe = new EatMe(process.getErrorStream());
            eatMe.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (bufferedReader.readLine() != null) {
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private String[] generateCommandArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.m_standalone) {
            arrayList.add("cmd.exe");
            arrayList.add("/C");
            arrayList.add("start");
            arrayList.add(string.substring(string.lastIndexOf(92) + 1));
        } else {
            arrayList.add(this.m_msaccessExe);
            arrayList.add(string);
            arrayList.add("/cmd");
        }
        if (!this.m_standalone) {
            arrayList2.add("/n=" + this.m_mdbFile);
            arrayList2.add("/o=" + this.m_tempDir);
            if (this.m_password == null) {
                arrayList2.add("/p=");
            } else {
                arrayList2.add("/p=" + this.m_password);
            }
            arrayList2.add("/d=" + AccessExecutor.booleanToHilaryVal(this.m_includeSchemaInformation));
            arrayList2.add("/a=" + AccessExecutor.booleanToHilaryVal(this.m_includeApplicationInformation));
            arrayList2.add("/t=" + AccessExecutor.booleanToHilaryVal(this.m_includeData));
            arrayList2.add("/x");
        }
        if (arrayList2.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : arrayList2) {
                stringBuffer.append(string2);
                stringBuffer.append(' ');
            }
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getMonitorFile() {
        return this.m_fileToMonitor;
    }

    private void storeFileToMonitor() {
        String[] stringArray = this.m_mdbFile.split("\\\\");
        String string = stringArray[stringArray.length - 1];
        stringArray = string.split("\\.");
        this.m_fileToMonitor = this.m_tempDir + stringArray[0] + ".XML";
    }

    private static String booleanToHilaryVal(boolean bl) {
        return bl ? "0" : "1";
    }

    static final class EatMe
    extends Thread {
        InputStream m_theInputStream = null;

        public EatMe(InputStream inputStream) {
            this.m_theInputStream = new BufferedInputStream(inputStream);
        }

        @Override
        public void run() {
            try {
                while (this.m_theInputStream.read() != -1) {
                }
                this.m_theInputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }
}

