/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.util.Iterator;
import oracle.ide.persistence.NameSpace;
import oracle.ideimpl.persistence.DefaultNameSpace;
import oracle.ideimpl.persistence.Tests;

class Tools {
    static String location;
    static NameSpace curNS;

    Tools() {
    }

    static void setNameSpace(String s) {
        if (location != null) {
            curNS = NameSpace.getLocalNameSpace(location, s);
            System.out.println("NameSpace " + s + " opened");
        } else {
            System.out.println("Can't get NameSpace " + s + " without storage file set");
        }
    }

    static void deleteNameSpace(String s) {
        if (location != null) {
            NameSpace.deleteLocalNameSpace(location, s);
            System.out.println("NameSpace " + s + " deleted");
        } else {
            System.out.println("Can't delete NameSpace " + s + " without storage file set");
        }
    }

    static void listNameSpaceName(String s, boolean natural) {
        if (location != null) {
            Iterator<String> it = natural ? NameSpace.getLocalNameSpaceIterator(location, s, false) : NameSpace.getLocalReverseNameSpaceIterator(location, s, false);
            System.out.println("NameSpace list (" + s + ")");
            int cnt = 0;
            while (it.hasNext()) {
                System.out.println("  " + it.next());
                ++cnt;
            }
            System.out.println(cnt + " NameSpaces");
        } else {
            System.out.println("Can't list NameSpace without storage file set");
        }
    }

    static void printTree() {
        if (location != null) {
            if (curNS != null) {
                if (curNS instanceof DefaultNameSpace) {
                    ((DefaultNameSpace)curNS).printTree();
                }
            } else {
                System.out.println("Can't dump NameSpace keys without NameSpace set");
            }
        } else {
            System.out.println("Can't dump NameSpace keys without storage file set");
        }
    }

    static void listNameSpace(String s, boolean natural) {
        if (location != null) {
            if (curNS != null) {
                Iterator<String> it = natural ? curNS.getKeyIterator(s) : curNS.getReverseKeyIterator(s);
                System.out.println("NameSpace key list (" + s + ")");
                int cnt = 0;
                while (it.hasNext()) {
                    System.out.println("  " + it.next());
                    ++cnt;
                }
                System.out.println(cnt + " Keys");
            } else {
                System.out.println("Can't list NameSpace keys without NameSpace set");
            }
        } else {
            System.out.println("Can't list NameSpace keys without storage file set");
        }
    }

    static void addKey(String k, String data) {
        if (location != null) {
            if (curNS != null) {
                if (data.equals("")) {
                    curNS.putRecord(k, null);
                } else {
                    curNS.putRecord(k, data.getBytes());
                }
                System.out.println("Added key (" + k + ") = (" + data + ")");
            } else {
                System.out.println("Can't add keys without NameSpace set");
            }
        } else {
            System.out.println("Can't add keys without storage file set");
        }
    }

    static void dumpKey(String k) {
        if (location != null) {
            if (curNS != null) {
                byte[] data = curNS.getRecord(k);
                if (data == null) {
                    System.out.println("Key (" + k + ") not found");
                } else {
                    System.out.print("Dumping key (" + k + ")");
                    for (int i = 0; i < data.length; ++i) {
                        if (i % 32 == 0) {
                            System.out.println();
                        }
                        System.out.print(Integer.toHexString((0xFF & data[i]) + 256).substring(1) + " ");
                    }
                }
            } else {
                System.out.println("Can't add keys without NameSpace set");
            }
        } else {
            System.out.println("Can't add keys without storage file set");
        }
    }

    static void flush() {
        if (location != null) {
            if (curNS != null) {
                curNS.flush();
                System.out.println("NameSpace flushed");
            } else {
                System.out.println("Can't flush without NameSpace set");
            }
        } else {
            System.out.println("Can't flush without storage file set");
        }
    }

    public static void main(String[] args) {
        System.out.println("Persistence system check tool");
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-setfile")) {
                int n = ++i;
                ++i;
                location = args[n];
                continue;
            }
            if (args[i].equalsIgnoreCase("-test")) {
                System.out.println("DUHH !!!");
                int n = ++i;
                int n2 = ++i;
                ++i;
                Tests.test2(args[n], args[n2]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-look")) {
                System.out.println("DUHH !!!");
                int n = ++i;
                int n3 = ++i;
                ++i;
                Tests.look(args[n], args[n3]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-listns")) {
                int n = ++i;
                ++i;
                Tools.listNameSpaceName(args[n], true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-rlistns")) {
                int n = ++i;
                ++i;
                Tools.listNameSpaceName(args[n], false);
                continue;
            }
            if (args[i].equalsIgnoreCase("-list")) {
                int n = ++i;
                ++i;
                Tools.listNameSpace(args[n], true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-rlist")) {
                int n = ++i;
                ++i;
                Tools.listNameSpace(args[n], false);
                continue;
            }
            if (args[i].equalsIgnoreCase("-setns")) {
                int n = ++i;
                ++i;
                Tools.setNameSpace(args[n]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-delns")) {
                int n = ++i;
                ++i;
                Tools.deleteNameSpace(args[n]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-addkey")) {
                int n = ++i;
                int n4 = ++i;
                ++i;
                Tools.addKey(args[n], args[n4]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-dumpkey")) {
                int n = ++i;
                ++i;
                Tools.dumpKey(args[n]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-flush")) {
                ++i;
                Tools.flush();
                continue;
            }
            if (args[i].equalsIgnoreCase("-dumptree")) {
                ++i;
                Tools.printTree();
                continue;
            }
            if (!args[i].equalsIgnoreCase("-?")) {
                System.out.println("Unknown arg : " + args[i]);
            }
            System.out.println("Syntax :");
            System.out.println("  -setfile NAME    : Set storage file");
            System.out.println("  -(r)listNS  NAME : List nameSpaces names in current storage file (use \"\" as name to get all of them");
            System.out.println("  -setNS   NAME    : Set current NameSpace");
            System.out.println("  -delNS   NAME    : Delete NameSpace");
            System.out.println("  -(r)list    NAME : List all keys in current nameSpace (use \"\" as name to get all of them");
            ++i;
        }
    }
}

