/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.ideimpl.persistence.BPageCache;

class Page {
    private static final int ORDER = 128;
    private static final int HALFORDER = 64;
    static boolean _flipflop;
    private Record[] _records = new Record[128];
    private int _count;
    private Page _parent;
    private int _uplink;
    private boolean _dirty = true;

    boolean isDirty() {
        return this._dirty;
    }

    Page() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToBlob(OutputStream stream) throws IOException {
        DataOutputStream os = new DataOutputStream(stream);
        try {
            os.writeInt(this._count);
            os.writeInt(this._uplink);
            for (int i = 0; i < this._count; ++i) {
                Record record = this._records[i];
                os.writeUTF(record.key);
                os.writeInt(record.link);
                os.writeInt(record.dataAddress);
            }
            this._dirty = false;
        }
        finally {
            this.closeIgnoringException(os);
        }
    }

    private void closeIgnoringException(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromBlob(InputStream stream) throws IOException {
        DataInputStream s = new DataInputStream(stream);
        try {
            this._count = s.readInt();
            this._uplink = s.readInt();
            for (int i = 0; i < this._count; ++i) {
                Record record = new Record();
                record.key = s.readUTF();
                record.link = s.readInt();
                record.dataAddress = s.readInt();
                this._records[i] = record;
            }
            this._dirty = false;
        }
        finally {
            this.closeIgnoringException(s);
        }
    }

    void printPage(BPageCache pc, int group, String ident) {
        try {
            ident = ident + "| ";
            System.out.println(ident + "---------" + this._parent + "------------");
            for (int i = 0; i < this._count; ++i) {
                int ii;
                if (this._records[i].link != 0) {
                    pc.getPage(this._records[i].link, group).printPage(pc, group, ident);
                }
                String k = (ii = this._records[i].key.indexOf(124)) != -1 ? this._records[i].key.substring(0, ii) : this._records[i].key;
                System.out.println(ident + i + " " + k);
            }
            if (this._uplink != 0) {
                pc.getPage(this._uplink, group).printPage(pc, group, ident);
            }
            System.out.println(ident + "--------------------------------------");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    String allKeys(BPageCache pc, int group) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._count; ++i) {
            if (this._records[i].link != 0) {
                sb.append(pc.getPage(this._records[i].link, group).allKeys(pc, group));
            }
            sb.append(this._records[i].key);
        }
        if (this._uplink != 0) {
            sb.append(pc.getPage(this._uplink, group).allKeys(pc, group));
        }
        return sb.toString();
    }

    static int findIPointInPage(Page cp, String key) {
        int ipoint;
        for (ipoint = 0; ipoint < cp._count && key.compareTo(cp._records[ipoint].key) > 0; ++ipoint) {
        }
        return ipoint;
    }

    static void splitPage(BPageCache pc, int group, Page p) throws IOException {
        if (p._count < 128) {
            return;
        }
        int npindex = pc.getNewPage(group);
        Page newpage = pc.getPage(npindex, group);
        newpage._uplink = p._uplink;
        for (int i = 0; i < 64; ++i) {
            newpage._records[i] = p._records[64 + i];
            p._records[64 + i] = null;
        }
        newpage._count = 64;
        newpage._dirty = true;
        p._dirty = true;
        p._count = 64;
        p._uplink = npindex;
    }

    static Page findFromPage(BPageCache pc, int group, Page p, String key) throws IOException {
        Page cp = p;
        Page found = null;
        do {
            int ipoint = Page.findIPointInPage(cp, key);
            int lpIndex = 0;
            if (ipoint < cp._count) {
                if (key.compareTo(cp._records[ipoint].key) != 0) {
                    lpIndex = cp._records[ipoint].link;
                }
            } else {
                lpIndex = cp._uplink;
            }
            if (lpIndex != 0) {
                Page pp = pc.getPage(lpIndex, group);
                pp._parent = cp;
                cp = pp;
                continue;
            }
            found = cp;
        } while (found == null);
        return found;
    }

    static Page addRecordInPage(BPageCache pc, Page p, int group, Record rec) throws IOException {
        Page res = null;
        int pos = Page.findIPointInPage(p, rec.key);
        p._dirty = true;
        if (p._count < 128) {
            if (pos < p._count) {
                System.arraycopy(p._records, pos, p._records, pos + 1, p._count - pos);
            }
            ++p._count;
            p._records[pos] = rec;
        } else {
            Record[] nrecs = new Record[129];
            System.arraycopy(p._records, 0, nrecs, 0, pos);
            nrecs[pos] = rec;
            System.arraycopy(p._records, pos, nrecs, pos + 1, p._count - pos);
            Page parent = p._parent;
            if (parent == null) {
                if (_flipflop) {
                    _flipflop = false;
                    int npIndex = pc.getNewPage(group);
                    Page newPage = pc.getPage(npIndex, group);
                    newPage._parent = p;
                    for (int i = 0; i < 64; ++i) {
                        newPage._records[i] = nrecs[i];
                        p._records[i] = nrecs[i + 64];
                        p._records[64 + i] = null;
                    }
                    p._records[64] = nrecs[128];
                    p._count = 65;
                    newPage._uplink = p._records[0].link;
                    if (newPage._uplink != 0) {
                        pc.getPage((int)newPage._uplink, (int)group)._parent = newPage;
                    }
                    newPage._count = 64;
                    p._records[0].link = npIndex;
                    newPage._dirty = true;
                } else {
                    _flipflop = true;
                    int npIndex = pc.getNewPage(group);
                    Page newPage = pc.getPage(npIndex, group);
                    newPage._parent = p;
                    for (int i = 0; i < 64; ++i) {
                        newPage._records[i] = nrecs[i + 64];
                        p._records[i] = nrecs[i];
                        p._records[64 + i] = null;
                    }
                    newPage._records[64] = nrecs[128];
                    newPage._count = 65;
                    newPage._uplink = p._uplink;
                    if (newPage._uplink != 0) {
                        pc.getPage((int)newPage._uplink, (int)group)._parent = newPage;
                    }
                    p._uplink = npIndex;
                    p._count = 64;
                    newPage._dirty = true;
                }
            } else {
                int npIndex = pc.getNewPage(group);
                Page newPage = pc.getPage(npIndex, group);
                newPage._parent = p;
                for (int i = 0; i < 64; ++i) {
                    p._records[i] = nrecs[65 + i];
                    p._records[64 + i] = null;
                    newPage._records[i] = nrecs[i];
                }
                newPage._dirty = true;
                Record toaddup = nrecs[64];
                p._count = 64;
                newPage._count = 64;
                newPage._uplink = toaddup.link;
                if (toaddup.link != 0) {
                    pc.getPage((int)toaddup.link, (int)group)._parent = newPage;
                }
                toaddup.link = npIndex;
                res = Page.addRecordInPage(pc, parent, group, toaddup);
            }
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._count; ++i) {
            Record record = this._records[i];
            sb.append(record.key);
            sb.append("->");
            sb.append(record.link);
            sb.append(", ");
        }
        sb.append(" =>");
        sb.append(this._uplink);
        sb.append(" ");
        sb.append(this._dirty);
        return sb.toString();
    }

    static void addEntry(BPageCache pc, int group, int pindex, String k, int ref) throws IOException {
        Page p = pc.getPage(pindex, group);
        Record r = new Record();
        r.key = k;
        r.dataAddress = ref;
        Page cp = Page.findFromPage(pc, group, p, k);
        Page.addRecordInPage(pc, cp, group, r);
    }

    static void updateEntry(BPageCache pc, int group, int pindex, String k, int ref) throws IOException {
        Page p = pc.getPage(pindex, group);
        Page cp = Page.findFromPage(pc, group, p, k);
        int ipoint = Page.findIPointInPage(cp, k);
        if (ipoint < cp._count && k.equals(cp._records[ipoint].key)) {
            cp._records[ipoint].dataAddress = ref;
            cp._dirty = true;
        }
    }

    static int getEntry(BPageCache pc, int group, int pindex, String k) throws IOException {
        Page p = pc.getPage(pindex, group);
        Page cp = Page.findFromPage(pc, group, p, k);
        int ipoint = Page.findIPointInPage(cp, k);
        if (ipoint < cp._count && k.equals(cp._records[ipoint].key)) {
            return cp._records[ipoint].dataAddress;
        }
        return -1;
    }

    static String getPreviousEntry(BPageCache pc, int group, int pindex, String k) throws IOException {
        String res;
        int ind;
        Page p = pc.getPage(pindex, group);
        int nl = p._uplink;
        for (ind = p._count - 1; ind >= 0 && k.compareTo(p._records[ind].key) <= 0; --ind) {
            nl = p._records[ind].link;
        }
        if (nl != 0 && (res = Page.getPreviousEntry(pc, group, nl, k)) != null) {
            return res;
        }
        if (ind < 0) {
            return null;
        }
        Record r = p._records[ind];
        return r.key;
    }

    private static String getNextEntryInt(BPageCache pc, int group, int pindex, String k) throws IOException {
        String res;
        int ind;
        Page p = pc.getPage(pindex, group);
        for (ind = 0; ind < p._count && k.compareTo(p._records[ind].key) >= 0; ++ind) {
        }
        if (ind == p._count) {
            if (p._uplink != 0) {
                return Page.getNextEntryInt(pc, group, p._uplink, k);
            }
            return null;
        }
        Record r = p._records[ind];
        if (r.link != 0 && (res = Page.getNextEntryInt(pc, group, r.link, k)) != null) {
            return res;
        }
        return r.key;
    }

    static String getNextEntry(BPageCache pc, int group, int pindex, String k) throws IOException {
        return Page.getNextEntryInt(pc, group, pindex, k);
    }

    static String getPreviousEntryIgnoreCase(BPageCache pc, int group, int pindex, String k) throws IOException {
        int ind;
        Page p = pc.getPage(pindex, group);
        int nl = p._uplink;
        for (ind = p._count - 1; ind >= 0 && k.compareToIgnoreCase(p._records[ind].key) < 0; --ind) {
            nl = p._records[ind].link;
        }
        if (nl != 0) {
            return Page.getPreviousEntryIgnoreCase(pc, group, nl, k);
        }
        if (ind < 0) {
            return null;
        }
        Record r = p._records[ind];
        return r.key;
    }

    static String getNextEntryIgnoreCase(BPageCache pc, int group, int pindex, String k) throws IOException {
        String res;
        int ind;
        Page p = pc.getPage(pindex, group);
        for (ind = 0; ind < p._count && k.compareToIgnoreCase(p._records[ind].key) >= 0; ++ind) {
        }
        if (ind == p._count) {
            if (p._uplink != 0) {
                return Page.getNextEntryIgnoreCase(pc, group, p._uplink, k);
            }
            return null;
        }
        Record r = p._records[ind];
        if (r.link != 0 && (res = Page.getNextEntryIgnoreCase(pc, group, r.link, k)) != null) {
            return res;
        }
        return r.key;
    }

    static Record findLeftMostRecord(BPageCache pc, int group, int pindex) throws IOException {
        Page p = pc.getPage(pindex, group);
        Record r = p._records[0];
        if (r.link == 0) {
            return r;
        }
        return Page.findLeftMostRecord(pc, group, r.link);
    }

    static Record findRightMostRecord(BPageCache pc, int group, int pindex) throws IOException {
        Page p = pc.getPage(pindex, group);
        if (p._uplink == 0) {
            Record other;
            Record r = p._records[p._count - 1];
            if (r.link == 0) {
                --p._count;
                p._records[p._count] = null;
                p._dirty = true;
                if (p._count != 0) {
                    r.link = pindex;
                } else {
                    pc.freePage(pindex);
                }
                return r;
            }
            Page pp = pc.getPage(r.link, group);
            pp._parent = p;
            p._records[p._count - 1] = other = Page.findRightMostRecord(pc, group, r.link);
            p._dirty = true;
            if (other.link == 0) {
                pc.freePage(r.link);
            }
            r.link = pindex;
            return r;
        }
        Page pp = pc.getPage(p._uplink, group);
        pp._parent = p;
        Record other = Page.findRightMostRecord(pc, group, p._uplink);
        if (other.link == 0) {
            pc.freePage(p._uplink);
            p._uplink = 0;
        }
        other.link = pindex;
        p._dirty = true;
        return other;
    }

    static Record findAndRemove(BPageCache pc, int group, Page p, String k) throws IOException {
        int pos = Page.findIPointInPage(p, k);
        if (pos < p._count) {
            Record r = p._records[pos];
            if (k.equals(r.key)) {
                p._dirty = true;
                if (r.link != 0) {
                    Record other;
                    pc.getPage((int)r.link, (int)group)._parent = p;
                    p._records[pos] = other = Page.findRightMostRecord(pc, group, r.link);
                    return null;
                }
                --p._count;
                System.arraycopy(p._records, pos + 1, p._records, pos, p._count - pos);
                p._records[p._count] = null;
                if (p._count != 0) {
                    return null;
                }
                if (p._uplink != 0) {
                    Record other;
                    p._records[0] = other = Page.findRightMostRecord(pc, group, p._uplink);
                    ++p._count;
                    p._uplink = 0;
                    return null;
                }
                return r;
            }
            if (r.link != 0) {
                Page pp = pc.getPage(r.link, group);
                pp._parent = p;
                Record other = Page.findAndRemove(pc, group, pp, k);
                if (other != null) {
                    pc.freePage(r.link);
                    r.link = 0;
                    p._dirty = true;
                }
                return null;
            }
        } else if (p._uplink != 0) {
            Page pp = pc.getPage(p._uplink, group);
            pp._parent = p;
            Record other = Page.findAndRemove(pc, group, pp, k);
            if (other != null) {
                pc.freePage(p._uplink);
                p._uplink = 0;
                p._dirty = true;
            }
            return null;
        }
        return null;
    }

    static void removeString(BPageCache pc, int group, int pindex, String k) throws IOException {
        Page p = pc.getPage(pindex, group);
        Page.findAndRemove(pc, group, p, k);
    }

    static void checkPage(String mess, BPageCache pc, int group, int pindex, String k, boolean smaller) throws IOException {
        Page p = pc.getPage(pindex, group);
        String lk = null;
        for (int i = 0; i < p._count; ++i) {
            Record r = p._records[i];
            if (k != null) {
                if (smaller) {
                    if (k.compareTo(r.key) <= 0) {
                        throw new IOException("Structure error: " + group + "/" + pindex + " key " + r.key + " not smaller than " + k + mess);
                    }
                } else if (k.compareTo(r.key) >= 0) {
                    throw new IOException("Structure error: " + group + "/" + pindex + " key " + r.key + " not bigger than " + k + mess);
                }
            }
            if (r.link != 0) {
                Page.checkPage(mess, pc, group, r.link, r.key, true);
            }
            lk = r.key;
        }
        if (p._uplink != 0) {
            Page.checkPage(mess, pc, group, p._uplink, lk, false);
        }
    }

    static void printAllPages(BPageCache pc, int group, int pindex) {
        try {
            Page p = pc.getPage(pindex, group);
            p.printPage(pc, group, "");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class Record {
        String key;
        int link;
        int dataAddress;

        Record() {
        }
    }
}

