/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.NameSpaceFactory;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.DefaultNameSpace;
import oracle.ideimpl.persistence.PersistenceLogger;
import oracle.ideimpl.persistence.StorageFile;

public final class DefaultNameSpaceFactory
implements NameSpaceFactory {
    private static final HashMap<String, StorageFile> STORAGE_FILES = new HashMap();
    private static final String DEFSTORENAME = "anspersist";
    private static final int MAX_RETRIES = 5;
    private static final Iterator<String> EMPTY_ITERATOR = new Iterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private static StorageFile open(String s) {
        try {
            for (int i = 0; i < 5; ++i) {
                StorageFile sf = new StorageFile(s + "_" + i);
                if (!sf.open()) continue;
                return sf;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StorageFile getStorageFile(String location) {
        HashMap<String, StorageFile> hashMap = STORAGE_FILES;
        synchronized (hashMap) {
            StorageFile sf = STORAGE_FILES.get(location);
            if (sf == null) {
                sf = DefaultNameSpaceFactory.open(location + File.separator + DEFSTORENAME);
                STORAGE_FILES.put(location, sf);
            }
            return sf;
        }
    }

    @Override
    public NameSpace getNameSpace(String location, String name, int type, SecondaryKeyProvider provider) {
        DefaultNameSpace ns = null;
        StorageFile sf = DefaultNameSpaceFactory.getStorageFile(location);
        if (sf != null) {
            try {
                ns = sf.getNameSpace(name, type);
                ns._store = sf;
                return ns;
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get namespace " + name + " from " + location, ex);
            }
        }
        return ns;
    }

    @Override
    public Iterator<String> getNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        StorageFile sf = DefaultNameSpaceFactory.getStorageFile(location);
        if (sf != null) {
            return sf.getNameSpaceIterator(prefix, ignorecase);
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public Iterator<String> getReverseNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        StorageFile sf = DefaultNameSpaceFactory.getStorageFile(location);
        if (sf != null) {
            return sf.getReverseNameSpaceIterator(prefix, ignorecase);
        }
        return EMPTY_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStorage(String location) {
        HashMap<String, StorageFile> hashMap = STORAGE_FILES;
        synchronized (hashMap) {
            StorageFile sf = STORAGE_FILES.get(location);
            if (sf != null) {
                sf.close();
                STORAGE_FILES.remove(location);
            }
        }
    }

    @Override
    public void deleteNameSpace(String location, String name) {
        StorageFile sf = DefaultNameSpaceFactory.getStorageFile(location);
        if (sf != null) {
            try {
                DefaultNameSpace ns = sf.getNameSpace(name, 0);
                sf.deleteNameSpace(ns);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete namespace " + name, ex);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

