/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XSLTransformUtil {
    private XSLTransformUtil() {
    }

    public static void transformFile(File sourceFile, File targetFile, URL stylesheetURL) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource stylesheetSource = new StreamSource(stylesheetURL.toString());
            Transformer transformer = transformerFactory.newTransformer(stylesheetSource);
            StreamSource oldSource = new StreamSource(sourceFile);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(targetFile);
            StreamResult outputFile = new StreamResult(fos);
            transformer.transform(oldSource, outputFile);
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new IOException(tce.getMessage());
        }
        catch (TransformerException te) {
            te.printStackTrace();
            throw new IOException(te.getMessage());
        }
    }

    public static void transformFile(URL sourceURL, URL targetURL, URL stylesheetURL) throws IOException {
        try {
            File inFile = new File(sourceURL.toURI());
            File outFile = new File(targetURL.toURI());
            XSLTransformUtil.transformFile(inFile, outFile, stylesheetURL);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (URISyntaxException uriex) {
            uriex.printStackTrace();
        }
    }
}

