/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.javatools.buffer.TextBuffer;

public final class TextBufferStreamFactory {
    public static InputStream getInputStream(TextBuffer textBuffer) {
        return TextBufferStreamFactory.getInputStream(textBuffer, null);
    }

    public static InputStream getInputStream(TextBuffer textBuffer, String encoding) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        char[] charData = TextBufferStreamFactory.getCharData(textBuffer);
        byte[] byteData = TextBufferStreamFactory.char2Byte(charData, encoding);
        return new ByteArrayInputStream(byteData);
    }

    public static OutputStream getOutputStream(TextBuffer textBuffer) {
        return TextBufferStreamFactory.getOutputStream(textBuffer, null);
    }

    public static OutputStream getOutputStream(final TextBuffer textBuffer, final String encoding) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        textBuffer.writeLock();
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] byteData = this.toByteArray();
                String stringData = encoding != null ? new String(byteData, encoding) : new String(byteData);
                char[] charData = stringData.toCharArray();
                int length = textBuffer.getLength();
                textBuffer.remove(0, length);
                textBuffer.insert(0, charData);
                textBuffer.writeUnlock();
            }
        };
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] getCharData(TextBuffer textBuffer) {
        textBuffer.readLock();
        try {
            int length = textBuffer.getLength();
            char[] cArray = textBuffer.getChars(0, length);
            return cArray;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private static byte[] char2Byte(char[] charData, String encoding) {
        String stringData = new String(charData);
        if (encoding != null) {
            try {
                return stringData.getBytes(encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringData.getBytes();
    }
}

