/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.DialogsArb;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.ui.Colors;

public abstract class DeleteActionHandler<T extends Element> {
    private ActionDescriptionPanel m_actionDescriptionPanel;
    private DetailDialog m_detailDialog = null;
    private final JLabel m_statusLabel = new JLabel();
    private boolean m_detailDialogOKed = false;
    private final List<T> m_nodes;
    private Context m_context = null;
    private boolean m_silentMode = false;
    private static final DeleteStrategy<Node> m_defaultNodeDeleteStrategy = new NodeDeleteStrategy();
    private DeleteStrategy m_deleteStrategy = new NodeDeleteStrategy();

    public final void setSilentMode(boolean silent) {
        this.m_silentMode = silent;
    }

    public final boolean isSilent() {
        return this.m_silentMode;
    }

    public final Context getContext() {
        return this.m_context;
    }

    public final void setContext(Context context) {
        this.m_context = context;
    }

    protected final List<T> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    protected abstract DetailsTextConfig getDetailsTextConfig();

    protected abstract Component createDeleteDetailsComponent();

    protected void preLaunchDialog() {
    }

    public void doit() {
        UpdateMessage update = this.createUpdateMessage();
        CloseNodeCommand clsCmd = new CloseNodeCommand(update);
        clsCmd.setContext(this.getContext());
        clsCmd.setNeedConfirm(false);
        int status = clsCmd.close(this.getNodes(), false, false);
        if (status != 0) {
            // empty if block
        }
        for (Element element : this.getNodes()) {
            if (this.getDeleteStrategy().delete(element) || !(element instanceof Node)) continue;
            this.getDeleteStrategy().addToNondeleted(((Node)element).getURL());
        }
        if (this.getDeleteStrategy().getNondeleted().size() > 0) {
            this.handleNonDeletedURLs(this.getDeleteStrategy().getNondeleted());
        }
    }

    protected void handleNonDeletedURLs(List<URL> urls) {
        if (!this.m_silentMode) {
            DetailDialog nonDeleteDialog = DetailDialog.createDetailDialog(null, (String)DeleteDialogArb.getString(29), (int)1);
            JList<String> urlsContent = new JList<String>(DeleteActionHandler.convertAllToDisplayStrings(urls));
            urlsContent.setForeground(Colors.HINT_TEXT);
            MessagePanel messagePanel = new MessagePanel();
            messagePanel.setTitle(DeleteDialogArb.getString(30));
            messagePanel.setMessageText(DeleteDialogArb.getString(31));
            messagePanel.setMessageType(3);
            nonDeleteDialog.setContent((Component)messagePanel);
            nonDeleteDialog.setDetailContent((Component)new JScrollPane(urlsContent));
            nonDeleteDialog.runDialog();
        } else {
            for (URL uRL : urls) {
            }
        }
    }

    private static String[] convertAllToDisplayStrings(List<URL> urls) {
        ArrayList<String> resultFiles = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            resultFiles.add(DeleteActionHandler.urlToFile(url));
        }
        return resultFiles.toArray(new String[urls.size()]);
    }

    private UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 21);
        return message;
    }

    static String urlToFile(URL fileUrl) {
        File file;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        return file.getPath();
    }

    public boolean requireConfirm() {
        return this.getDetailsTextConfig().getConfirmTitle() != null && this.getDetailsTextConfig().getConfirmMessage() != null;
    }

    protected boolean hasOptions() {
        return false;
    }

    protected DeleteOption selectedOption(int optionIndex) {
        throw new UnsupportedOperationException("selectedOption(int) not supported");
    }

    public final void setSelectedOption(int index) {
        if (!this.hasOptions()) {
            throw new UnsupportedOperationException("setSelectedOption");
        }
        this.m_actionDescriptionPanel.setSelectedOption(index);
    }

    public final void setStatus(String text, Icon icon) {
        this.m_statusLabel.setText(text);
        this.m_statusLabel.setIcon(icon);
        this.m_statusLabel.getParent().repaint();
    }

    public final void clearStatus() {
        this.setStatus("", null);
    }

    private final void initStatusLabel() {
        this.m_statusLabel.setText("");
        this.m_statusLabel.setIcon(null);
        this.m_statusLabel.setForeground(Colors.HINT_TEXT);
    }

    protected void selectedOptionChanged(DeleteOption deleteOption) {
        if (!this.hasOptions()) {
            throw new UnsupportedOperationException("selectedOptionChanged() not supported");
        }
        this.deleteDetailsAvailable(deleteOption == DeleteOption.EraseFromDisk);
    }

    protected final void deleteDetailsAvailable(boolean detailsAvailable) {
        this.m_detailDialog.setDetailsButtonEnabled(detailsAvailable);
    }

    public DeleteActionHandler(Context context) {
        this.m_context = context;
        this.m_nodes = ((SelectedNodesProvider)context.getProperty(SelectedNodesProvider.class.getName())).getSelectedNodes();
    }

    public DeleteActionHandler(List<T> nodes) {
        this.m_nodes = nodes;
    }

    public DetailDialog createDeleteConfirmationDialog(Component dialogOwner) {
        DetailsTextConfig textConfigs = this.getDetailsTextConfig();
        Component detailsComponent = this.createDeleteDetailsComponent();
        DetailDialog dd = DetailDialog.createDetailDialog((Component)dialogOwner, (String)textConfigs.getTitle(), (int)23);
        this.m_actionDescriptionPanel = ActionDescriptionPanel.build(textConfigs.getHeader(), textConfigs.getDescription(), textConfigs.getOptions());
        dd.setContent((Component)this.m_actionDescriptionPanel);
        dd.setResizable(true);
        if (textConfigs.getOptions() != null && textConfigs.getOptions().length > 0) {
            dd.setMinimumSize(530, 200);
        }
        dd.setOKButtonText(DialogsArb.getString(2));
        dd.setCancelButtonText(DialogsArb.getString(4));
        dd.setButtonTextWhenDetailsHidden(textConfigs.getShowDetails(), true);
        dd.setButtonTextWhenDetailsShown(textConfigs.getHideDetails(), false);
        dd.setButtonAlignment(2);
        dd.setDetailContent(detailsComponent);
        this.initStatusLabel();
        dd.setDetailsStatusLabel(this.m_statusLabel);
        dd.setDetailVisible(false);
        dd.setDetailsButtonEnabled(false);
        dd.setHelpTopicId(textConfigs.getHelpTopicId());
        if (this.hasOptions()) {
            this.m_actionDescriptionPanel.addSelectionChangedListener(new ActionDescriptionPanel.OptionSelectionChangedListener(){

                @Override
                public void selectionChanged(ActionDescriptionPanel.OptionSelectionChangedEvent e) {
                    DeleteActionHandler.this.selectedOptionChanged(DeleteActionHandler.this.selectedOption(e.getSelectedIndex()));
                }
            });
        }
        this.m_detailDialog = dd;
        dd.pack();
        return dd;
    }

    public boolean runDialog() {
        this.m_detailDialogOKed = this.m_detailDialog.runDialog();
        return this.m_detailDialogOKed;
    }

    public DeleteOption clarifyToDeleteOrToRemoveFromParentContainer(Component dialogOwner) {
        this.createDeleteConfirmationDialog(dialogOwner);
        this.preLaunchDialog();
        if (this.runDialog()) {
            if (DeleteOption.EraseFromDisk.equals((Object)this.getSelectedDeleteOption()) && this.requireConfirm()) {
                if (this.askToConfirm(dialogOwner)) {
                    return this.getSelectedDeleteOption();
                }
                return DeleteOption.Cancelled;
            }
            return this.getSelectedDeleteOption();
        }
        return DeleteOption.Cancelled;
    }

    public boolean askToConfirm(Component windowParent) {
        return MessageDialog.optionalConfirm((String)this.getClass().getName(), (Component)windowParent, (String)this.getDetailsTextConfig().getConfirmMessage(), (String)this.getDetailsTextConfig().getConfirmTitle(), null);
    }

    public DeleteOption getSelectedDeleteOption() {
        if (this.m_detailDialog.isShowing() || this.m_detailDialogOKed) {
            if (this.hasOptions()) {
                return this.selectedOption(this.m_actionDescriptionPanel.getSelectedOptionIndex());
            }
            return DeleteOption.EraseFromDisk;
        }
        return DeleteOption.Cancelled;
    }

    public static final DeleteStrategy<Node> getDefaultDeleteStrategy() {
        return m_defaultNodeDeleteStrategy;
    }

    public void setDeleteStrategy(DeleteStrategy deleteStrategy) {
        this.m_deleteStrategy = deleteStrategy;
    }

    public DeleteStrategy getDeleteStrategy() {
        return this.m_deleteStrategy;
    }

    public static interface LookupHelper {
        public Class<? extends DeleteActionHandler> lookup(Class<? extends Element> var1, Context var2);
    }

    public static interface SelectedNodesProvider<ElementType extends Element> {
        public List<ElementType> getSelectedNodes();
    }

    public static class NodeDeleteStrategy
    extends DeleteStrategy<Node> {
        @Override
        public boolean delete(Node node) {
            if (node.isOpen()) {
                try {
                    node.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            boolean succeeded = URLFileSystem.delete((URL)node.getURL());
            return succeeded;
        }
    }

    @ThreadSafe
    public static abstract class DeleteStrategy<E extends Element> {
        private CopyOnWriteArrayList<URL> m_nondeleted = new CopyOnWriteArrayList();

        public abstract boolean delete(E var1);

        public final void addToNondeleted(URL url) {
            this.m_nondeleted.addIfAbsent(url);
        }

        public final void addAllToNondeleted(List<URL> urls) {
            this.m_nondeleted.addAllAbsent(urls);
        }

        public final List<URL> getNondeleted() {
            return this.m_nondeleted;
        }
    }

    public static class DetailsTextConfigBuilder {
        String m_showDetails = null;
        String m_hideDetails = null;
        String m_title = null;
        String m_header = null;
        String m_description = null;
        String[] m_options = null;
        String m_confirmTitle = null;
        String m_confirmMessage = null;
        String m_helpTopicId = null;

        public DetailsTextConfigBuilder title(String title) {
            this.m_title = title;
            return this;
        }

        public DetailsTextConfigBuilder header(String header) {
            this.m_header = header;
            return this;
        }

        public DetailsTextConfigBuilder description(String description) {
            this.m_description = description;
            return this;
        }

        public DetailsTextConfigBuilder showDetails(String showDetails) {
            this.m_showDetails = showDetails;
            return this;
        }

        public DetailsTextConfigBuilder hideDetails(String hideDetails) {
            this.m_hideDetails = hideDetails;
            return this;
        }

        public DetailsTextConfigBuilder options(String ... options) {
            this.m_options = options;
            return this;
        }

        public DetailsTextConfigBuilder confirmTitle(String confirmTitle) {
            this.m_confirmTitle = confirmTitle;
            return this;
        }

        public DetailsTextConfigBuilder confirmMessage(String confirmMessage) {
            this.m_confirmMessage = confirmMessage;
            return this;
        }

        public DetailsTextConfigBuilder helpTopicId(String helpTopicId) {
            this.m_helpTopicId = helpTopicId;
            return this;
        }

        public DetailsTextConfig build() {
            if (this.m_options == null || this.m_options.length == 0) {
                return new DetailsTextConfig(this.m_title, this.m_header, this.m_description, this.m_showDetails, this.m_hideDetails, this.m_confirmTitle, this.m_confirmMessage, this.m_helpTopicId, new String[0]);
            }
            return new DetailsTextConfig(this.m_title, this.m_header, this.m_description, this.m_showDetails, this.m_hideDetails, this.m_confirmTitle, this.m_confirmMessage, this.m_helpTopicId, this.m_options);
        }
    }

    public static final class DetailsTextConfig {
        final String m_showDetails;
        final String m_hideDetails;
        final String m_title;
        final String m_header;
        final String m_description;
        final String[] m_options;
        final String m_confirmTitle;
        final String m_confirmMessage;
        final String m_helpTopicId;

        DetailsTextConfig(String title, String header, String description, String showDetailsText, String hideDetailsText, String confirmTitle, String confirmMessage, String helpTopicId, String ... options) {
            this.m_showDetails = showDetailsText;
            this.m_hideDetails = hideDetailsText;
            this.m_title = title;
            this.m_header = header;
            this.m_description = description;
            this.m_options = options;
            this.m_confirmTitle = confirmTitle;
            this.m_confirmMessage = confirmMessage;
            this.m_helpTopicId = helpTopicId;
        }

        String getShowDetails() {
            return this.m_showDetails;
        }

        String getHideDetails() {
            return this.m_hideDetails;
        }

        String getTitle() {
            return this.m_title;
        }

        String getHeader() {
            return this.m_header;
        }

        String getDescription() {
            return this.m_description;
        }

        String[] getOptions() {
            return this.m_options;
        }

        String getConfirmTitle() {
            return this.m_confirmTitle;
        }

        String getConfirmMessage() {
            return this.m_confirmMessage;
        }

        String getHelpTopicId() {
            return this.m_helpTopicId;
        }
    }

    public static enum DeleteOption {
        EraseFromDisk,
        RemoveFromParent,
        Cancelled;

    }
}

