/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TitledPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

final class ProjectPropertiesMDDPanel
extends MDDPanel {
    private JButton customizeButton;
    private JRadioButton useCustomSettingsOption;
    private JRadioButton useProjectSettingsOption;
    private JPanel userSharedOptionsPanel;
    private JPanel propertiesPanel;
    private JPanel content;
    private Border lineBorder;
    Namespace propertyData;
    private boolean optionsAreVisible;
    private HashMap stateMap = new HashMap();
    private static final String USER_PROPERTIES_ACTIVE = "userPropertiesAreActive";

    ProjectPropertiesMDDPanel(Navigable[] rootNavigables, boolean useDetailTree, Namespace propertyData, String objectLabel) {
        super(rootNavigables, useDetailTree);
        this.addMDDListener((MDDListener)new TraversableListener());
        this.propertyData = propertyData;
        ResourceUtils.resButton((AbstractButton)this.useProjectSettingsOption, (String)ProjectPropertiesArb.format(4, objectLabel));
    }

    protected TitledPanel createTitledPanel(JPanel propertyPanel) {
        this.propertiesPanel = propertyPanel;
        this.lineBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.propertiesPanel.setBorder(this.lineBorder);
        this.content = new JPanel(new BorderLayout(0, 3));
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.content.add((Component)this.createOptionsPanel(), "North");
        this.content.add((Component)this.propertiesPanel, "Center");
        TitledPanel tPanel = new TitledPanel((Component)this.content);
        tPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.optionsAreVisible = true;
        return tPanel;
    }

    private boolean loadDialog() {
        Navigable navigable = this.getCurrentNavigable();
        Traversable traversable = navigable.newTraversable((ApplyNotifier)this);
        String name = navigable.getShortLabel();
        String title = ProjectPropertiesArb.format(0, name);
        this.propertyData.put("IsUserPropertyData", (Object)Boolean.TRUE);
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)Ide.getMainWindow()), title, traversable, this.propertyData);
        JEWTDialog dlg = launcher.initDialog();
        dlg.pack();
        dlg.setMaximumInitialSize(500, 420);
        boolean okay = launcher.showDialog();
        launcher.dispose();
        this.propertyData.put("IsUserPropertyData", (Object)Boolean.FALSE);
        return okay;
    }

    private JPanel createOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.userSharedOptionsPanel = new JPanel(gridBagLayout);
        this.customizeButton = new JButton();
        this.customizeButton.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this.customizeButton, (String)ProjectPropertiesArb.getString(1));
        this.customizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesMDDPanel.this.loadDialog();
            }
        });
        this.useCustomSettingsOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useCustomSettingsOption, (String)ProjectPropertiesArb.getString(3));
        this.useProjectSettingsOption = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.useCustomSettingsOption);
        group.add(this.useProjectSettingsOption);
        this.useProjectSettingsOption.setSelected(true);
        OptionListener listener = new OptionListener();
        this.useCustomSettingsOption.addItemListener(listener);
        this.useProjectSettingsOption.addItemListener(listener);
        this.userSharedOptionsPanel.add((Component)this.useCustomSettingsOption, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.userSharedOptionsPanel.add((Component)this.customizeButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.userSharedOptionsPanel.add((Component)this.useProjectSettingsOption, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.userSharedOptionsPanel;
    }

    private void setPanelEnabled(Container container, boolean enable) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Container)) continue;
            try {
                this.setPanelEnabled((Container)children[i], enable);
            }
            catch (Exception e) {
                // empty catch block
            }
            children[i].setEnabled(enable);
        }
    }

    private void setOptionsPanelVisible(boolean visible) {
        if (visible) {
            if (!this.optionsAreVisible) {
                this.content.add((Component)this.userSharedOptionsPanel, "North");
                this.propertiesPanel.setBorder(this.lineBorder);
            }
        } else if (this.optionsAreVisible) {
            this.content.remove(this.userSharedOptionsPanel);
            this.propertiesPanel.setBorder(null);
        }
        this.optionsAreVisible = visible;
    }

    private void storePanelState(DefaultTraversablePanel panel, boolean userPropertiesAreActive) {
        if (userPropertiesAreActive) {
            this.stateMap.put(panel, USER_PROPERTIES_ACTIVE);
        } else {
            this.stateMap.put(panel, null);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this.useCustomSettingsOption.isSelected()) {
            super.onExit(tc);
        }
        Iterator iter = this.stateMap.keySet().iterator();
        while (iter.hasNext()) {
            try {
                ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)((Object)iter.next());
                boolean userProperties = this.stateMap.get((Object)panel) != null;
                panel.activateProperties(tc, userProperties);
            }
            catch (Exception exception) {}
        }
        this.stateMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRadioButtonsAndPanelState(boolean isUseCustomProperties) {
        try {
            Ide.getWaitCursor().show();
            if (isUseCustomProperties) {
                this.customizeButton.setEnabled(true);
                this.setPanelEnabled(this.propertiesPanel, false);
                ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)this.getCurrentTraversable();
                if (this.stateMap.containsKey((Object)panel) && this.stateMap.get((Object)panel) == null) {
                    try {
                        TraversableContext tc = this.newTraversableContext();
                        this.getCurrentTraversable().onExit(tc);
                        panel.activateProperties(tc, true);
                    }
                    catch (TraversalException traversalException) {}
                }
            } else {
                this.customizeButton.setEnabled(false);
                this.setPanelEnabled(this.propertiesPanel, true);
                this.getCurrentTraversable().onEntry(this.newTraversableContext());
            }
            this.storePanelState((DefaultTraversablePanel)this.getCurrentTraversable(), isUseCustomProperties);
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    private class TraversableListener
    extends MDDAdapter {
        private TraversableListener() {
        }

        public void traversableEntered(MDDEvent e) {
            Traversable t = e.getTraversable();
            if (!(t instanceof ProjectSettingsTraversablePanel)) {
                throw new RuntimeException("Error in: " + t.getClass().getName() + "\nProject Properties panels must extend oracle.ide.model.panels.ProjectSettingsTraversablePanel");
            }
            ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)e.getTraversable();
            if (panel.isUserOnly()) {
                ProjectPropertiesMDDPanel.this.setOptionsPanelVisible(false);
            } else {
                boolean userPropertiesAreActive;
                ProjectPropertiesMDDPanel.this.setOptionsPanelVisible(true);
                if (ProjectPropertiesMDDPanel.this.stateMap.containsKey((Object)panel)) {
                    Object value = ProjectPropertiesMDDPanel.this.stateMap.get((Object)panel);
                    userPropertiesAreActive = value != null;
                } else {
                    userPropertiesAreActive = panel.arePropertiesOverridden();
                    ProjectPropertiesMDDPanel.this.storePanelState(panel, userPropertiesAreActive);
                }
                if (userPropertiesAreActive) {
                    if (ProjectPropertiesMDDPanel.this.useCustomSettingsOption.isSelected()) {
                        ProjectPropertiesMDDPanel.this.updateRadioButtonsAndPanelState(true);
                    }
                    ProjectPropertiesMDDPanel.this.useCustomSettingsOption.setSelected(true);
                } else {
                    if (ProjectPropertiesMDDPanel.this.useProjectSettingsOption.isSelected()) {
                        ProjectPropertiesMDDPanel.this.updateRadioButtonsAndPanelState(false);
                    }
                    ProjectPropertiesMDDPanel.this.useProjectSettingsOption.setSelected(true);
                }
            }
        }
    }

    private final class OptionListener
    implements ItemListener {
        private OptionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ProjectPropertiesMDDPanel.this.updateRadioButtonsAndPanelState(e.getSource() == ProjectPropertiesMDDPanel.this.useCustomSettingsOption);
            }
        }
    }
}

