/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;

public class WorkspaceMigrator
extends HashStructureNodeMigrator {
    public static final String MIGRATOR_NAME = Workspace.class.getName();
    public static final String WORKSPACE_NODE = "workspace-node-instance";

    @Override
    public List getPages(MigrationInfo[] infos, TraversableContext context) {
        List pages = this.getChildrenPages(infos, context);
        pages.addAll(super.getPages(infos, context));
        return pages;
    }

    @Override
    String getRootQname() {
        return "jws:workspace";
    }

    @Override
    protected final void preMigrate(MigrationInfo[] infos, TraversableContext context) {
        for (MigrationInfo info : infos) {
            Node node = info.getNode();
            node.setMigrating();
            NodeMigrationTracker.getInstance().startTracking(node.getURL());
        }
        this.initContext(infos, context);
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            MigrationInfo[] cinfos;
            List list = (List)entry.getValue();
            for (MigrationInfo info : cinfos = list.toArray(new MigrationInfo[list.size()])) {
                Node node = info.getNode();
                node.setMigrating();
                NodeMigrationTracker.getInstance().startTracking(node.getURL());
            }
        }
    }

    @Override
    protected final void postMigrate(MigrationInfo[] infos, TraversableContext context) {
        boolean fireEvents = false;
        for (MigrationInfo info : infos) {
            this.maybeUpdateMigrationStatus(info);
            fireEvents = info.getMigrationStatus() == MigrationInfo.MIGRATION_DONE;
            info.getNode().unsetMigrating(fireEvents);
        }
        boolean checkProjectMigrationStatus = true;
        Workspace workspace = (Workspace)infos[0].getNode();
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            MigrationInfo[] cinfos;
            List list = (List)entry.getValue();
            for (MigrationInfo info : cinfos = list.toArray(new MigrationInfo[list.size()])) {
                if (checkProjectMigrationStatus && info.getMigrationStatus() == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
                    checkProjectMigrationStatus = false;
                    NodeMigrationTracker.getInstance().startTracking(workspace.getURL());
                }
                this.maybeUpdateMigrationStatus(info);
                Node node = info.getNode();
                fireEvents = info.getMigrationStatus() == MigrationInfo.MIGRATION_DONE;
                node.unsetMigrating(fireEvents);
            }
        }
    }

    private void maybeUpdateMigrationStatus(MigrationInfo info) {
        MigrationInfo.MigrationStatus migrationStatus = info.getMigrationStatus();
        if (migrationStatus == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
            NodeMigrationTracker.getInstance().startTracking(info.getNode().getURL());
            info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
        } else if (migrationStatus == MigrationInfo.MIGRATION_DONE) {
            NodeMigrationTracker.getInstance().stopTracking(info.getNode().getURL());
        }
    }

    @Override
    protected String getMsg(MigrationInfo[] infos) {
        String product = IdeArb.format(390, Version.NAME_SHORT, Version.VER);
        if (infos.length > 1) {
            return IdeArb.format(398, product);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(396, fname, product);
    }

    @Override
    protected String getTitle() {
        return IdeArb.getString(391);
    }

    @Override
    protected String getSummaryMsg(MigrationInfo[] infos) {
        if (infos.length > 1) {
            return IdeArb.getString(399);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(397, fname);
    }

    private void initContext(MigrationInfo[] infos, TraversableContext context) {
        for (MigrationInfo info : infos) {
            this.initContext(info, context);
        }
    }

    private List getChildrenPages(MigrationInfo[] infos, TraversableContext context) {
        ArrayList pages = new ArrayList();
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            NodeMigrator migrator = (NodeMigrator)entry.getKey();
            List list = (List)entry.getValue();
            MigrationInfo[] cinfos = list.toArray(new MigrationInfo[list.size()]);
            pages.addAll(migrator.getPages(cinfos, context));
        }
        return pages;
    }

    private void initContext(MigrationInfo info, TraversableContext context) {
        Workspace workspace = (Workspace)info.getNode();
        Iterator<Element> children = workspace.getChildren();
        Map map = this.getInfoToMigratorMap(context);
        context.put(WORKSPACE_NODE, (Object)workspace);
        while (children.hasNext()) {
            Element child = children.next();
            if (!(child instanceof Node)) continue;
            Node node = (Node)child;
            if (URLFileSystem.exists((URL)node.getURL())) {
                String key = NodeMigrator.getLookupKey(node);
                NodeMigrator migrator = NodeMigrator.getNodeMigrator(key);
                if (migrator == null) continue;
                MigrationInfo childInfo = migrator.getMigrationInfo(node);
                this.mapInfoToMigrator(migrator, childInfo, map);
                continue;
            }
            workspace.remove(node);
        }
    }

    @Override
    protected float getWeight() {
        return 0.0f;
    }
}

