/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class WorkingSets
extends HashStructureAdapter {
    @Deprecated
    public static final boolean ENABLED = Boolean.valueOf(System.getProperty("working.sets.enabled", "true"));
    public static final String ADD_TO_WORKING_SET_CMD = "working-set-add-to-working-set";
    @Deprecated
    public static int ADD_TO_WORKING_SET_CMD_ID;
    @Deprecated
    public static final String ADD_TO_WORKING_SET_MSG_KEY = "add-to-working-set";
    public static final String DEFAULT_WORKING_SET_LABEL;
    public static final String ALL_FILES_WORKING_SET_LABEL;
    public static final String DATA_KEY = "working-sets";
    private static final String CURRENT_WORKING_SET_NAME = ".current";

    private WorkingSets(HashStructure hash) {
        super(hash);
    }

    private WorkingSets(HashStructureNode node) {
        this(WorkingSets.getHashStructure(node));
        if (node != null) {
            node.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    WorkingSets.this.getWorkingSet(ALL_FILES_WORKING_SET_LABEL);
                    if (!ALL_FILES_WORKING_SET_LABEL.equals(WorkingSets.this.getCurrentWorkingSetName()) && WorkingSets.this.getWorkingSetNames().size() == 1) {
                        WorkingSets.this.getWorkingSet(DEFAULT_WORKING_SET_LABEL);
                        WorkingSets.this.setCurrentWorkingSetName(DEFAULT_WORKING_SET_LABEL);
                    }
                }
            });
        }
    }

    private static HashStructure getHashStructure(HashStructureNode node) {
        HashStructure userProps;
        if (node != null && (userProps = node.getPropertiesForOverriding()) != null) {
            return userProps.getOrCreateHashStructure(DATA_KEY);
        }
        return HashStructure.newInstance();
    }

    @Deprecated
    public static WorkingSets getInstance(Project project) {
        return new WorkingSets(HashStructure.newInstance());
    }

    public static WorkingSets getInstance(Workspace workspace) {
        return WorkingSets.getInstance((HashStructureNode)workspace);
    }

    private static WorkingSets getInstance(HashStructureNode node) {
        return new WorkingSets(node);
    }

    public WorkingSet getWorkingSet(String workingSetName) {
        return WorkingSet.getInstance(this._hash, workingSetName);
    }

    public static WorkingSet getOrCreateWorkingSet(final Workspace workspace, String name, final List<Project> includeProjects, final Map<URL, List<URL>> projectUrlToFileUrls) {
        if (workspace == null) {
            throw new NullPointerException("The Workspace cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("The working set name cannot be null");
        }
        if (includeProjects == null) {
            throw new NullPointerException("The project list cannot be null");
        }
        if (projectUrlToFileUrls == null) {
            throw new NullPointerException("The Map cannot be null");
        }
        WorkingSets instance = WorkingSets.getInstance(workspace);
        if (instance.getWorkingSetNames().contains(name)) {
            instance.deleteWorkingSet(name);
        }
        final WorkingSet workingSet = instance.getWorkingSet(name);
        workspace.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                for (Project project : includeProjects) {
                    List urls = (List)projectUrlToFileUrls.get(project.getURL());
                    workingSet.includeChildren(project, urls, true);
                }
                Iterator<Element> children = workspace.getChildren();
                while (children.hasNext()) {
                    Element child = children.next();
                    if (!(child instanceof Project) || includeProjects.contains(child)) continue;
                    workingSet.excludeProject((Project)child);
                }
            }
        });
        return workingSet;
    }

    static WorkingSets projectWorkingSets(HashStructure hash) {
        return new WorkingSets(hash);
    }

    public String getCurrentWorkingSetName() {
        return this._hash.getString(CURRENT_WORKING_SET_NAME);
    }

    public void setCurrentWorkingSetName(String name) {
        if (name == null) {
            throw new NullPointerException("The working set name is null.");
        }
        this._hash.putString(CURRENT_WORKING_SET_NAME, name, true);
    }

    public WorkingSet getCurrentWorkingSet() {
        String name = this.getCurrentWorkingSetName();
        if (name != null) {
            return this.getWorkingSet(name);
        }
        return null;
    }

    public List getWorkingSetNames() {
        ArrayList list = new ArrayList();
        list.addAll(this._hash.keySet());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (this._hash.getObject(key) instanceof HashStructure) continue;
            iter.remove();
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public void deleteWorkingSet(String workingSetName) {
        if (!CURRENT_WORKING_SET_NAME.equals(workingSetName) && !ALL_FILES_WORKING_SET_LABEL.equals(workingSetName)) {
            this._hash.remove(workingSetName);
        }
    }

    static synchronized void init() {
    }

    static {
        try {
            ADD_TO_WORKING_SET_CMD_ID = Ide.findOrCreateCmdID(ADD_TO_WORKING_SET_CMD);
        }
        catch (Exception e) {
            ADD_TO_WORKING_SET_CMD_ID = -1;
        }
        DEFAULT_WORKING_SET_LABEL = ModelArb.getString(59);
        ALL_FILES_WORKING_SET_LABEL = ModelArb.getString(60);
    }
}

