/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class WorkingSet
extends HashStructureAdapter {
    private final String _workingSetName;
    private final PatternFilters _patternFilters;
    private static final String EXCLUDE_PROJECT_URLS_KEY = "exclude-project-urls";
    private static final String PROJECT_WORKING_SETS_KEY = "project-working-sets";

    WorkingSet(HashStructure hash, String workingSetName) {
        super(hash);
        this._workingSetName = workingSetName;
        this._patternFilters = PatternFilters.getInstance(hash);
    }

    static WorkingSet getInstance(final HashStructure workingSetsHash, final String workingSetName) {
        final WorkingSet[] workingSetVar = new WorkingSet[1];
        workingSetsHash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                boolean isNew = !workingSetsHash.containsKey(workingSetName);
                HashStructure workingSetHash = workingSetsHash.getOrCreateHashStructure(workingSetName);
                WorkingSet workingSet = new WorkingSet(workingSetHash, workingSetName);
                if (isNew) {
                    PatternFilters filters = workingSet.getPatternFilters();
                    filters.addInclude("**");
                }
                workingSetVar[0] = workingSet;
            }
        });
        return workingSetVar[0];
    }

    public ListStructure getExcludedProjectList() {
        return this._hash.getListStructure(EXCLUDE_PROJECT_URLS_KEY);
    }

    public boolean isExcluded(Project project) {
        return !this.isIncluded(project);
    }

    public boolean isIncluded(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        ListStructure excludedProjectList = this.getExcludedProjectList();
        return excludedProjectList == null || !excludedProjectList.contains((Object)project.getURL());
    }

    public boolean includeProject(Project project) {
        if (!this.isIncluded(project)) {
            ListStructure projectURLs = this._hash.getListStructure(EXCLUDE_PROJECT_URLS_KEY);
            boolean removed = projectURLs.remove((Object)project.getURL());
            if (projectURLs.size() == 0) {
                this.includeAllProjects();
            }
            return removed;
        }
        return false;
    }

    public PatternFilters includeChildren(Project project, List<URL> children, boolean addChildrenExclusively) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        PatternFilters pfs = this.getPatternFilters(project);
        if (pfs == null) {
            if (addChildrenExclusively) {
                pfs = this.getOrCreatePatternFilters(project);
                pfs.setFilters(new PatternFilter[0]);
            } else {
                return pfs;
            }
        }
        if (children == null || children.size() == 0) {
            pfs.setFilters(new PatternFilter[0]);
        } else {
            ProjectContent content = ProjectContent.getInstance(project);
            Iterator iterator = content.getContentSetList().iterator();
            while (iterator.hasNext()) {
                ContentSet cs = content.getContentSet(iterator.next().toString());
                if (cs == null) continue;
                for (URL path : cs.getAllRootDirs().getEntries()) {
                    URLPath nextPath = new URLPath(path);
                    for (URL url : children) {
                        String relPath = nextPath.toRelativePath(url);
                        if (relPath == null || relPath.length() <= 0) continue;
                        pfs.addInclude(relPath);
                    }
                }
            }
        }
        return pfs;
    }

    public PatternFilters excludeChildren(Project project, List<URL> children) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        PatternFilters pfs = this.getOrCreatePatternFilters(project);
        if (children == null || children.size() == 0) {
            pfs.setFilters(new PatternFilter[0]);
        } else {
            ProjectContent content = ProjectContent.getInstance(project);
            Iterator iterator = content.getContentSetList().iterator();
            while (iterator.hasNext()) {
                ContentSet cs = content.getContentSet(iterator.next().toString());
                if (cs == null) continue;
                for (URL path : cs.getAllRootDirs().getEntries()) {
                    URLPath nextPath = new URLPath(path);
                    for (URL url : children) {
                        String relPath = nextPath.toRelativePath(url);
                        if (relPath == null || relPath.length() <= 0) continue;
                        pfs.addExclude(relPath);
                    }
                }
            }
        }
        return pfs;
    }

    public boolean excludeProject(Project project) {
        URL url;
        ListStructure exclude;
        if (this.isIncluded(project) && !(exclude = this._hash.getOrCreateListStructure(EXCLUDE_PROJECT_URLS_KEY)).contains((Object)(url = project.getURL()))) {
            return exclude.add((Object)url);
        }
        return false;
    }

    public void includeAllProjects() {
        this._hash.remove(EXCLUDE_PROJECT_URLS_KEY);
    }

    @Deprecated
    public static PatternFilters getCurrentWorkingSetFilters(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            WorkingSets workingSets = WorkingSets.getInstance(activeWorkspace);
            return workingSets.getCurrentWorkingSet().getPatternFilters(project);
        }
        return PatternFilters.getInstance(HashStructure.newInstance());
    }

    public PatternFilters getPatternFilters() {
        return this._patternFilters;
    }

    public PatternFilters getPatternFilters(Project project) {
        String key;
        WorkingSets projectWorkingSets;
        List namedProjectLevelWorkingSets;
        HashStructure hash;
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        if (this._hash.containsKey(PROJECT_WORKING_SETS_KEY) && (hash = this._hash.getHashStructure(PROJECT_WORKING_SETS_KEY)) != null && (namedProjectLevelWorkingSets = (projectWorkingSets = WorkingSets.projectWorkingSets(hash)).getWorkingSetNames()).contains(key = this.key(project.getURL()))) {
            return projectWorkingSets.getWorkingSet(key).getPatternFilters();
        }
        return null;
    }

    public PatternFilters getOrCreatePatternFilters(Project project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(this.getName())) {
            return PatternFilters.getInstance(HashStructure.newInstance());
        }
        WorkingSet ws = this.getWorkingSet(project);
        return ws.getPatternFilters();
    }

    public String getName() {
        return this._workingSetName;
    }

    private WorkingSet getWorkingSet(Project project) {
        WorkingSets projectWorkingSets = this.getProjectWorkingSets();
        String key = this.key(project.getURL());
        return projectWorkingSets.getWorkingSet(key);
    }

    private WorkingSets getProjectWorkingSets() {
        HashStructure hash = this._hash.getOrCreateHashStructure(PROJECT_WORKING_SETS_KEY);
        WorkingSets projectWorkingSets = WorkingSets.projectWorkingSets(hash);
        return projectWorkingSets;
    }

    private String key(URL url) {
        String key = url.toString();
        return key.replaceAll("/", "_");
    }

    private boolean isModifiable() {
        return !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(this.getName());
    }
}

