/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class UserPropertiesMigrator
implements Migrator {
    private static final int MY_CATEGORY = 0;

    @Override
    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    @Override
    public String getDescription(int category) {
        return "Custom Project Properties";
    }

    @Override
    public boolean canMigrate(int category, File sourceDir) {
        return category == 0;
    }

    @Override
    public void setSelected(int category, boolean selected) {
    }

    @Override
    public boolean isSelected(int category) {
        return category == 0;
    }

    @Override
    public String[] migrate(File srcDir, File dstDir) {
        URL dstProjectsDirURL;
        URL srcProjectsURL = UserPropertiesMigrator.getProjectsURL(srcDir);
        if (URLFileSystem.exists((URL)srcProjectsURL) && !this.maybeMigrateIndexXml(srcProjectsURL, dstProjectsDirURL = UserPropertiesMigrator.getProjectsURL(dstDir))) {
            this.maybeMigrateIndex2Xml(srcProjectsURL, dstProjectsDirURL);
        }
        return null;
    }

    private boolean maybeMigrateIndexXml(URL fromSourceDir, URL toTargetDir) {
        ListStructure index = null;
        URL srcIndexURL = UserPropertiesMigrator.getIndexURL(fromSourceDir);
        if (!URLFileSystem.exists((URL)srcIndexURL)) {
            return false;
        }
        ListStructureIO io = new ListStructureIO(null, "index");
        try {
            index = (ListStructure)io.load(srcIndexURL);
            if (index != null) {
                URL dstIndexURL = UserPropertiesMigrator.getIndexURL(toTargetDir);
                io.save(dstIndexURL, (Object)index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (index != null) {
            for (Object obj : index) {
                if (!(obj instanceof HashStructure)) continue;
                this.copyUserPropertiesFile(fromSourceDir, toTargetDir, (HashStructure)obj);
            }
        }
        return true;
    }

    private void maybeMigrateIndex2Xml(URL sourceFolder, URL targetFolder) {
        HashStructure index = null;
        URL srcIndexURL = UserPropertiesMigrator.getIndex2URL(sourceFolder);
        HashStructureIO io = new HashStructureIO(null, "index");
        try {
            index = (HashStructure)io.load(srcIndexURL);
            if (index != null) {
                URL dstIndexURL = UserPropertiesMigrator.getIndex2URL(targetFolder);
                io.save(dstIndexURL, (Object)index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (index != null) {
            for (String key : index.keySet()) {
                HashStructure userPropertiesHash = index.getHashStructure(key);
                this.copyUserPropertiesFile(sourceFolder, targetFolder, userPropertiesHash);
            }
        }
    }

    private void copyUserPropertiesFile(URL fromDir, URL toDir, HashStructure hash) {
        URL srcUserFileURL;
        String userFileName = hash.getString("user");
        if (userFileName != null && URLFileSystem.exists((URL)(srcUserFileURL = URLFactory.newURL((URL)fromDir, (String)userFileName)))) {
            URL dstUserFileURL = URLFactory.newURL((URL)toDir, (String)userFileName);
            try {
                HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                HashStructure jprHash = (HashStructure)io.load(srcUserFileURL);
                if (jprHash != null) {
                    io.save(dstUserFileURL, (Object)jprHash);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static URL getProjectsURL(File dir) {
        return URLFactory.newDirURL((File)new File(dir, "projects"));
    }

    private static URL getIndexURL(URL projectsDir) {
        return URLFactory.newURL((URL)projectsDir, (String)"index.xml");
    }

    private static URL getIndex2URL(URL projectsDir) {
        return URLFactory.newURL((URL)projectsDir, (String)"index2.xml");
    }
}

